-- phpMyAdmin SQL Dump
-- version 4.8.5
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Feb 10, 2023 at 06:48 PM
-- Server version: 10.1.38-MariaDB
-- PHP Version: 7.3.2

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `panos`
--

DELIMITER $$
--
-- Procedures
--
CREATE DEFINER=`local`@`localhost` PROCEDURE `AutomaticStocks` ()  BEGIN 
	DECLARE idTura INT DEFAULT 0;
	DECLARE isAutomatic INT DEFAULT 0;
    SELECT AutomaticStock INTO isAutomatic
    FROM TSerieF LIMIT 1;
    IF isAutomatic = 1 THEN
    
        INSERT INTO TTure 
        (DataOpen, DataClose, NumeUser, File) VALUES 
        (UNIX_TIMESTAMP(CURDATE()-1), UNIX_TIMESTAMP(CURDATE()), 
         'SYSTEM Managed', 'Not generated!');

        SELECT LAST_INSERT_ID() INTO idTura;

        CREATE TEMPORARY TABLE products AS
        SELECT ID ProdusId, idTura ShiftId, 0 StocI, Stoc, PretAchizitie
        FROM TProduse;

        UPDATE products p
        LEFT JOIN TStocuriTura st ON p.ProdusId = st.IDPRODUS AND st.IDTURA = (idTura-1)
        SET p.StocI = IFNULL(st.STOCFINAL, 0);

        INSERT INTO TStocuriTura (IDPRODUS, IDTURA, STOCINITIAL, STOCFINAL, PretA) 
        SELECT ProdusId, ShiftId, StocI, Stoc, PretAchizitie FROM products;

        DROP TEMPORARY TABLE IF EXISTS products;
    END IF;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `ClientMerge` ()  BEGIN 
    DECLARE c_Id INTEGER DEFAULT 0;
	DECLARE finished INTEGER DEFAULT 0;	
    DECLARE c_CUI VARCHAR(255) DEFAULT '';
	DECLARE curs CURSOR FOR 
	SELECT DISTINCT REPLACE(REPLACE(CIFCNP, 'RO', ''), 'ro', '') CUI
	FROM TClientiFactura;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET finished = 1;

	
	
	OPEN curs;
	read_loop: LOOP
		FETCH curs INTO c_CUI;
		IF finished 
        THEN
			LEAVE read_loop;
		END IF;
		
		CREATE TEMPORARY TABLE Clients as
		SELECT ID
		FROM TClientiFactura
		WHERE REPLACE(REPLACE(CIFCNP, 'RO', ''), 'ro', '') = c_CUI;

		SET c_Id = (SELECT * FROM Clients ORDER BY ID DESC LIMIT 1);

		UPDATE Avize
		SET ClientId = c_Id
		WHERE ClientId IN (SELECT * FROM Clients);

		UPDATE GestiuneClientiFacturi
		SET ClientId = c_Id
		WHERE ClientId IN (SELECT * FROM Clients);

		UPDATE TFacturi
		SET IDFurnizor = c_Id
		WHERE IDFurnizor IN (SELECT * FROM Clients);

		DELETE FROM TClientiFactura
		WHERE ID in (SELECT * FROM Clients) AND ID != c_Id;

		DROP TEMPORARY TABLE IF EXISTS Clients;
	END LOOP;
	CLOSE curs;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `CloseInstantProduction` (IN `fisaId` INT)  BEGIN
    SET @totalF = 0, @tvaF = 0;
    UPDATE FiseProductie SET Closed = 1 WHERE Id = fisaId;


    UPDATE ProduseFisaProductie pf
    INNER JOIN TTVA tva ON tva.ID = pf.TVAId
    SET pf.ValoareCuTVA = ROUND(pf.Cantitate * pf.Pret, 2),
      pf.ValoareLei = ROUND(100 * ROUND(pf.Cantitate * pf.Pret, 2)/ (100 + tva.Procent), 2),
      pf.ValoareTVA = ROUND(pf.Cantitate * pf.Pret, 2) - ROUND(100 * ROUND(pf.Cantitate * pf.Pret, 2)/ (100 + tva.Procent), 2),
      pf.TVAUnitar =  ROUND((ROUND(pf.Cantitate * pf.Pret, 2) - ROUND(100 * ROUND(pf.Cantitate * pf.Pret, 2)/ (100 + tva.Procent), 2)) / pf.Cantitate, 2)        
    WHERE pf.ProductieId = fisaId;

    UPDATE IngredienteFisaProductie pf
    INNER JOIN TTVA tva ON tva.ID = pf.TVAId
    SET pf.ValoareCuTVA = ROUND(pf.Cantitate * pf.Pret, 2),
      pf.ValoareLei = ROUND(100 * ROUND(pf.Cantitate * pf.Pret, 2)/ (100 + tva.Procent), 2),
      pf.ValoareTVA = ROUND(pf.Cantitate * pf.Pret, 2) - ROUND(100 * ROUND(pf.Cantitate * pf.Pret, 2)/ (100 + tva.Procent), 2),
      pf.TVAUnitar =  ROUND((ROUND(pf.Cantitate * pf.Pret, 2) - ROUND(100 * ROUND(pf.Cantitate * pf.Pret, 2)/ (100 + tva.Procent), 2)) / pf.Cantitate, 2)        
    WHERE pf.ProductieId = fisaId;

    SELECT SUM(ValoareLei), SUM(ValoareTVA) 
    INTO @totalF, @tvaF
    FROM ProduseFisaProductie
    WHERE ProductieId = fisaId; 

    UPDATE FiseProductie
    SET Total = @totalF, TVA = @tvaF 
    WHERE Id = fisaId;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `ConsumptionReport` (IN `productType` TINYINT, IN `startDate` DATETIME, IN `endDate` DATETIME, IN `inventarId` INT, IN `subCatId` INT, IN `vatId` INT)  BEGIN 
	DECLARE idTuraInit INT DEFAULT 0;
    SET idTuraInit = GetShiftId(startDate, endDate, 1);
	
    CREATE TEMPORARY TABLE intrari AS
	SELECT pn.ProdusId, SUM(IF(n.Negative = 0, pn.Cantitate, -1*pn.Cantitate)) Cantitate, 
    IFNULL(SUM(pn.ValoareLei), 0) / IFNULL(SUM(pn.Cantitate), 1) CMP, 
    IFNULL(SUM(pn.ValoareLeiVanzare), 0) / IFNULL(SUM(pn.Cantitate), 1) PMP,
    AVG(pn.PretAchizitie) PretAchizitie, AVG(pn.PretVanzare- pn.TVAUnitar) PretVanzare
    FROM NIRuri n
    INNER JOIN ProduseNIR pn ON n.Id = pn.NIRId
    WHERE n.DataFactura BETWEEN startDate AND endDate 
    AND n.Active = 1
    GROUP BY pn.ProdusId;
    
    CREATE TEMPORARY TABLE stocInitial AS
	SELECT st.IDPRODUS ProdusId, st.STOCINITIAL Cantitate
    FROM TStocuriTura st 
    WHERE st.IDTURA = idTuraInit
    GROUP BY ProdusId;

	CREATE TEMPORARY TABLE inventory AS
	SELECT i.ProdusId, i.StocInventar, i.StocProdus, i.Diferenta
	FROM InventarHistory i
	Where i.InventarId = inventarId;
    
    Select IFNULL(p.Denumire,'Produsul a fost sters') Denumire, IFNULL(p.CodBare,'-') CodBare, IFNULL(p.CodPlu,'-') CodPlu, 
    Round(IFNULL(p.PretAchizitie, 0),2) PretAchizitie, Round(IFNULL(p.Pret, 0),2) Pret, IFNULL(p.UM, '-') UM, 
    IFNULL(p.MateriePrima, 0) MateriePrima, IFNULL(sc.NumeSubCategorie, '-') NumeSubCategorie, IFNULL(tva.Denumire, '-') as TVA, 
    Round(IFNULL(s.Cantitate, 0),2) StocI, Round(IFNULL(i.Cantitate, 0),2) Intrari, Round(IFNULL(i.PretAchizitie, 0),2) AVGPretA, 
    Round(IFNULL(i.PretVanzare, 0),2) AVGPretUnitar, Round(IFNULL(i.CMP, 0), 2) CMP, Round(IFNULL(i.PMP, 0), 2) PMP, 
    Round(IFNULL(iv.StocInventar, 0),2) StocInv, Round((IFNULL(s.Cantitate, 0) +IFNULL(i.Cantitate, 0) -IFNULL(iv.StocInventar, 0)) ,2) Consum
	FROM TProduse p
    INNER Join TSubCategorii as sc on sc.IDSubCategorie = p.IDSubCategorie 
    INNER Join TTVA as tva on p.TVA = tva.ID
    LEFT Join intrari i on i.ProdusId = p.ID 
    LEFT Join stocInitial s on s.ProdusId =  p.ID 
    LEFT Join inventory iv on p.ID = iv.ProdusId 
     WHERE 
         (subCatId = 0 OR IFNULL(sc.IDSubCategorie, 0) = subCatId) AND
         (vatId = 0 OR IFNULL(tva.ID, 0) = vatId) AND
         (productType = 0 OR 
          (productType = 1 AND p.MateriePrima = 1) OR 
          (productType = 2 AND p.MateriePrima = 0 AND p.Complex = 0) OR 
          (productType = 3 AND p.Complex = 1));

    DROP TEMPORARY TABLE IF EXISTS intrari;
    DROP TEMPORARY TABLE IF EXISTS inventory;
    DROP TEMPORARY TABLE IF EXISTS stocInitial;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `dataPrepairRepair` ()  BEGIN
	Drop TEMPORARY TABLE if EXISTS r_sp;
	Drop TEMPORARY TABLE if EXISTS r_pn;
	Drop TEMPORARY TABLE if EXISTS r_fix;
	Drop TEMPORARY TABLE if EXISTS r_nirs;

	CREATE TEMPORARY TABLE r_sp AS
	Select Sum(Valoare) Valoare, SerieNr, TipPlata 
    From SmartPayments 
    Group By SerieNr;
    
	CREATE TEMPORARY TABLE r_pn AS
	Select Id, Sum(Valoare) Valoare, SerieNr, TipPlata, Data 
    From PlatiNIRuri 
    Group By SerieNr
    ORDER BY Data;
    
	CREATE TEMPORARY TABLE r_fix AS
	Select r_pn.SerieNr, r_pn.TipPlata, r_pn.Valoare pn_Valoare, r_sp.Valoare sp_Valoare, r_pn.Valoare-r_sp.Valoare Rest, -1 FurnizorId, Data
	From r_pn
	INNER JOIN r_sp ON r_sp.SerieNr = r_pn.SerieNr
	where r_sp.Valoare < r_pn.Valoare
    ORDER BY Data;   
    
	UPDATE r_fix f 
    INNER JOIN PlatiNIRuri pn on pn.SerieNr = f.SerieNr 
    INNER JOIN NIRuri n ON pn.DocumentId = n.Id
    SET f.FurnizorId = n.FurnizorId;
    
    CREATE TEMPORARY TABLE r_nirs AS
    Select n.Id, n.Achitata, n.FurnizorId, (n.TotalNIR+n.TVANIR) Valoare, n.DataFactura
    from NIRuri n
    where n.Achitata = 0 and n.Active = 1 and n.Negative = 1 AND 
    	n.FurnizorId IN (SELECT FurnizorId FROM r_fix)
    Order by n.DataFactura;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `DataPreparation` ()  BEGIN
	SELECT Id, Sum(Valoare) Valoare, SerieNr, TipPlata, Detalii, Data  
    FROM SmartPayments 
    Group By SerieNr
    ORDER BY Data;	
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `DeleteCategory` (IN `id` INT, IN `userId` INT)  BEGIN
    DELETE  p, sc, c
    FROM TCategorii c
    LEFT JOIN TSubCategorii sc ON c.IDCategorie = sc.IdCategorie
    LEFT JOIN TProduse p ON sc.IDSubCategorie = p.IDSubCategorie
    WHERE c.IDCategorie = id;

    UPDATE CategoryHistory
    SET UpdatedById = userId
    WHERE CategoryId = id;

    UPDATE SubcategoryHistory
    SET UpdatedById = userId
    WHERE CategoryId = id AND DATE(Timestamp) = CURRENT_DATE();
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `DeleteDoc` (IN `docId` INT, IN `userId` INT, IN `docType` INT, IN `updateStock` TINYINT)  begin
    DECLARE docNR INT DEFAULT 0;
    DECLARE maxDoc INT DEFAULT 0;

    IF docType = 1 THEN

        CALL ShifStockUpdate(docId, docType, 2);
        CALL UpdateProductStock(docId, docType, 2);

        DELETE FROM MarimiProduseNIR where NIRId = docId;
        DELETE FROM ProduseNIR where NIRId = docId;
        DELETE FROM NIRuri where Id = docId;

    ELSEIF docType = 2 THEN
        IF updateStock = 1 THEN
            CALL ShifStockUpdate(docId, docType, 2);
            CALL UpdateProductStock(docId, docType, 2);
        END IF;
        Select NrAviz INTO docNR FROM Avize WHERE Id = docId;
        Select Max(NrAviz) INTO maxDoc FROM Avize;

        Update Avize Set UserId = userId, Active = 0 where Id = docId;
        Update BonuriAvize Set Active = 0 where Id = docId;

        IF docNR = maxDoc THEN
            UPDATE TSerieF Set Aviz = Aviz-1;
        END IF;
    ELSEIF docType = 3 THEN
        Select NrBon INTO docNR FROM BonuriConsum WHERE Id = docId;
        Select Max(NrBon) INTO maxDoc FROM BonuriConsum;

        CALL ShifStockUpdate(docId, docType, 2);
        CALL UpdateProductStock(docId, docType, 2);

        Update BonuriConsum Set UserId = userId, Active = 0 where Id = docId;
        IF docNR = maxDoc THEN
            UPDATE TSerieF Set Bon = Bon - 1;
        END IF;
    ELSEIF docType = 4 THEN
        Select NrFisa INTO docNR FROM FiseRetur WHERE Id = docId;
        Select Max(NrFisa) INTO maxDoc FROM FiseRetur;

        CALL ShifStockUpdate(docId, docType, 2);
        CALL UpdateProductStock(docId, docType, 2);

        Update FiseRetur Set UserId = userId, Active = 0 where Id = docId;

        IF docNR = maxDoc THEN
            UPDATE TSerieF Set Fisa = Fisa - 1;
        END IF;
    ELSEIF docType = 5 THEN
        Select  CONVERT(NumarFactura, SIGNED INTEGER) INTO docNR
        FROM TFacturi
        WHERE ID = docId
        LIMIT 1;
        Select Max(NumarFactura) INTO maxDoc FROM TFacturi;
        
        IF updateStock = 1 THEN
            CALL ShifStockUpdate(docId, docType, 2);
            CALL UpdateProductStock(docId, docType, 2);
        END IF;
        
	    INSERT INTO ProduseFacturaAnulata 
            (FacturaId, TVA, Cantitate, PterUnitar, TotalProduse, TotalTvaProdus, TPretUnitarFaraTVA, 
            TTotalProduseFaraTva, IdP, TVA1, TVA2, TVA3, TVA4, TVA5, TVA6, TVA7, Type)
        SELECT docId, TVA, Cantitate, PterUnitar, TotalProduse, TotalTvaProdus, TPretUnitarFaraTVA, 
            TTotalProduseFaraTva, IdP, TVA1, TVA2, TVA3, TVA4, TVA5, TVA6, TVA7, Type 
        FROM TFacturiProduse 
        where NumarF = docNR;
        
        DELETE FROM TFacturiProduse where NumarF = docNR;
        Update TFacturi Set UserId = userId, Active = 0 where Id = docId;
        Update BonuriFacturi Set Active = 0 where FacturaId = docId;

        IF docNR = maxDoc THEN
            UPDATE TSerieF Set NrF = NrF - 1;
        END IF;
    ELSEIF docType = 6 THEN
        Select NrFisa INTO docNR FROM FiseNecesar WHERE Id = docId;
        Select Max(NrFisa) INTO maxDoc FROM FiseNecesar;

        CALL ShifStockUpdate(docId, docType, 2);
        CALL UpdateProductStock(docId, docType, 2);

        Update FiseNecesar Set Active = 0 where Id = docId;

        IF docNR = maxDoc THEN
            UPDATE TSerieF Set Necesar = Necesar - 1;
        END IF;
    ELSEIF docType = 7 THEN
        Select NrTransfer INTO docNR FROM BonTransfer WHERE Id = docId;
        Select Max(NrTransfer) INTO maxDoc FROM BonTransfer;

        CALL ShifStockUpdate(docId, docType, 2);
        CALL UpdateProductStock(docId, docType, 2);

        Update BonTransfer Set UserId = userId, Active = 0 where Id = docId;

        IF docNR = maxDoc THEN
            UPDATE TSerieF Set Transfer = Transfer - 1;
        END IF;
    ELSEIF docType = 8 THEN
        Select NrFisa INTO docNR FROM FiseProductie WHERE Id = docId;
        Select Max(NrFisa) INTO maxDoc FROM FiseProductie;

        CALL ShifStockUpdate(docId, docType, 2);
        CALL UpdateProductStock(docId, docType, 2);

        Update FiseProductie Set UserId = userId, Active = 0 where Id = docId;

        IF docNR = maxDoc THEN
            UPDATE TSerieF Set Productie = Productie - 1;
        END IF;
    END IF;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `DeleteRecipe` (IN `id` INT)  BEGIN
    DELETE i, r, pr
    FROM Recipes r
    LEFT JOIN ProductRecipes pr ON pr.RecipeId = r.Id
    LEFT JOIN Ingredients i ON i.RecipeId = r.Id
    WHERE r.Id = id;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `DeleteSubCategory` (IN `id` INT, IN `userId` INT)  BEGIN
    DELETE  p, sc
    FROM TSubCategorii sc
    LEFT JOIN TProduse p ON sc.IDSubCategorie = p.IDSubCategorie
    WHERE sc.IDSubCategorie = id;

    UPDATE SubcategoryHistory
    SET UpdatedById = userId
    WHERE SubcategoryId = id;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `DeleteTag` (IN `tagId` INT)  BEGIN
    UPDATE NIRuri 
    SET TagId = NULL
    WHERE TagId = tagId;

    UPDATE Avize 
    SET TagId = NULL
    WHERE TagId = tagId;

    UPDATE FiseNecesar 
    SET TagId = NULL
    WHERE TagId = tagId;

    UPDATE FiseProductie 
    SET TagId = NULL
    WHERE TagId = tagId;

    UPDATE FiseRetur 
    SET TagId = NULL
    WHERE TagId = tagId; 
    
    UPDATE BonuriConsum 
    SET TagId = NULL
    WHERE TagId = tagId;   
    
    UPDATE BonTransfer 
    SET TagId = NULL
    WHERE TagId = tagId;

    UPDATE TFacturi 
    SET TagId = NULL
    WHERE TagId = tagId;

    DELETE FROM Tags WHERE Id = tagId;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `DocProductsReport` (IN `startDate` DATETIME, IN `endDate` DATETIME, IN `docType` INT, IN `tagId` INT, IN `vatId` INT, IN `subCatId` INT, IN `elemType` INT, IN `catId` INT, IN `filterType` TINYINT)  BEGIN 
    IF docType = 1 THEN
        CREATE TEMPORARY TABLE intrari AS
	    SELECT pn.ProdusId, SUM(pn.Cantitate) Cantitate, 
        IFNULL(SUM(pn.ValoareLei), 0) / IFNULL(SUM(pn.Cantitate), 1) CMP, 
        IFNULL(SUM(pn.ValoareLeiVanzare), 0) / IFNULL(SUM(pn.Cantitate), 1) PMP,
        AVG(pn.PretAchizitie) PretA, AVG(pn.PretVanzare) Pret, pn.TVAId TVA
        FROM NIRuri n
        INNER JOIN ProduseNIR pn ON n.Id = pn.NIRId
        WHERE n.DataFactura BETWEEN startDate AND endDate 
        AND n.Active = 1 AND n.Negative = 0
        GROUP BY pn.ProdusId, pn.TVAId;        

	    SELECT IFNULL(p.Denumire, '-') Denumire, IFNULL(p.CodBare, '-') CodBare, IFNULL(p.CodPlu, '-') CodPlu, IFNULL(tva.Denumire, '-') TVA,
               IFNULL(p.Pret,0) Pret,  Round(IFNULL(p.PretAchizitie,0) ,2) PretA, Round(IFNULL(i.Pret, 0), 2) PretM, 
               Round(IFNULL(i.PretA, 0), 2) PretAM, Round(IFNULL(i.CMP, 0), 2) CMP, Round(IFNULL(i.PMP, 0), 2) PMP, 
               Round(IFNULL(i.Cantitate, 0), 3) Cantitate, IFNULL(p.UM, '-') UM, 
               Round(IFNULL(p.Stoc,0), 3) Stoc, IFNULL(sc.NumeSubCategorie, '-') NumeSubCategorie, IFNULL(p.MateriePrima,0) MateriePrima
	    FROM intrari i
	    LEFT JOIN TProduse p on p.ID = i.ProdusId
        LEFT Join TTVA as tva on i.TVA = tva.ID
	    LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
        WHERE 
            (subCatId = 0 OR sc.IDSubCategorie = subCatId) AND
            (vatId = 0 OR tva.ID = vatId) AND
            (elemType = 0 OR 
             (elemType = 1 AND p.MateriePrima = 1) OR 
             (elemType = 2 AND p.MateriePrima = 0 AND p.Complex = 0) OR 
             (elemType = 3 AND p.Complex = 1))
        ORDER BY NumeSubCategorie, Denumire;

        DROP TEMPORARY TABLE IF EXISTS intrari;
    ELSEIF docType = 2 THEN
        CREATE TEMPORARY TABLE avize AS
        SELECT pn.ProdusId, Sum(pn.Cantitate) Cantitate, 
        IFNULL(SUM(pn.ValoareLei), 0) / IFNULL(SUM(pn.Cantitate), 1) PMP, 
        AVG(pn.Pret) Pret, pn.TVAId TVA
        From Avize a
        INNER JOIN ProduseAviz pn on pn.AvizId = a.Id
        Where a.Active = 1 AND a.DataAviz BETWEEN startDate AND endDate AND
                (tagId = 0 OR a.TagId = tagId)
        GROUP BY pn.ProdusId, pn.TVAId;        
        
	    SELECT IFNULL(p.Denumire, '-') Denumire, IFNULL(p.CodBare, '-') CodBare, IFNULL(p.CodPlu, '-') CodPlu, IFNULL(tva.Denumire, '-') TVA,
               IFNULL(p.Pret,0) Pret,  Round(IFNULL(p.PretAchizitie,0) ,2) PretA, Round(IFNULL(i.Pret, 0), 2) PretM, 
               Round(IFNULL(i.PMP, 0), 2) PMP, Round(IFNULL(i.Cantitate, 0), 3) Cantitate, IFNULL(p.UM, '-') UM, 
               Round(IFNULL(p.Stoc,0), 3) Stoc, IFNULL(sc.NumeSubCategorie, '-') NumeSubCategorie, IFNULL(p.MateriePrima,0) MateriePrima
	    FROM avize i
	    LEFT JOIN TProduse p on p.ID = i.ProdusId
        LEFT Join TTVA as tva on i.TVA = tva.ID
	    LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
        WHERE 
            (subCatId = 0 OR sc.IDSubCategorie = subCatId) AND
            (vatId = 0 OR tva.ID = vatId)
        ORDER BY NumeSubCategorie, Denumire;
        
        DROP TEMPORARY TABLE IF EXISTS avize;
    ELSEIF docType = 3 THEN
        CREATE TEMPORARY TABLE bonC AS
        SELECT pn.ProdusId, Sum(pn.Cantitate) Cantitate, 
        IFNULL(SUM(pn.ValoareLei), 0) / IFNULL(SUM(pn.Cantitate), 1) CMP, 
        IFNULL(SUM(pn.ValoareLeiVanzare), 0) / IFNULL(SUM(pn.Cantitate), 1) PMP, 
        AVG(pn.Pret) PretA, AVG(pn.PretVanzare) Pret, pn.TVAId TVA
        From BonuriConsum a
        INNER JOIN ProduseBonConsum pn on pn.BonId = a.Id
        Where a.Active = 1 AND a.DataBon BETWEEN startDate AND endDate AND
                (tagId = 0 OR a.TagId = tagId)
        GROUP BY pn.ProdusId, pn.TVAId;        
        
	    SELECT IFNULL(p.Denumire, '-') Denumire, IFNULL(p.CodBare, '-') CodBare, IFNULL(p.CodPlu, '-') CodPlu, IFNULL(tva.Denumire, '-') TVA,
               IFNULL(p.Pret,0) Pret,  Round(IFNULL(p.PretAchizitie,0) ,2) PretA, Round(IFNULL(i.Pret, 0), 2) PretM, 
               Round(IFNULL(i.CMP, 0), 2) CMP, Round(IFNULL(i.PMP, 0), 2) PMP, 
               Round(IFNULL(i.PretA, 0), 2) PretAM, Round(IFNULL(i.Cantitate, 0), 3) Cantitate, IFNULL(p.UM, '-') UM, Round(IFNULL(p.Stoc,0), 3) Stoc, 
               IFNULL(sc.NumeSubCategorie, '-') NumeSubCategorie, IFNULL(p.MateriePrima,0) MateriePrima
	    FROM bonC i
	    LEFT JOIN TProduse p on p.ID = i.ProdusId
        LEFT Join TTVA as tva on i.TVA = tva.ID
	    LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
        WHERE 
            (subCatId = 0 OR sc.IDSubCategorie = subCatId) AND
            (vatId = 0 OR tva.ID = vatId)
        ORDER BY NumeSubCategorie, Denumire;
        
        DROP TEMPORARY TABLE IF EXISTS bonC;
        
    ELSEIF docType = 4 THEN
        CREATE TEMPORARY TABLE fisaR AS
        SELECT pn.ProdusId, Sum(pn.Cantitate) Cantitate, 
        IFNULL(SUM(pn.ValoareLei), 0) / IFNULL(SUM(pn.Cantitate), 1) CMP, 
        IFNULL(SUM(pn.ValoareLeiVanzare), 0) / IFNULL(SUM(pn.Cantitate), 1) PMP, 
        AVG(pn.Pret) PretA, AVG(pn.PretVanzare) Pret, pn.TVAId TVA
        From FiseRetur a
        INNER JOIN ProduseFisaRetur pn on pn.FisaId = a.Id
        Where a.Active = 1 AND a.DataFisa BETWEEN startDate AND endDate AND
                (tagId = 0 OR a.TagId = tagId)
        GROUP BY pn.ProdusId, pn.TVAId;        
        
	    SELECT IFNULL(p.Denumire, '-') Denumire, IFNULL(p.CodBare, '-') CodBare, IFNULL(p.CodPlu, '-') CodPlu, IFNULL(tva.Denumire, '-') TVA,
               IFNULL(p.Pret,0) Pret,  Round(IFNULL(p.PretAchizitie,0) ,2) PretA, Round(IFNULL(i.Pret, 0), 2) PretM, 
               Round(IFNULL(i.CMP, 0), 2) CMP, Round(IFNULL(i.PMP, 0), 2) PMP, 
               Round(IFNULL(i.PretA, 0), 2) PretAM, Round(IFNULL(i.Cantitate, 0), 3) Cantitate, IFNULL(p.UM, '-') UM, Round(IFNULL(p.Stoc,0), 3) Stoc, 
               IFNULL(sc.NumeSubCategorie, '-') NumeSubCategorie, IFNULL(p.MateriePrima,0) MateriePrima
	    FROM fisaR i
	    LEFT JOIN TProduse p on p.ID = i.ProdusId
        LEFT Join TTVA as tva on i.TVA = tva.ID
	    LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
        WHERE 
            (subCatId = 0 OR sc.IDSubCategorie = subCatId) AND
            (vatId = 0 OR tva.ID = vatId)
        ORDER BY NumeSubCategorie, Denumire;
        
        DROP TEMPORARY TABLE IF EXISTS fisaR;

    ELSEIF docType = 5 THEN
        CREATE TEMPORARY TABLE invoices AS
        SELECT pn.IdP ProdusId, Sum(pn.Cantitate) Cantitate,
        IFNULL(SUM(pn.TTotalProduseFaraTva), 0) / IFNULL(SUM(pn.Cantitate), 1) PMP,
        AVG(pn.PterUnitar) Pret
        From TFacturi f
        INNER JOIN TFacturiProduse pn on pn.NumarF = f.NumarFactura
        Where f.Active = 1 AND f.DataFactura BETWEEN startDate AND endDate AND
                (tagId = 0 OR a.TagId = tagId)
        GROUP BY pn.IdP;
        
	    SELECT IFNULL(p.Denumire, '-') Denumire, IFNULL(p.CodBare, '-') CodBare, IFNULL(p.CodPlu, '-') CodPlu, IFNULL(tva.Denumire, '-') TVA,
               IFNULL(p.Pret,0) Pret,  Round(IFNULL(p.PretAchizitie,0) ,2) PretA, Round(IFNULL(i.Pret, 0), 2) PretM, 
               Round(IFNULL(i.PMP, 0), 2) PMP, Round(IFNULL(i.Cantitate, 0), 3) Cantitate, IFNULL(p.UM, '-') UM, 
               Round(IFNULL(p.Stoc,0), 3) Stoc, IFNULL(sc.NumeSubCategorie, '-') NumeSubCategorie, IFNULL(p.MateriePrima,0) MateriePrima
	    FROM invoices i
	    LEFT JOIN TProduse p on p.ID = i.ProdusId
        LEFT Join TTVA as tva on p.TVA = tva.ID
	    LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
        WHERE 
            (subCatId = 0 OR sc.IDSubCategorie = subCatId) AND
            (vatId = 0 OR tva.ID = vatId)
        ORDER BY NumeSubCategorie, Denumire;
        
        DROP TEMPORARY TABLE IF EXISTS invoices;

    ELSEIF docType = 6 THEN
        CREATE TEMPORARY TABLE necesar AS
        SELECT pn.ProdusId, Sum(pn.RecievedQuantity) Cantitate, 
        IFNULL(SUM(pn.ValoareLei), 0) / IFNULL(SUM(pn.RecievedQuantity), 1) CMP, 
        AVG(pn.Pret) Pret, pn.TVAId TVA
        From FiseNecesar a
        INNER JOIN IngredienteFisaNecesar pn on pn.NecesarId = a.Id
        Where a.Active = 1 AND a.Resolved = 1 AND a.Type = elemType AND
        a.Data BETWEEN startDate AND endDate
        GROUP BY pn.ProdusId, pn.TVAId;        
        
	    SELECT IFNULL(p.Denumire, '-') Denumire, IFNULL(p.CodBare, '-') CodBare, IFNULL(p.CodPlu, '-') CodPlu, IFNULL(tva.Denumire, '-') TVA,
               IFNULL(p.Pret,0) Pret,  Round(IFNULL(p.PretAchizitie,0) ,2) PretA, Round(IFNULL(i.Pret, 0), 2) PretM, 
               Round(IFNULL(i.CMP, 0), 2) CMP, Round(IFNULL(i.Cantitate, 0), 3) Cantitate, IFNULL(p.UM, '-') UM, 
               Round(IFNULL(p.Stoc,0), 3) Stoc, IFNULL(sc.NumeSubCategorie, '-') NumeSubCategorie, IFNULL(p.MateriePrima,0) MateriePrima
	    FROM necesar i
	    LEFT JOIN TProduse p on p.ID = i.ProdusId
        LEFT Join TTVA as tva on i.TVA = tva.ID
	    LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
        WHERE 
            (subCatId = 0 OR sc.IDSubCategorie = subCatId) AND
            (vatId = 0 OR tva.ID = vatId)
        ORDER BY NumeSubCategorie, Denumire;
        
        DROP TEMPORARY TABLE IF EXISTS necesar;

    ELSEIF docType = 7 THEN
        CREATE TEMPORARY TABLE transfers AS
        SELECT pn.ProdusId, Sum(pn.Cantitate) Cantitate, 
        IFNULL(SUM(pn.ValoareLei), 0) / IFNULL(SUM(pn.Cantitate), 1) CMP, 
        AVG(pn.Pret) Pret, pn.TVAId TVA
        FROM BonTransfer a
        INNER JOIN ProduseBonTransfer pn ON a.Id = pn.TransferId
        Where a.Active = 1 AND a.Closed = 1 AND a.Type = elemType AND
        a.Data BETWEEN startDate AND endDate
        GROUP BY pn.ProdusId, pn.TVAId;        
        
	    SELECT IFNULL(p.Denumire, '-') Denumire, IFNULL(p.CodBare, '-') CodBare, IFNULL(p.CodPlu, '-') CodPlu, IFNULL(tva.Denumire, '-') TVA,
               IFNULL(p.Pret,0) Pret,  Round(IFNULL(p.PretAchizitie,0) ,2) PretA, Round(IFNULL(i.Pret, 0), 2) PretM, 
               Round(IFNULL(i.CMP, 0), 2) CMP, Round(IFNULL(i.Cantitate, 0), 3) Cantitate, IFNULL(p.UM, '-') UM, 
               Round(IFNULL(p.Stoc,0), 3) Stoc, IFNULL(sc.NumeSubCategorie, '-') NumeSubCategorie, IFNULL(p.MateriePrima,0) MateriePrima
	    FROM transfers i
	    LEFT JOIN TProduse p on p.ID = i.ProdusId
        LEFT Join TTVA as tva on i.TVA = tva.ID
	    LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
        WHERE 
            (subCatId = 0 OR sc.IDSubCategorie = subCatId) AND
            (vatId = 0 OR tva.ID = vatId)
        ORDER BY NumeSubCategorie, Denumire;
        
        DROP TEMPORARY TABLE IF EXISTS transfers;

    ELSEIF docType = 8 
    THEN
        IF elemType = 1 
        THEN    
            IF filterType = 1 
            THEN
                CREATE TEMPORARY TABLE fisaP AS
                SELECT pn.IngredientId ProdusId, Sum(pn.Cantitate) Cantitate, 
                IFNULL(SUM(pn.ValoareLei), 0) / IFNULL(SUM(pn.Cantitate), 1) CMP, 
                AVG(pn.Pret) Pret, pn.TVAId TVA
                From FiseProductie a
                INNER JOIN IngredienteFisaProductie pn on pn.ProductieId = a.Id
                INNER JOIN ProduseFisaProductie pr on pr.ProductieId = a.Id AND pn.ProdusFisaId = pr.Id
	            LEFT JOIN TProduse p on p.ID = pr.ProdusId
                LEFT Join TTVA as tva on pr.TVAId = tva.ID
	            LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
                Where a.Active = 1 AND a.Data BETWEEN startDate AND endDate AND
                    (catId = 0 OR sc.IdCategorie = catId) AND
                    (subCatId = 0 OR sc.IDSubCategorie = subCatId) AND
                    (vatId = 0 OR tva.ID = vatId) AND
                    (tagId = 0 OR a.TagId = tagId)
                GROUP BY pn.IngredientId, pn.TVAId; 

	            SELECT IFNULL(p.Denumire, '-') Denumire, IFNULL(p.CodBare, '-') CodBare, IFNULL(p.CodPlu, '-') CodPlu, IFNULL(tva.Denumire, '-') TVA,
                       IFNULL(p.Pret,0) Pret,  Round(IFNULL(p.PretAchizitie,0) ,2) PretA, Round(IFNULL(i.Pret, 0), 2) PretM, 
                       Round(IFNULL(i.CMP, 0), 2) CMP, Round(IFNULL(i.Cantitate, 0), 3) Cantitate, IFNULL(p.UM, '-') UM, 
                       Round(IFNULL(p.Stoc,0), 3) Stoc, IFNULL(sc.NumeSubCategorie, '-') NumeSubCategorie, IFNULL(p.MateriePrima,0) MateriePrima
	            FROM fisaP i
	            LEFT JOIN TProduse p on p.ID = i.ProdusId
                LEFT Join TTVA as tva on i.TVA = tva.ID
	            LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
                ORDER BY NumeSubCategorie, Denumire;
                    
                DROP TEMPORARY TABLE IF EXISTS fisaP;
            ELSE
                CREATE TEMPORARY TABLE fisaP AS
                SELECT pn.IngredientId ProdusId, Sum(pn.Cantitate) Cantitate, 
                IFNULL(SUM(pn.ValoareLei), 0) / IFNULL(SUM(pn.Cantitate), 1) CMP, 
                AVG(pn.Pret) Pret, pn.TVAId TVA
                From FiseProductie a
                INNER JOIN IngredienteFisaProductie pn on pn.ProductieId = a.Id
                Where a.Active = 1 AND a.Data BETWEEN startDate AND endDate AND
                    (tagId = 0 OR a.TagId = tagId)
                GROUP BY pn.IngredientId, pn.TVAId; 

	            SELECT IFNULL(p.Denumire, '-') Denumire, IFNULL(p.CodBare, '-') CodBare, IFNULL(p.CodPlu, '-') CodPlu, IFNULL(tva.Denumire, '-') TVA,
                       IFNULL(p.Pret,0) Pret,  Round(IFNULL(p.PretAchizitie,0) ,2) PretA, Round(IFNULL(i.Pret, 0), 2) PretM, 
                       Round(IFNULL(i.CMP, 0), 2) CMP, Round(IFNULL(i.Cantitate, 0), 3) Cantitate, IFNULL(p.UM, '-') UM, 
                       Round(IFNULL(p.Stoc,0), 3) Stoc, IFNULL(sc.NumeSubCategorie, '-') NumeSubCategorie, IFNULL(p.MateriePrima,0) MateriePrima
	            FROM fisaP i
	            LEFT JOIN TProduse p on p.ID = i.ProdusId
                LEFT Join TTVA as tva on i.TVA = tva.ID
	            LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
                WHERE 
                    (catId = 0 OR sc.IdCategorie = catId) AND
                    (subCatId = 0 OR sc.IDSubCategorie = subCatId) AND
                    (vatId = 0 OR tva.ID = vatId)
                ORDER BY NumeSubCategorie, Denumire;
        
                DROP TEMPORARY TABLE IF EXISTS fisaP;
            END IF;
        ELSE
            CREATE TEMPORARY TABLE fisaP AS
            SELECT pn.ProdusId, Sum(pn.Cantitate) Cantitate, 
            IFNULL(SUM(pn.ValoareLei), 0) / IFNULL(SUM(pn.Cantitate), 1) CMP, 
            AVG(pn.Pret) Pret, pn.TVAId TVA
            From FiseProductie a
            INNER JOIN ProduseFisaProductie pn on pn.ProductieId = a.Id
            Where a.Active = 1 AND a.Data BETWEEN startDate AND endDate AND
                (tagId = 0 OR a.TagId = tagId)
            GROUP BY pn.ProdusId, pn.TVAId;        
        
	        SELECT IFNULL(p.Denumire, '-') Denumire, IFNULL(p.CodBare, '-') CodBare, IFNULL(p.CodPlu, '-') CodPlu, IFNULL(tva.Denumire, '-') TVA,
                   IFNULL(p.Pret,0) Pret,  Round(IFNULL(p.PretAchizitie,0) ,2) PretA, Round(IFNULL(i.Pret, 0), 2) PretM, 
                   Round(IFNULL(i.CMP, 0), 2) CMP, Round(IFNULL(i.Cantitate, 0), 3) Cantitate, IFNULL(p.UM, '-') UM, 
                   Round(IFNULL(p.Stoc,0), 3) Stoc, IFNULL(sc.NumeSubCategorie, '-') NumeSubCategorie, IFNULL(p.MateriePrima,0) MateriePrima
	        FROM fisaP i
	        LEFT JOIN TProduse p on p.ID = i.ProdusId
            LEFT Join TTVA as tva on i.TVA = tva.ID
	        LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
            WHERE 
                (catId = 0 OR sc.IdCategorie = catId) AND
                (subCatId = 0 OR sc.IDSubCategorie = subCatId) AND
                (vatId = 0 OR tva.ID = vatId)
            ORDER BY NumeSubCategorie, Denumire;
        
            DROP TEMPORARY TABLE IF EXISTS fisaP;
        END IF;
    END IF;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `ExpiredProductsReport` (IN `startDate` DATETIME, IN `endDate` DATETIME, IN `vatId` INT, IN `subCatId` INT, IN `elemType` INT)  BEGIN 
    CREATE TEMPORARY TABLE expired AS
    SELECT pn.ProdusId, pn.Cantitate, pn.Expirare, pn.PretAchizitie PretA, 
    pn.PretVanzare Pret,pn.ValoareLeiVanzare, pn.Stoc, pn.TVAId TVA, pn.NrLot, n.DataFactura, n.NrNIR
    FROM NIRuri n
    INNER JOIN ProduseNIR pn ON n.Id = pn.NIRId
    WHERE pn.Expirare BETWEEN startDate AND endDate 
    AND n.Active = 1 AND n.Negative = 0;        
    
    SELECT IFNULL(p.Denumire, 'Produsul a fost sters') Denumire, IFNULL(p.CodBare, '-') CodBare, IFNULL(p.CodPlu, '-') CodPlu, 
           IFNULL(p.UM, '-') UM, IFNULL(p.MateriePrima, 0) MateriePrima, IFNULL(tva.Denumire, '-') TVA, 
           IFNULL(e.NrLot, '-') NrLot, IFNULL(e.Stoc, 0) Stoc, e.DataFactura, e.Expirare, IFNULL(e.Pret, 0) Pret, 
           IFNULL(e.PretA, 0) PretA, IFNULL(e.Cantitate, 0) Cantitate, e.NrNIR, e.ValoareLeiVanzare
    FROM expired e
    LEFT JOIN TProduse p on p.ID = e.ProdusId
    LEFT Join TTVA as tva on e.TVA = tva.ID
    WHERE p.HasExpirationDate = 1 AND
        (subCatId = 0 OR p.IDSubCategorie = subCatId) AND
        (vatId = 0 OR tva.ID = vatId) AND
        (elemType = 0 OR 
         (elemType = 1 AND p.MateriePrima = 1) OR 
         (elemType = 2 AND p.MateriePrima = 0 AND p.Complex = 0) OR 
         (elemType = 3 AND p.Complex = 1))
    ORDER BY Denumire;
    
    DROP TEMPORARY TABLE IF EXISTS expired;    
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `FiscalProductionCost` (IN `startDate` DATETIME, IN `endDate` DATETIME, IN `subCatId` INT, IN `vatId` INT, IN `phase` TINYINT)  BEGIN 
    IF phase = 0 THEN
        CREATE TEMPORARY TABLE reciepts AS
        SELECT pn.IdProdus ProdusId, 
        Round(SUM(pn.Cantitate-pn.StornoQ), 3) Cantitate
        From TZ tz
        INNER JOIN TZProdus pn on pn.IdBon = tz.Id
        INNER JOIN TProduse p on p.ID = pn.IdProdus
        Where p.Complex = 1 AND tz.TotalProtocol = 0 
        AND tz.DataInchidere BETWEEN startDate AND endDate
        GROUP BY pn.IdProdus;
    ELSEIF phase = 2 THEN
        CREATE TEMPORARY TABLE reciepts AS
        SELECT p.ID ProdusId, Round(SUM(pr.Quantity), 3) Cantitate
        From partials pr
        INNER JOIN TProduse p on p.CodBare = pr.Code
        Where p.Complex = 1
        GROUP BY p.ID;

        DROP TEMPORARY TABLE IF EXISTS partials;
    END IF;
    
    Select i.IngredientId, p.Denumire, p.CodBare, p.CodPlu, 
    Round(p.PretAchizitie,2) PretAchizitie, 
    Round(p.Pret,2) Pret, p.UM, p.MateriePrima,
    sc.NumeSubCategorie, tva.Denumire as TVA,
    Round(100*p.Pret/(100+tva.Procent),2) PretUnitar, 
    Round(SUM(r.Cantitate*i.Quantity*pr.Quantity), 3) Cantitate, 
    Round(SUM(p.PretAchizitie*r.Cantitate*i.Quantity*pr.Quantity), 2) Cost,
    Round(SUM(p.Pret*r.Cantitate*i.Quantity*pr.Quantity), 2) Vanzare, 
    Round(SUM(100*r.Cantitate*i.Quantity*pr.Quantity*p.Pret/(100+tva.Procent)), 2) Profit
    From  reciepts r 
    INNER Join ProductRecipes pr on pr.ProductId = r.ProdusId 
    INNER Join Ingredients i on pr.RecipeId = i.RecipeId 
    INNER Join TProduse p on p.ID = i.IngredientId 
    INNER Join TSubCategorii as sc on sc.IDSubCategorie = p.IDSubCategorie 
    INNER Join TTVA as tva on p.TVA = tva.ID
     WHERE 
         (subCatId = 0 OR sc.IDSubCategorie = subCatId) AND
         (vatId = 0 OR tva.ID = vatId)
    GROUP BY i.IngredientId;

    DROP TEMPORARY TABLE IF EXISTS reciepts;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `GetInOutProductsReport` (IN `startDate` DATETIME, IN `endDate` DATETIME, IN `productId` INT, IN `direction` INT)  BEGIN 
	IF direction = 1 THEN

		CREATE TEMPORARY TABLE intrari AS
		SELECT pn.ProdusId, p.Denumire, 
			CONCAT(f.Nume, '\n', n.SerieFactura, ' ', n.NrFactura) Description, 
			1 Type, '-' Serie, n.NrNIR NrDoc, 
			CAST(Round(pn.PretAchizitie, 2) AS CHAR) PretA, Round(pn.PretVanzare, 2) Pret, 
			Round(pn.Stoc, 3) Stoc, n.DataFactura Data, Round(pn.Cantitate, 3) Cantitate, 
			IFNULL(p.UM, '-') UM, 1 IsEntry
		FROM NIRuri n
		INNER JOIN Furnizori f ON f.ID = n.FurnizorId
		INNER JOIN ProduseNIR pn ON n.Id = pn.NIRId
		INNER JOIN TProduse p on p.ID = pn.ProdusId
		Where pn.ProdusId = productId AND 
		n.DataFactura BETWEEN startDate AND endDate AND
		n.Active = 1 AND n.Negative = 0;

		CREATE TEMPORARY TABLE transfers AS
		SELECT pb.ProdusId, p.Denumire, 7 Type, b.Observatii Description,
			b.SerieTransfer Serie, b.NrTransfer NrDoc, CAST(Round(p.PretAchizitie, 2) AS CHAR) PretA, Round(pb.Pret,2) Pret,
			Round(pb.Stoc,3) Stoc, b.Data, Round(pb.Cantitate,3) Cantitate, IFNULL(p.UM, '-') UM, 1 IsEntry
		FROM BonTransfer b
		INNER JOIN ProduseBonTransfer pb ON b.Id = pb.TransferId
		INNER JOIN TProduse p on p.ID = pb.ProdusId
		Where pb.ProdusId = productId AND 
		b.Data BETWEEN startDate AND endDate AND
		b.Active = 1 AND b.Closed = 1 AND b.Type = 2;

		CREATE TEMPORARY TABLE fisaP AS
		SELECT pn.ProdusId, p.Denumire, a.Observatii Description,
			8 Type, a.SerieFisa Serie, a.NrFisa NrDoc, '-' PretA, 
		Round(pn.Pret, 2) Pret, Round(pn.Stoc, 3) Stoc, a.Data, 
		Round(pn.Cantitate ,3) Cantitate, IFNULL(p.UM, '-') UM, 1 IsEntry
		From FiseProductie a
		INNER JOIN ProduseFisaProductie pn on pn.ProductieId = a.Id
		INNER JOIN TProduse p on p.ID = pn.ProdusId
		Where pn.ProdusId = productId AND a.Active = 1 AND 
		a.Data BETWEEN startDate AND endDate;

		Select * From intrari
		Union 
		Select * From fisaP
		Union 
		Select * From transfers;
		
		DROP TEMPORARY TABLE IF EXISTS fisaP;
		DROP TEMPORARY TABLE IF EXISTS intrari;
		DROP TEMPORARY TABLE IF EXISTS transfers;

	ELSEIF direction = 2 THEN

		CREATE TEMPORARY TABLE intrari AS
		SELECT pn.ProdusId, p.Denumire, 
			CONCAT(f.Nume, '\n', n.SerieFactura, ' ', n.NrFactura) Description, 
			1 Type, '-' Serie, n.NrNIR NrDoc, 
			CAST(Round(pn.PretAchizitie, 2) AS CHAR) PretA, Round(pn.PretVanzare, 2) Pret, 
			Round(pn.Stoc, 3) Stoc, n.DataFactura Data, Round(pn.Cantitate, 3) Cantitate, 
			IFNULL(p.UM, '-') UM, 1 IsEntry
		FROM NIRuri n
		INNER JOIN Furnizori f ON f.ID = n.FurnizorId
		INNER JOIN ProduseNIR pn ON n.Id = pn.NIRId
		INNER JOIN TProduse p on p.ID = pn.ProdusId
		Where pn.ProdusId = productId AND 
		n.DataFactura BETWEEN startDate AND endDate AND
		n.Active = 1 AND n.Negative = 1;

		CREATE TEMPORARY TABLE reciepts AS
		SELECT pn.IdProdus ProdusId, p.Denumire, '' Description,
			9 Type, '-' Serie, tz.Id NrDoc, CAST(Round(pn.PretA,2) AS CHAR) PretA, 
			CAST(Round(pn.Pret, 2) AS CHAR) Pret, '-' Stoc,  tz.DataBon Data,
			Round(pn.Cantitate-pn.StornoQ, 3) Cantitate, IFNULL(p.UM, '-') UM, 0 IsEntry
		From TZ tz
		INNER JOIN TZProdus pn on pn.IdBon = tz.Id
		INNER JOIN TProduse p on p.ID = pn.IdProdus
		Where pn.IdProdus = productId AND 
		tz.DataInchidere BETWEEN startDate AND endDate;

		CREATE TEMPORARY TABLE invoices AS
		SELECT pn.IdP ProdusId, p.Denumire, f.Observatii Description,
			5 Type, f.SerieFactura Serie, f.NumarFactura NrDoc, 
			'-' PretA, CAST(Round(pn.PterUnitar,2) AS CHAR) Pret, '-' Stoc,  f.DataFactura Data,
			Round(pn.Cantitate,3) Cantitate, IFNULL(p.UM, '-') UM, 0 IsEntry
		From TFacturi f
		INNER JOIN TFacturiProduse pn on pn.NumarF = f.NumarFactura
		INNER JOIN TProduse p on p.ID = pn.IdP
		Where pn.IdP = productId AND f.Active = 1 AND 
		f.Storno = 0 AND f.WithStock = 1 AND 
		f.ID not in (Select FacturaId From BonuriFacturi WHERE Active = 1) AND
		f.DataFactura BETWEEN startDate AND endDate;

		CREATE TEMPORARY TABLE avize AS
		SELECT pn.ProdusId, p.Denumire, a.Observatii Description,
			2 Type, a.SerieAviz Serie, a.NrAviz NrDoc, 
			IF(a.Type = 1, CAST(Round(pn.Pret, 2) AS CHAR), '-') PretA,
			IF(a.Type = 0, CAST(Round(pn.Pret, 2) AS CHAR), '-') Pret,
			CAST(Round(pn.Stoc, 3) AS CHAR) Stoc, a.DataAviz Data,
			Round(pn.Cantitate, 3) Cantitate, IFNULL(p.UM, '-') UM, 0 IsEntry
		From Avize a
		INNER JOIN ProduseAviz pn on pn.AvizId = a.Id
		INNER JOIN TProduse p on p.ID = pn.ProdusId
		Where pn.ProdusId = productId AND a.Active = 1 AND 
		a.WithStock = 1 AND 
		a.Id not in (Select AvizId From BonuriAvize) AND
		a.DataAviz BETWEEN startDate AND endDate;

		CREATE TEMPORARY TABLE necesar AS
		SELECT pn.ProdusId, p.Denumire, a.Observatii Description,
			6 Type, a.SerieFisa Serie, a.NrFisa NrDoc, 
			'-' PretA, CAST(Round(pn.Pret, 2) AS CHAR) Pret, CAST(Round(pn.Stoc, 3) AS CHAR) Stoc, a.Data,
			Round(pn.RecievedQuantity, 3) Cantitate, IFNULL(p.UM, '-') UM, 0 IsEntry
		From FiseNecesar a
		INNER JOIN IngredienteFisaNecesar pn on pn.NecesarId = a.Id
		INNER JOIN TProduse p on p.ID = pn.ProdusId
		Where pn.ProdusId = productId AND a.Active = 1 AND 
		a.Resolved = 1 AND a.Type = 2 AND
		a.Data BETWEEN startDate AND endDate;

		CREATE TEMPORARY TABLE bonC AS
		SELECT pn.ProdusId, p.Denumire, a.Observatii Description,
			3 Type, a.SerieBon Serie, a.NrBon NrDoc, 
			CAST(Round(pn.Pret, 2) AS CHAR) PretA, CAST(Round(pn.PretVanzare, 2) AS CHAR) Pret, 
			CAST(Round(pn.Stoc, 3) AS CHAR) Stoc, a.DataBon Data,
			Round(pn.Cantitate, 3) Cantitate, IFNULL(p.UM, '-') UM, 0 IsEntry
		From BonuriConsum a
		INNER JOIN ProduseBonConsum pn on pn.BonId = a.Id
		INNER JOIN TProduse p on p.ID = pn.ProdusId
		Where pn.ProdusId = productId AND a.Active = 1 AND 
		a.DataBon BETWEEN startDate AND endDate;

		CREATE TEMPORARY TABLE fisaR AS
		SELECT pn.ProdusId, p.Denumire, a.Observatii Description, 
			4 Type, a.SerieFisa Serie, a.NrFisa NrDoc, 
			CAST(Round(pn.Pret, 2) AS CHAR) PretA, CAST(Round(pn.PretVanzare, 2) AS CHAR) Pret, 
			CAST(Round(pn.Stoc, 3) AS CHAR) Stoc, a.DataFisa Data, Round(pn.Cantitate, 3) Cantitate, 
			IFNULL(p.UM, '-') UM, 0 IsEntry
		From FiseRetur a
		INNER JOIN ProduseFisaRetur pn on pn.FisaId = a.Id
		INNER JOIN TProduse p on p.ID = pn.ProdusId
		Where pn.ProdusId = productId AND a.Active = 1 AND 
		a.DataFisa BETWEEN startDate AND endDate;

		CREATE TEMPORARY TABLE fisaP AS
		SELECT pn.ProdusId, p.Denumire, a.Observatii Description, 
			8 Type, a.SerieFisa Serie, a.NrFisa NrDoc, '-' PretA, 
			CAST(Round(pn.Pret, 2) AS CHAR) Pret, CAST(Round(pn.Stoc, 3) AS CHAR) Stoc, a.Data, 
			Round(pn.Cantitate, 3) Cantitate, IFNULL(p.UM, '-') UM, 0 IsEntry
		From FiseProductie a
		INNER JOIN ProduseFisaProductie pn on pn.ProductieId = a.Id
		INNER JOIN TProduse p on p.ID = pn.ProdusId
		Where pn.ProdusId = productId AND a.Active = 1 AND 
		a.Data BETWEEN startDate AND endDate;

		CREATE TEMPORARY TABLE fisaPI AS
		SELECT pn.ProdusId, p.Denumire, a.Observatii Description, 
			8 Type, a.SerieFisa Serie, a.NrFisa NrDoc, '-' PretA, 
			CAST(Round(pn.Pret, 2) AS CHAR) Pret, CAST(Round(pn.Stoc, 3) AS CHAR) Stoc, a.Data, 
			Round(pn.Cantitate, 3) Cantitate, IFNULL(ing.UM, '-') UM, 0 IsEntry
		From FiseProductie a
		INNER JOIN IngredienteFisaProductie pn on pn.ProductieId = a.Id
		INNER JOIN TProduse p on p.ID = pn.ProdusId
		INNER JOIN TProduse ing on ing.ID = pn.IngredientId
		Where pn.IngredientId = productId AND a.Active = 1 AND 
		a.Data BETWEEN startDate AND endDate;

		Select * From intrari
		Union 
		Select * From bonC
		Union 
		Select * From fisaP
		Union 
		Select * From fisaPI
		Union 
		Select * From fisaR
		Union 
		Select * From avize
		Union 
		Select * From necesar
		Union 
		Select * From invoices
		Union 
		Select * From reciepts;

		DROP TEMPORARY TABLE IF EXISTS bonC;
		DROP TEMPORARY TABLE IF EXISTS fisaP;
		DROP TEMPORARY TABLE IF EXISTS fisaPI;
		DROP TEMPORARY TABLE IF EXISTS fisaR;
		DROP TEMPORARY TABLE IF EXISTS avize;
		DROP TEMPORARY TABLE IF EXISTS intrari;
		DROP TEMPORARY TABLE IF EXISTS necesar;
		DROP TEMPORARY TABLE IF EXISTS invoices;
		DROP TEMPORARY TABLE IF EXISTS reciepts;
	END IF;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `GetInventarList` (IN `inventarId` INT, IN `subCatId` INT, IN `vatId` INT, IN `rType` INT)  BEGIN 
	CREATE TEMPORARY TABLE inventory AS
	SELECT IFNULL(p.Denumire, 'Produsul a fost sters') Denumire, IFNULL(p.CodBare, '-') CodBare, IFNULL(p.CodPlu, '-') CodPlu, 
		Round(i.PretAchizitie, 2) PretA, Round(i.Pret, 2) Pret, Round(i.StocInventar, 3) StocInventar, 
		Round(i.StocProdus, 3) StocProdus, Round(i.Diferenta, 3) Diferenta, 
		Round(i.StocInventar*i.PretAchizitie, 2) VInventarAchizitie,
		Round(i.StocProdus*i.PretAchizitie, 2) VProdusAchizitie,
		Round(i.Diferenta*i.PretAchizitie, 2) VDiferentaAchizitie,
		Round(i.StocInventar*i.Pret, 2) VInventar,
		Round(i.StocProdus*i.Pret, 2) VProdus,
		Round(i.Diferenta*i.Pret, 2) VDiferenta
	FROM InventarHistory i
	Left Join TProduse p on p.ID = i.ProdusId 
	Where i.InventarId = inventarId AND
         (subCatId = 0 OR IFNULL(p.IDSubCategorie, 0) = subCatId) AND
         (vatId = 0 OR IFNULL(p.TVA, 0) = vatId) AND
         (rType = 0 OR 
          (rType = 1 AND i.Diferenta = 0) OR 
          (rType = 2 AND i.Diferenta != 0) OR
          (rType = 3 AND i.Diferenta > 0) OR 
          (rType = 4 AND i.Diferenta < 0));

	Select * From inventory;
	DROP TEMPORARY TABLE IF EXISTS inventory;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `GetInventarRowList` ()  BEGIN 
	CREATE TEMPORARY TABLE inventory AS
	SELECT InventarId, Concat('Inventar ', InventarId, ' - ', Timestamp) Name
	FROM InventarHistory
	Group BY InventarId;
	Select * From inventory;
	DROP TEMPORARY TABLE IF EXISTS inventory;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `MonthlyINData` (IN `rDate` DATE, IN `subCatId` INT, IN `elemType` INT, IN `vatId` INT, IN `catId` INT, IN `complete` TINYINT)  sp_in: BEGIN 
	CREATE TEMPORARY TABLE m_intrari AS
	SELECT pn.ProdusId, SUM(pn.ValoareLei) ValoareLei, 
		SUM(pn.Cantitate) Cantitate, 1 IsEntry
	FROM NIRuri n
	INNER JOIN ProduseNIR pn ON n.Id = pn.NIRId
	Where MONTH(n.DataFactura) = MONTH(rDate) AND 
	YEAR(n.DataFactura) = YEAR(rDate) AND
	n.Active = 1 AND n.Negative = 0
	GROUP BY ProdusId;

	IF complete = 1 
	THEN

		CREATE TEMPORARY TABLE m_transfers AS
		SELECT pb.ProdusId, SUM(pn.ValoareLei) ValoareLei,
			SUM(pb.Cantitate) Cantitate, 1 IsEntry
		FROM BonTransfer b
		INNER JOIN ProduseBonTransfer pb ON b.Id = pb.TransferId
		Where MONTH(b.Data) = MONTH(rDate) AND 
		YEAR(b.Data) = YEAR(rDate) AND
		b.Active = 1 AND b.Closed = 1 AND b.Type = 2
		GROUP BY ProdusId;
	
		CREATE TEMPORARY TABLE m_fisaPrIN AS
		SELECT pn.ProdusId, SUM(pn.ValoareLei) ValoareLei,
			SUM(pn.Cantitate) Cantitate, 1 IsEntry
		From FiseProductie a
		INNER JOIN ProduseFisaProductie pn on pn.ProductieId = a.Id
		Where a.Active = 1 AND MONTH(a.Data) = MONTH(rDate) AND 
		YEAR(a.Data) = YEAR(rDate)
		GROUP BY ProdusId;
		
		CREATE TEMPORARY TABLE m_inData AS
		SELECT p.ID, 
		IFNULL(ROUND((IFNULL(i.ValoareLei, 0) + IFNULL(pri.ValoareLei, 0) + IFNULL(t.ValoareLei, 0)) 
			/ IFNULL(IFNULL(t.Cantitate, 0) + IFNULL(pri.Cantitate, 0) + IFNULL(i.Cantitate, 0), 1), 2), p.PretAchizitie) PretAchizitie,
		ROUND(IFNULL(t.Cantitate, 0) + IFNULL(pri.Cantitate, 0) + IFNULL(i.Cantitate, 0), 3) Intrari,
		ROUND((IFNULL(t.Cantitate, 0) + IFNULL(pri.Cantitate, 0) + IFNULL(i.Cantitate, 0)) 
			* IFNULL(ROUND((IFNULL(i.ValoareLei, 0) + IFNULL(pri.ValoareLei, 0) + IFNULL(t.ValoareLei, 0)) 
				/ IFNULL(IFNULL(t.Cantitate, 0) + IFNULL(pri.Cantitate, 0) + IFNULL(i.Cantitate, 0), 1), 2), p.PretAchizitie), 2) ValAIntrari
		FROM TProduse p
		LEFT JOIN m_intrari i ON i.ProdusId = p.ID
		LEFT JOIN m_fisaPrIN pri ON pri.ProdusId = p.ID
		LEFT JOIN m_transfers t ON t.ProdusId = p.ID
		LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
		WHERE (subCatId = 0 OR p.IDSubCategorie = subCatId) AND
			(catId = 0 OR sc.IdCategorie = catId) AND
			(vatId = 0 OR p.TVA = vatId) AND
			(elemType = 0 OR 
			 (elemType = 1 AND p.MateriePrima = 1) OR 
			 (elemType = 2 AND p.MateriePrima = 0 AND p.Complex = 0) OR 
			 (elemType = 3 AND p.Complex = 1));
			 
		DROP TEMPORARY TABLE IF EXISTS m_intrari;
		DROP TEMPORARY TABLE IF EXISTS m_fisaPrIN;
		DROP TEMPORARY TABLE IF EXISTS m_transfers;
		LEAVE sp_in;
	END IF;
		
	CREATE TEMPORARY TABLE m_inData AS
	SELECT p.ID, IFNULL(ROUND(i.ValoareLei/IFNULL(i.Cantitate, 1), 2), p.PretAchizitie) PretAchizitie,
	ROUND(IFNULL(i.Cantitate, 0), 3) Intrari,
	ROUND(IFNULL(i.Cantitate, 0) * IFNULL(ROUND(i.ValoareLei/IFNULL(i.Cantitate, 1), 2), p.PretAchizitie), 2) ValAIntrari
	FROM TProduse p
	LEFT JOIN m_intrari i ON i.ProdusId = p.ID
	LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
	WHERE (subCatId = 0 OR p.IDSubCategorie = subCatId) AND
		(catId = 0 OR sc.IdCategorie = catId) AND
		(vatId = 0 OR p.TVA = vatId) AND
		(elemType = 0 OR 
			(elemType = 1 AND p.MateriePrima = 1) OR 
			(elemType = 2 AND p.MateriePrima = 0 AND p.Complex = 0) OR 
			(elemType = 3 AND p.Complex = 1));
	

	DROP TEMPORARY TABLE IF EXISTS m_intrari;
	DROP TEMPORARY TABLE IF EXISTS m_fisaPrIN;
	DROP TEMPORARY TABLE IF EXISTS m_transfers;
	LEAVE sp_in;
END;$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `MonthlyIOAcquisitionReport` (IN `rDate` DATE, IN `subCatId` INT, IN `elemType` INT, IN `vatId` INT, IN `catId` INT, IN `complete` TINYINT)  BEGIN 
    SET @idTuraInit = GetShiftMonthId(rDate, 1);
    SET @idTuraEnd = GetShiftMonthId(rDate, 0);
	
    CREATE TEMPORARY TABLE m_stocInitial AS
	SELECT st.IDPRODUS ProdusId, st.STOCINITIAL Cantitate
    FROM TStocuriTura st 
    WHERE st.IDTURA = @idTuraInit
    GROUP BY ProdusId;
    
    CREATE TEMPORARY TABLE m_stocFinal AS
	SELECT st.IDPRODUS ProdusId, st.STOCFINAL Cantitate
    FROM TStocuriTura st 
    WHERE st.IDTURA = @idTuraEnd
    GROUP BY ProdusId;

	CREATE TEMPORARY TABLE m_intrari AS
	SELECT pn.ProdusId, SUM(pn.Cantitate) Cantitate, 1 IsEntry
	FROM NIRuri n
	INNER JOIN ProduseNIR pn ON n.Id = pn.NIRId
	Where MONTH(n.DataFactura) = MONTH(rDate) AND 
    YEAR(n.DataFactura) = YEAR(rDate) AND
	n.Active = 1 AND n.Negative = 0
	GROUP BY ProdusId;

    CREATE TEMPORARY TABLE m_reciepts AS
    SELECT pn.IdProdus ProdusId, SUM(pn.Cantitate-pn.StornoQ) Cantitate, 0 IsEntry
    From TZ tz
    INNER JOIN TZProdus pn on pn.IdBon = tz.Id
    Where MONTH(tz.DataInchidere) = MONTH(rDate) AND 
    YEAR(tz.DataInchidere) = YEAR(rDate)
	GROUP BY ProdusId;
	
    IF complete = 1 
    THEN

	    CREATE TEMPORARY TABLE m_transfers AS
	    SELECT pb.ProdusId, SUM(pb.Cantitate) Cantitate, 1 IsEntry
	    FROM BonTransfer b
	    INNER JOIN ProduseBonTransfer pb ON b.Id = pb.TransferId
	    Where MONTH(b.Data) = MONTH(rDate) AND 
        YEAR(b.Data) = YEAR(rDate) AND
	    b.Active = 1 AND b.Closed = 1 AND b.Type = 2
	    GROUP BY ProdusId;

        CREATE TEMPORARY TABLE m_invoices AS
        SELECT pn.IdP ProdusId, SUM(pn.Cantitate) Cantitate, 0 IsEntry
        From TFacturi f
        INNER JOIN TFacturiProduse pn on pn.NumarF = f.NumarFactura
        Where f.Active = 1 AND f.Storno = 0 AND f.WithStock = 1 AND 
        f.ID not in (Select FacturaId From BonuriFacturi WHERE Active = 1) AND
        MONTH(f.DataFactura) = MONTH(rDate) AND 
        YEAR(f.DataFactura) = YEAR(rDate)
	    GROUP BY ProdusId;

        CREATE TEMPORARY TABLE m_avize AS
        SELECT pn.ProdusId, SUM(pn.Cantitate) Cantitate, 0 IsEntry
        From Avize a
        INNER JOIN ProduseAviz pn on pn.AvizId = a.Id
        Where a.Active = 1 AND a.WithStock = 1 AND 
        a.Id not in (Select AvizId From BonuriAvize) AND
        MONTH(a.DataAviz) = MONTH(rDate) AND 
        YEAR(a.DataAviz) = YEAR(rDate)
	    GROUP BY ProdusId;

        CREATE TEMPORARY TABLE m_necesar AS
        SELECT pn.ProdusId, SUM(pn.RecievedQuantity) Cantitate, 0 IsEntry
        From FiseNecesar a
        INNER JOIN IngredienteFisaNecesar pn on pn.NecesarId = a.Id
        Where a.Active = 1 AND a.Resolved = 1 AND a.Type = 2 AND
        MONTH(a.Data) = MONTH(rDate) AND 
        YEAR(a.Data) = YEAR(rDate)
	    GROUP BY ProdusId;

        CREATE TEMPORARY TABLE m_bonC AS
        SELECT pn.ProdusId, SUM(pn.Cantitate) Cantitate, 0 IsEntry
        From BonuriConsum a
        INNER JOIN ProduseBonConsum pn on pn.BonId = a.Id
        Where a.Active = 1 AND MONTH(a.DataBon) = MONTH(rDate) AND 
        YEAR(a.DataBon) = YEAR(rDate)
	    GROUP BY ProdusId;

        CREATE TEMPORARY TABLE m_fisaR AS
        SELECT pn.ProdusId, SUM(pn.Cantitate) Cantitate, 0 IsEntry
        From FiseRetur a
        INNER JOIN ProduseFisaRetur pn on pn.FisaId = a.Id
        Where a.Active = 1 AND MONTH(a.DataFisa) = MONTH(rDate) AND 
        YEAR(a.DataFisa) = YEAR(rDate)
	    GROUP BY ProdusId;

        CREATE TEMPORARY TABLE m_fisaPrOUT AS
        SELECT pn.ProdusId, SUM(pn.Cantitate) Cantitate, 0 IsEntry
        From FiseProductie a
        INNER JOIN IngredienteFisaProductie pn on pn.ProductieId = a.Id
        Where a.Active = 1 AND 
        MONTH(a.Data) = MONTH(rDate) AND 
        YEAR(a.Data) = YEAR(rDate)
	    GROUP BY ProdusId;

        SELECT p.ID, p.Denumire, p.CodBare, p.CodPlu, p.PretAchizitie, 
        ROUND(IFNULL(si.Cantitate, 0),3) Initial, ROUND(IFNULL(si.Cantitate, 0) * p.PretAchizitie, 2) ValInitial, 
        ROUND(IFNULL(t.Cantitate, 0) + IFNULL(i.Cantitate, 0), 3) Intrari,
        ROUND((IFNULL(t.Cantitate, 0) + IFNULL(i.Cantitate, 0)) * p.PretAchizitie, 2) ValIntrari, 
        
        ROUND(IFNULL(inv.Cantitate, 0) + IFNULL(n.Cantitate, 0) + IFNULL(a.Cantitate, 0) + IFNULL(fr.Cantitate, 0) + 
        IFNULL(pro.Cantitate, 0) + IFNULL(b.Cantitate, 0) + IFNULL(r.Cantitate, 0), 3) Iesiri,
        ROUND((IFNULL(inv.Cantitate, 0) + IFNULL(n.Cantitate, 0) + IFNULL(a.Cantitate, 0) + IFNULL(fr.Cantitate, 0) + 
        IFNULL(pro.Cantitate, 0) + IFNULL(b.Cantitate, 0) + IFNULL(r.Cantitate, 0))*p.PretAchizitie, 2) ValIesiri, 

        ROUND(IFNULL(sf.Cantitate, 0),3) Final, ROUND(IFNULL(sf.Cantitate, 0)*p.PretAchizitie,2) ValFinal
        FROM TProduse p
	    LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
        LEFT JOIN m_stocInitial si ON si.ProdusId = p.ID
        LEFT JOIN m_intrari i ON i.ProdusId = p.ID
        LEFT JOIN m_transfers t ON t.ProdusId = p.ID
        LEFT JOIN m_reciepts r ON r.ProdusId = p.ID
        LEFT JOIN m_bonC b ON b.ProdusId = p.ID
        LEFT JOIN m_fisaPrOUT pro ON pro.ProdusId = p.ID
        LEFT JOIN m_fisaR fr ON fr.ProdusId = p.ID
        LEFT JOIN m_avize a ON a.ProdusId = p.ID
        LEFT JOIN m_necesar n ON n.ProdusId = p.ID
        LEFT JOIN m_invoices inv ON inv.ProdusId = p.ID
        LEFT JOIN m_stocFinal sf ON sf.ProdusId = p.ID
        WHERE p.Complex = 0 AND (subCatId = 0 OR p.IDSubCategorie = subCatId) AND
            (catId = 0 OR sc.IdCategorie = catId) AND
            (vatId = 0 OR p.TVA = vatId) AND
            (elemType = 0 OR 
             (elemType = 1 AND p.MateriePrima = 1) OR 
             (elemType = 2 AND p.MateriePrima = 0))
        ORDER BY Denumire;
    ELSE
        SELECT p.ID, p.Denumire, p.CodBare, p.CodPlu, p.PretAchizitie, ROUND(IFNULL(si.Cantitate, 0),3) Initial, 
        ROUND(IFNULL(si.Cantitate, 0)*p.PretAchizitie,2) ValInitial, ROUND(IFNULL(i.Cantitate, 0),3) Intrari,
        ROUND(IFNULL(i.Cantitate, 0)*p.PretAchizitie,2) ValIntrari, ROUND(IFNULL(r.Cantitate, 0),3) Iesiri,
        ROUND(IFNULL(r.Cantitate, 0)*p.PretAchizitie,2) ValIesiri, ROUND(IFNULL(sf.Cantitate, 0),3) Final, 
        ROUND(IFNULL(sf.Cantitate, 0)*p.PretAchizitie,2) ValFinal
        FROM TProduse p
	    LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
        LEFT JOIN m_stocInitial si ON si.ProdusId = p.ID
        LEFT JOIN m_intrari i ON i.ProdusId = p.ID
        LEFT JOIN m_reciepts r ON r.ProdusId = p.ID
        LEFT JOIN m_stocFinal sf ON sf.ProdusId = p.ID
        WHERE p.Complex = 0 AND (subCatId = 0 OR p.IDSubCategorie = subCatId) AND
            (catId = 0 OR sc.IdCategorie = catId) AND
            (vatId = 0 OR p.TVA = vatId) AND
            (elemType = 0 OR 
             (elemType = 1 AND p.MateriePrima = 1) OR 
             (elemType = 2 AND p.MateriePrima = 0 AND p.Complex = 0))
        ORDER BY Denumire;
    END IF;
    
    DROP TEMPORARY TABLE IF EXISTS m_stocInitial;
    DROP TEMPORARY TABLE IF EXISTS m_stocFinal;

    DROP TEMPORARY TABLE IF EXISTS m_intrari;
    DROP TEMPORARY TABLE IF EXISTS m_transfers;

    DROP TEMPORARY TABLE IF EXISTS m_bonC;
    DROP TEMPORARY TABLE IF EXISTS m_fisaPrOUT;
    DROP TEMPORARY TABLE IF EXISTS m_fisaR;
    DROP TEMPORARY TABLE IF EXISTS m_avize;
    DROP TEMPORARY TABLE IF EXISTS m_necesar;
    DROP TEMPORARY TABLE IF EXISTS m_invoices;
    DROP TEMPORARY TABLE IF EXISTS m_reciepts;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `MonthlyIOReport` (IN `rDate` DATE, IN `subCatId` INT, IN `elemType` INT, IN `vatId` INT, IN `catId` INT, IN `complete` TINYINT)  BEGIN 
	SET @idTuraInit = GetShiftMonthId(rDate, 1);

	CREATE TEMPORARY TABLE m_stocInitial AS
	SELECT st.IDPRODUS ProdusId, st.STOCINITIAL Cantitate, st.PretA, St.PretV
	FROM TStocuriTura st 
	WHERE st.IDTURA = @idTuraInit
	GROUP BY ProdusId;

	CALL MonthlyINData(rDate, subCatId, elemType, vatId, catId, complete);
	CALL MonthlyOUTData(rDate, subCatId, elemType, vatId, catId, complete);

	SELECT p.ID, p.Denumire, p.CodBare, p.CodPlu, IFNULL(i.PretAchizitie, p.PretAchizitie) PretAchizitie, IFNULL(r.Pret, p.Pret) Pret, 
	ROUND(IFNULL(si.Cantitate, 0), 3) Initial, ROUND(IFNULL(si.Cantitate, 0) * IFNULL(si.PretA, IFNULL(i.PretAchizitie, p.PretAchizitie)), 2) ValAInitial,
	ROUND(IFNULL(si.Cantitate, 0) * IFNULL(si.PretV, p.Pret), 2) ValInitial, 

	IFNULL(i.Intrari, 0) Intrari, IFNULL(i.ValAIntrari, 0) ValAIntrari, IFNULL(ROUND(IFNULL(i.Intrari, 0) * IFNULL(r.Pret, p.Pret), 2), 0) ValIntrari, 
	IFNULL(r.Iesiri, 0) Iesiri, IFNULL(r.Iesiri * IFNULL(i.PretAchizitie, p.PretAchizitie), 0) ValAIesiri, IFNULL(r.ValIesiri, 0) ValIesiri, 
	
	
	ROUND(IFNULL(si.Cantitate, 0) + IFNULL(i.Intrari, 0) - IFNULL(r.Iesiri, 0), 3) Final, 
	ROUND((IFNULL(si.Cantitate, 0) + IFNULL(i.Intrari, 0) - IFNULL(r.Iesiri, 0)) * IFNULL(i.PretAchizitie, p.PretAchizitie), 2) ValAFinal, 
	ROUND((IFNULL(si.Cantitate, 0) + IFNULL(i.Intrari, 0) - IFNULL(r.Iesiri, 0)) * IFNULL(r.Pret, p.Pret), 2) ValFinal
	FROM TProduse p
	LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
	LEFT JOIN m_stocInitial si ON si.ProdusId = p.ID
	LEFT JOIN m_inData i ON i.ID = p.ID
	LEFT JOIN m_outData r ON r.ID = p.ID
	WHERE (subCatId = 0 OR p.IDSubCategorie = subCatId) AND
		(catId = 0 OR sc.IdCategorie = catId) AND
		(vatId = 0 OR p.TVA = vatId) AND
		(elemType = 0 OR 
			(elemType = 1 AND p.MateriePrima = 1) OR 
			(elemType = 2 AND p.MateriePrima = 0 AND p.Complex = 0) OR 
			(elemType = 3 AND p.Complex = 1))
	ORDER BY Denumire;
	

	DROP TEMPORARY TABLE IF EXISTS m_inData;
	DROP TEMPORARY TABLE IF EXISTS m_outData;
	DROP TEMPORARY TABLE IF EXISTS m_stocInitial;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `MonthlyOUTData` (IN `rDate` DATE, IN `subCatId` INT, IN `elemType` INT, IN `vatId` INT, IN `catId` INT, IN `complete` TINYINT)  sp_out: BEGIN

	CREATE TEMPORARY TABLE m_reciepts AS
	SELECT pn.IdProdus ProdusId,SUM((pn.Cantitate-pn.StornoQ)*pn.Pret) Valoare,
		SUM(pn.Cantitate-pn.StornoQ) Cantitate, 0 IsEntry
	From TZ tz
	INNER JOIN TZProdus pn on pn.IdBon = tz.Id
	Where MONTH(tz.DataInchidere) = MONTH(rDate) AND 
	YEAR(tz.DataInchidere) = YEAR(rDate)
	GROUP BY ProdusId;
	
	IF complete = 1 
	THEN

        CREATE TEMPORARY TABLE m_invoices AS
        SELECT pn.IdP ProdusId, SUM(pn.TotalProduse) Valoare, 
			SUM(pn.Cantitate) Cantitate, 0 IsEntry
        From TFacturi f
        INNER JOIN TFacturiProduse pn on pn.NumarF = f.NumarFactura
        Where f.Active = 1 AND f.Storno = 0 AND f.WithStock = 1 AND 
        f.ID not in (Select FacturaId From BonuriFacturi WHERE Active = 1) AND
        MONTH(f.DataFactura) = MONTH(rDate) AND 
        YEAR(f.DataFactura) = YEAR(rDate)
		GROUP BY ProdusId;

		CREATE TEMPORARY TABLE m_avize AS
		SELECT pn.ProdusId, SUM(pn.ValoareLei+pn.ValoareTVA) Valoare, 
			SUM(pn.Cantitate) Cantitate, 0 IsEntry
		From Avize a
		INNER JOIN ProduseAviz pn on pn.AvizId = a.Id
		Where a.Active = 1 AND a.WithStock = 1 AND 
		a.Id not in (Select AvizId From BonuriAvize) AND
		MONTH(a.DataAviz) = MONTH(rDate) AND 
		YEAR(a.DataAviz) = YEAR(rDate)
		GROUP BY ProdusId;

		CREATE TEMPORARY TABLE m_necesar AS
		SELECT pn.ProdusId, SUM(pn.ValoareLei+pn.ValoareTVA) Valoare, 
		SUM(pn.RecievedQuantity) Cantitate, 0 IsEntry
		From FiseNecesar a
		INNER JOIN IngredienteFisaNecesar pn on pn.NecesarId = a.Id
		Where a.Active = 1 AND a.Resolved = 1 AND a.Type = 2 AND
		MONTH(a.Data) = MONTH(rDate) AND 
		YEAR(a.Data) = YEAR(rDate)
		GROUP BY ProdusId;

		CREATE TEMPORARY TABLE m_bonC AS
		SELECT pn.ProdusId, SUM(pn.ValoareLeiVanzare+pn.ValoareTVAVanzare) Valoare, 
			SUM(pn.Cantitate) Cantitate, 0 IsEntry
		From BonuriConsum a
		INNER JOIN ProduseBonConsum pn on pn.BonId = a.Id
		Where a.Active = 1 AND MONTH(a.DataBon) = MONTH(rDate) AND 
		YEAR(a.DataBon) = YEAR(rDate)
		GROUP BY ProdusId;

		CREATE TEMPORARY TABLE m_fisaR AS
		SELECT pn.ProdusId, SUM(pn.ValoareLeiVanzare+pn.ValoareTVAVanzare) Valoare, 
			SUM(pn.Cantitate) Cantitate, 0 IsEntry
		From FiseRetur a
		INNER JOIN ProduseFisaRetur pn on pn.FisaId = a.Id
		Where a.Active = 1 AND MONTH(a.DataFisa) = MONTH(rDate) AND 
		YEAR(a.DataFisa) = YEAR(rDate)
		GROUP BY ProdusId;

		CREATE TEMPORARY TABLE m_fisaPrOUT AS
		SELECT pn.ProdusId, SUM(pn.ValoareLeiVanzare+pn.ValoareTVAVanzare) Valoare, 
			SUM(pn.Cantitate) Cantitate, 0 IsEntry
		From FiseProductie a
		INNER JOIN IngredienteFisaProductie pn on pn.ProductieId = a.Id
		Where a.Active = 1 AND 
		MONTH(a.Data) = MONTH(rDate) AND 
		YEAR(a.Data) = YEAR(rDate)
		GROUP BY ProdusId;
		
		CREATE TEMPORARY TABLE m_outData AS
		SELECT p.ID, 		
		IFNULL(ROUND((IFNULL(inv.Valoare, 0) + IFNULL(n.Valoare, 0) + IFNULL(a.Valoare, 0) + IFNULL(fr.Valoare, 0) + 
			IFNULL(pro.Valoare, 0) + IFNULL(b.Valoare, 0) + IFNULL(r.Valoare, 0))
			/ IFNULL(IFNULL(inv.Cantitate, 0) + IFNULL(n.Cantitate, 0) + IFNULL(a.Cantitate, 0) + IFNULL(fr.Cantitate, 0) + 
				IFNULL(pro.Cantitate, 0) + IFNULL(b.Cantitate, 0) + IFNULL(r.Cantitate, 0), 1), 2), p.Pret) Pret,

		ROUND(IFNULL(inv.Cantitate, 0) + IFNULL(n.Cantitate, 0) + IFNULL(a.Cantitate, 0) + IFNULL(fr.Cantitate, 0) + 
			IFNULL(pro.Cantitate, 0) + IFNULL(b.Cantitate, 0) + IFNULL(r.Cantitate, 0), 3) Iesiri,

		ROUND((IFNULL(inv.Cantitate, 0) + IFNULL(n.Cantitate, 0) + IFNULL(a.Cantitate, 0) + IFNULL(fr.Cantitate, 0) + 
			IFNULL(pro.Cantitate, 0) + IFNULL(b.Cantitate, 0) + IFNULL(r.Cantitate, 0))
			* IFNULL(ROUND((IFNULL(inv.Valoare, 0) + IFNULL(n.Valoare, 0) + IFNULL(a.Valoare, 0) + IFNULL(fr.Valoare, 0) + 
				IFNULL(pro.Valoare, 0) + IFNULL(b.Valoare, 0) + IFNULL(r.Valoare, 0))
				/ IFNULL(IFNULL(inv.Cantitate, 0) + IFNULL(n.Cantitate, 0) + IFNULL(a.Cantitate, 0) + IFNULL(fr.Cantitate, 0) + 
					IFNULL(pro.Cantitate, 0) + IFNULL(b.Cantitate, 0) + IFNULL(r.Cantitate, 0), 1), 2), p.Pret), 2) ValIesiri 
		FROM TProduse p
		LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
		LEFT JOIN m_transfers t ON t.ProdusId = p.ID
		LEFT JOIN m_reciepts r ON r.ProdusId = p.ID
		LEFT JOIN m_bonC b ON b.ProdusId = p.ID
		LEFT JOIN m_fisaPrOUT pro ON pro.ProdusId = p.ID
		LEFT JOIN m_fisaR fr ON fr.ProdusId = p.ID
		LEFT JOIN m_avize a ON a.ProdusId = p.ID
		LEFT JOIN m_necesar n ON n.ProdusId = p.ID
		LEFT JOIN m_invoices inv ON inv.ProdusId = p.ID
		WHERE (subCatId = 0 OR p.IDSubCategorie = subCatId) AND
			(catId = 0 OR sc.IdCategorie = catId) AND
			(vatId = 0 OR p.TVA = vatId) AND
			(elemType = 0 OR 
			 (elemType = 1 AND p.MateriePrima = 1) OR 
			 (elemType = 2 AND p.MateriePrima = 0 AND p.Complex = 0) OR 
			 (elemType = 3 AND p.Complex = 1));

		DROP TEMPORARY TABLE IF EXISTS m_bonC;
		DROP TEMPORARY TABLE IF EXISTS m_fisaPrOUT;
		DROP TEMPORARY TABLE IF EXISTS m_fisaR;
		DROP TEMPORARY TABLE IF EXISTS m_avize;
		DROP TEMPORARY TABLE IF EXISTS m_necesar;
		DROP TEMPORARY TABLE IF EXISTS m_invoices;
		DROP TEMPORARY TABLE IF EXISTS m_reciepts;
		LEAVE sp_out;
	END IF;
	
	CREATE TEMPORARY TABLE m_outData AS
	SELECT p.ID, 		
	ROUND(IFNULL(r.Cantitate, 0), 3) Iesiri,
	IFNULL(ROUND(r.Valoare/IFNULL(r.Cantitate, 1), 2), p.Pret) Pret,
	ROUND(IFNULL(r.Cantitate, 0)*IFNULL(ROUND(r.Valoare/IFNULL(r.Cantitate, 1), 2), p.Pret), 2) ValIesiri 
	FROM TProduse p
	LEFT JOIN m_reciepts r ON r.ProdusId = p.ID
	LEFT JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
	WHERE (subCatId = 0 OR p.IDSubCategorie = subCatId) AND
		(catId = 0 OR sc.IdCategorie = catId) AND
		(vatId = 0 OR p.TVA = vatId) AND
		(elemType = 0 OR 
			(elemType = 1 AND p.MateriePrima = 1) OR 
			(elemType = 2 AND p.MateriePrima = 0 AND p.Complex = 0) OR 
			(elemType = 3 AND p.Complex = 1));

	DROP TEMPORARY TABLE IF EXISTS m_bonC;
	DROP TEMPORARY TABLE IF EXISTS m_fisaPrOUT;
	DROP TEMPORARY TABLE IF EXISTS m_fisaR;
	DROP TEMPORARY TABLE IF EXISTS m_avize;
	DROP TEMPORARY TABLE IF EXISTS m_necesar;
	DROP TEMPORARY TABLE IF EXISTS m_invoices;
	DROP TEMPORARY TABLE IF EXISTS m_reciepts;
	LEAVE sp_out;	 
END;$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `OptimizeTables` ()  BEGIN 
	OPTIMIZE TABLE SubcategoryHistory;
	OPTIMIZE TABLE CategoryHistory;
	OPTIMIZE TABLE InventarHistory;
	OPTIMIZE TABLE ProductHistory;


	OPTIMIZE TABLE ProduseFisaProductie;
	OPTIMIZE TABLE ProduseFisaNecesar;
	OPTIMIZE TABLE ProduseBonTransfer;
	OPTIMIZE TABLE ProduseBonConsum;
	OPTIMIZE TABLE ProduseFisaRetur;
	OPTIMIZE TABLE TFacturiProduse;
	OPTIMIZE TABLE ProduseAviz;
	OPTIMIZE TABLE ProduseNIR;

	OPTIMIZE TABLE TProduseBonActivTemp;
	OPTIMIZE TABLE TProduseBonActiv;
	OPTIMIZE TABLE TZProduseTUTA;
	OPTIMIZE TABLE TStocuriTura;
	OPTIMIZE TABLE TZProdus;

	OPTIMIZE TABLE IngredienteFisaProductie;
	OPTIMIZE TABLE IngredienteFisaNecesar;
	OPTIMIZE TABLE ProductRecipes;
	OPTIMIZE TABLE Ingredients;
	OPTIMIZE TABLE TProduse;
	OPTIMIZE TABLE Recipes;

	OPTIMIZE TABLE Furnizori;
	OPTIMIZE TABLE TClienti;
	OPTIMIZE TABLE TErori;
	OPTIMIZE TABLE TUsers;
	OPTIMIZE TABLE TTure;
	OPTIMIZE TABLE LOG;
	OPTIMIZE TABLE TZ;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `PartialFiscalCost` (IN `startDate` DATETIME, IN `endDate` DATETIME)  BEGIN 
	SELECT pn.IdProdus ProdusId, p.CodBare,
	Round(SUM(pn.Cantitate-pn.StornoQ), 3) Cantitate
	From TZ tz
	INNER JOIN TZProdus pn on pn.IdBon = tz.Id
	INNER JOIN TProduse p on p.ID = pn.IdProdus
	Where tz.TotalProtocol = 0 
	AND tz.DataInchidere BETWEEN startDate AND endDate
	GROUP BY pn.IdProdus;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `PeriodStockReport` (IN `startDate` DATETIME, IN `endDate` DATETIME, IN `breakdown` TINYINT)  BEGIN 
	DECLARE idTuraInit INT DEFAULT 0;
	DECLARE idTuraEnd INT DEFAULT 0;

    If breakdown = 1 THEN
		Select IFNULL(p.Denumire, 'Produsul a fost sters') as Denumire, IFNULL(p.UM, '-') as UM, DATE_FORMAT(t.DATAO, '%d-%m-%Y %H-%i') as Opening, 
        DATE_FORMAT(t.DATAC, '%d-%m-%Y %H-%i') as Closing, st.STOCINITIAL as 'Stoc Initial', 
        IFNULL(pnt.Cantitate, 0) as Intrare, (IFNULL(pnt.Cantitate, 0) + st.STOCINITIAL - st.STOCFINAL) as Vanzare, st.STOCFINAL as 'Stoc Final' 
        From TTure as t 
        Inner Join TStocuriTura as st on st.IDTURA = t.ID 
        Left Join(Select pn.ProdusId, Sum(pn.Cantitate) Cantitate
            From NIRuri as n 
            INNER Join ProduseNIR as pn on pn.NIRId = n.Id 
            Where n.DataFactura BETWEEN startDate AND endDate AND n.Active = 1 AND n.Negative = 0 
            Group By ProdusId) 
        as pnt on pnt.ProdusId = st.IDPRODUS 
        Left Join TProduse as p on p.ID = st.IDPRODUS 
        Where t.DATAO BETWEEN startDate AND endDate AND 
        t.DATAC < endDate AND t.DataClose != 0 
        Order By Opening;
    ELSE
        SET idTuraInit = GetShiftId(startDate, endDate, 1);
        SET idTuraEnd = GetShiftId(startDate, endDate, 0);

        Select p.ID, p.Denumire, p.UM, IFNULL(Round(st.STOCINITIAL,3), 0) as 'Stoc Initial', 
        IFNULL(Round(aux4.Cantitate,3), 0) as 'Vanzari', IFNULL(Round(pnt.Cantitate,3), 0) as Intrari, 
        IFNULL(Round(st1.STOCFINAL,3), 0) as 'Stoc Final', p.CodBare, p.CodPlu
        from TProduse as p
        Left Join TStocuriTura as st on p.ID = st.IDPRODUS AND st.IDTURA = idTuraInit
        Left Join TStocuriTura as st1 on p.ID = st1.IDPRODUS AND st1.IDTURA = idTuraEnd
        Left Join (Select tzp.IdProdus, SUM(tzp.Cantitate) as Cantitate
                    FROM TZ as tz
                     Join TZProdus as tzp on tz.Id = tzp.IdBon
                    where tz.DataInchidere BETWEEN startDate AND endDate 
                    Group By IdProdus) as aux4 on aux4.IdProdus = p.ID
        Left Join (Select pn.ProdusId, Sum(pn.Cantitate) Cantitate
             From NIRuri as n
            INNER Join ProduseNIR as pn on pn.NIRId = n.Id
            Where n.DataFactura BETWEEN startDate AND endDate AND n.Active = 1 AND n.Negative = 0 
            Group By ProdusId) as pnt on pnt.ProdusId = p.ID
        ORDER By p.ID;
    END IF;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `PhraseSplitter` (IN `phrase` TEXT, IN `delimiter` VARCHAR(10))  sp: BEGIN
    SET @i = 1;
    SET @phraseAux = phrase;
    SET @n = FORMAT((LENGTH(@phraseAux)-LENGTH(REPLACE(@phraseAux, delimiter, '')))/LENGTH(delimiter), 0)+1;

    CREATE TEMPORARY TABLE IF NOT EXISTS words(word TEXT NULL);
    IF LENGTH(@phraseAux)-LENGTH(REPLACE(@phraseAux, delimiter, '')) = 0 
    THEN
        insert into words (word) SELECT phrase;
        LEAVE sp;
    END IF;

    simple_loop: LOOP
        SET @aux = SUBSTRING_INDEX(@phraseAux, delimiter, 1);
        insert into words (word) SELECT @aux;
        SET @i = @i + 1;
        SET @phraseAux = REPLACE(@phraseAux, CONCAT(@aux, delimiter), '');

        IF @n >= @i THEN
          ITERATE simple_loop;
        END IF;

        LEAVE simple_loop;
      END LOOP simple_loop;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `ProductCompositionReport` (IN `id` INT)  BEGIN 
    SELECT IFNULL(p.Denumire, 'Produsul a fost sters') Denumire, IFNULL(p.CodBare, '-') CodBare,  IFNULL(p.CodPlu, '-') CodPlu, 
           IFNULL(p.MateriePrima, 0) MateriePrima, IFNULL(tva.Denumire, '-') TVA, 
           IFNULL(p.UM, '-') UM, IFNULL(p.Pret, 0) Pret, IFNULL(p.PretAchizitie, 0) PretA, 
           IFNULL(p.Stoc, 0) Stoc, Round(IFNULL(pr.Quantity*i.Quantity , 0), 3) Cantitate
    FROM ProductRecipes pr
    INNER JOIN Ingredients i on i.RecipeId = pr.RecipeId
    LEFT JOIN TProduse p on i.IngredientId = p.ID
    LEFT Join TTVA as tva on p.TVA = tva.ID
    WHERE ProductId = id
    GROUP BY i.IngredientId
    ORDER BY Denumire;    
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `ProductsRecieptReport` (IN `nrReciept` INT)  BEGIN 
	SELECT IFNULL(p.Denumire, 'Produsul a fost sters') Denumire, IFNULL(p.CodBare, '-') CodBare, IFNULL(p.CodPlu, '-') CodPlu,
		Round(IFNULL(p.Pret, 0),2) PretActual, Round(IFNULL(p.PretAchizitie, 0),2) PretAchizitieActual, 
		IFNULL(p.UM, '-') UM, IFNULL(p.MateriePrima, 0) MateriePrima, IFNULL(tvap.Denumire, '-') TVAP,
		Round(tzp.Pret,2) Pret, Round(tzp.PretA,2) PretAchizitie, Round(tzp.Discount, 2) Discount, 
		Round(tzp.Cantitate, 3) Cantitate, Round(tzp.StornoQ, 3) StornoQ, 
		Round(tzp.Cantitate - tzp.StornoQ, 3) Quantity, tva.Denumire TVA
	From TZProdus tzp
    INNER Join TTVA as tva on tzp.TVA = tva.ID
	Left Join TProduse p on tzp.IdProdus = p.ID
    Left Join TTVA as tvap on p.TVA = tvap.ID
	WHERE tzp.IdBon = nrReciept;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `ProfitBrut` (IN `startDate` DATETIME, IN `endDate` DATETIME, IN `categoryId` INT, IN `subcategoryId` INT)  BEGIN    
	DECLARE idTuraInit INT DEFAULT 0;
	DECLARE idTuraEnd INT DEFAULT 0;
    SET idTuraInit = GetShiftId(startDate, endDate, 1);
    SET idTuraEnd = GetShiftId(startDate, endDate, 0);
	
    CREATE TEMPORARY TABLE intrari AS
	SELECT pn.ProdusId, SUM(pn.Cantitate) Cantitate, 
    IFNULL(SUM(pn.ValoareLei), 0) / IFNULL(SUM(pn.Cantitate), 1) PretAchizitie, 
    IFNULL(SUM(pn.ValoareLeiVanzare), 0)/IFNULL(SUM(pn.Cantitate), 1) PretVanzare
    FROM NIRuri n
    INNER JOIN ProduseNIR pn ON n.Id = pn.NIRId
    WHERE n.DataFactura BETWEEN startDate AND endDate 
    AND n.Active = 1 AND n.Negative = 0
    GROUP BY pn.ProdusId;
    
    CREATE TEMPORARY TABLE stocInitial AS
	SELECT st.IDPRODUS ProdusId, st.STOCINITIAL Cantitate
    FROM TStocuriTura st 
    WHERE st.IDTURA = idTuraInit
    GROUP BY ProdusId;
    
    CREATE TEMPORARY TABLE stocFinal AS
	SELECT st.IDPRODUS ProdusId, st.STOCFINAL Cantitate
    FROM TStocuriTura st 
    WHERE st.IDTURA = idTuraEnd
    GROUP BY ProdusId;
    
    CREATE TEMPORARY TABLE iesiri AS
	SELECT tzp.IdProdus ProdusId, SUM(tzp.Cantitate) Cantitate
    FROM TZ tz
    INNER JOIN TZProdus tzp ON tz.Id = tzp.IdBon
    WHERE tz.DataInchidere BETWEEN startDate AND endDate
    GROUP BY tzp.IdProdus;
	
	SELECT IFNULL(p.Denumire, '-') Denumire, IFNULL(p.CodPlu, '-') CodPlu, Round(IFNULL(i1.PretAchizitie, p.PretAchizitie),2) PretAchizitie, 
		   Round(IFNULL(i1.PretVanzare, p.Pret),2) PretVanzare, IFNULL(p.UM, '-') UM, Round(IFNULL(s1.Cantitate, 0),3) StocInitial, 
		   Round(IFNULL(IFNULL(i1.PretAchizitie, p.PretAchizitie)*s1.Cantitate, 0),2) ValoareStocInitial, Round(IFNULL(i1.Cantitate, 0),3) Intrari,
		   Round(IFNULL(IFNULL(i1.PretAchizitie, p.PretAchizitie)*i1.Cantitate, 0),2) ValoareIntrari, Round(IFNULL(i2.Cantitate, 0),3) Iesiri, 
		   Round(IFNULL(IFNULL(i1.PretAchizitie, p.PretAchizitie)*i2.Cantitate, 0),2) CostIesiri, Round(IFNULL(IFNULL(i1.PretVanzare, p.Pret)*i2.Cantitate, 0),2) ValoareIesiri, 
		   Round(IFNULL(s2.Cantitate, 0),3) StocFinal, Round(IFNULL(IFNULL(s2.Cantitate, 0)*IFNULL(i1.PretVanzare,  p.Pret), 0),2) ValoareStocFinal, 
		   Round(IFNULL(IFNULL(i1.PretVanzare, p.Pret)*i2.Cantitate-IFNULL(i1.PretAchizitie, p.PretAchizitie)*i2.Cantitate, 0),2) ProfitBrut
	FROM TProduse p
	INNER JOIN TSubCategorii sc on p.IDSubCategorie = sc.IDSubCategorie
	INNER JOIN TCategorii c on c.IDCategorie = sc.IdCategorie
	INNER JOIN iesiri i2 on p.ID = i2.ProdusId
	LEFT JOIN intrari i1 on p.ID = i1.ProdusId
	LEFT JOIN stocInitial s1 on p.ID = s1.ProdusId
	LEFT JOIN stocFinal s2 on p.ID = s2.ProdusId
	where case when subcategoryId > 0 THEN p.IDSubCategorie = subcategoryId 
			   when categoryId > 0 AND subcategoryId <= 0 THEN c.IDCategorie = categoryId 
			   ELSE TRUE END;

    DROP TEMPORARY TABLE IF EXISTS intrari;
    DROP TEMPORARY TABLE IF EXISTS stocInitial;
    DROP TEMPORARY TABLE IF EXISTS stocFinal;
    DROP TEMPORARY TABLE IF EXISTS iesiri;    
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `ProfitPerProdus` (IN `startDate` DATETIME, IN `endDate` DATETIME)  BEGIN  
    CREATE TEMPORARY TABLE intrari AS
	SELECT pn.ProdusId, SUM(pn.Cantitate) Cantitate, 
    IFNULL(SUM(pn.ValoareLei), 0) / IFNULL(SUM(pn.Cantitate), 1) PretAchizitie
    FROM NIRuri n
    INNER JOIN ProduseNIR pn ON n.Id = pn.NIRId
    WHERE n.DataFactura BETWEEN startDate AND endDate
    AND n.Active = true AND n.Negative = 0
    GROUP BY pn.ProdusId;
	
    CREATE TEMPORARY TABLE iesiri AS
	SELECT tzp.IdProdus ProdusId, SUM(tzp.Cantitate*ROUND(tzp.Pret,2)) VanzariNete,
		   SUM(tzp.Cantitate*ROUND((100*tzp.Pret/(100-IF( tzp.Discount > 0, tzp.Discount, tz.Discount))),2)) VanzariBrute,
		   SUM(ROUND(tzp.Pret,2)-ROUND((100*tzp.Pret/(100-IF( tzp.Discount > 0, tzp.Discount, tz.Discount))),2)) DiscountAcordat
    FROM TZ tz
    INNER JOIN TZProdus tzp ON tz.Id = tzp.IdBon
    WHERE tz.DataInchidere BETWEEN startDate AND endDate
    GROUP BY tzp.IdProdus;
	
	SELECT p.Denumire, p.CodPlu, Round(IFNULL(i1.VanzariBrute, 0),2) VanzariBrute,
		   Round(IFNULL(i1.DiscountAcordat, 0),2) DiscountAcordat,
		   Round(IFNULL(i1.VanzariNete, 0),2) VanzariNete,
		   Round(IFNULL(i2.Cantitate * IFNULL(i2.PretAchizitie, p.PretAchizitie), 0),2) Cost,
		   Round(IFNULL(i1.VanzariBrute, 0)-IFNULL(i2.Cantitate * IFNULL(i2.PretAchizitie, p.PretAchizitie), 0),2) as Profit,
		   ROUND(100*(IFNULL(i1.VanzariBrute, 0)-IFNULL(i2.Cantitate * IFNULL(i2.PretAchizitie, p.PretAchizitie), 0))/IFNULL(i1.VanzariNete, 0.0001),2) as MarjaProfit		   
	FROM TProduse p
	INNER JOIN iesiri i1 on p.ID = i1.ProdusId
	LEFT JOIN intrari i2 on p.ID = i2.ProdusId;

    DROP TEMPORARY TABLE IF EXISTS intrari;
    DROP TEMPORARY TABLE IF EXISTS iesiri;  
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `ProfitSellReport` (IN `startDate` DATETIME, IN `endDate` DATETIME, IN `catTypeId` INT, IN `elemType` INT, IN `tvaId` INT, IN `catId` INT, IN `full` INT)  BEGIN 
    SET @catType = (SELECT Type FROM CategoryTypes WHERE Id = catTypeId);

    CREATE TEMPORARY TABLE sell_prods AS

    SELECT tzp.IdProdus ProdusId, SUM(tzp.Cantitate-tzp.StornoQ) Cantitate, 
    IFNULL(tva.Denumire, '-') TVA, SUM((tzp.Cantitate-tzp.StornoQ)*tzp.PretA) Cost, 
    SUM((tzp.Cantitate-tzp.StornoQ)*tzp.Pret/(1+tva.Procent*0.01)) ValoareLei, SUM((tzp.Cantitate-tzp.StornoQ)*tzp.Pret) ValoareCuTVA,
    Sum((tzp.Cantitate-tzp.StornoQ)*(100*tzp.Pret/(100-IF( tzp.Discount > 0, tzp.Discount, tz.Discount)) - tzp.Pret)) Discount,
    SUM((tzp.Cantitate-tzp.StornoQ)*tzp.Pret/(1+tva.Procent*0.01)) - SUM((tzp.Cantitate-tzp.StornoQ)*tzp.PretA) Profit
    FROM TZ tz
    INNER JOIN TZProdus tzp ON tzp.IdBon = tz.Id
    LEFT Join TTVA as tva on tzp.TVA = tva.ID
    WHERE tz.DataInchidere BETWEEN startDate AND endDate AND
        (tvaId = 0 OR tzp.TVA = tvaId) AND   
        ((full = 1 AND tz.TotalProtocol > 0) OR 
        (full = 0 AND tz.TotalProtocol <= 0) OR tz.TotalFiscal > 0)
    GROUP BY tzp.IdProdus, tzp.TVA;        
    
    SELECT IFNULL(p.Denumire, 'Produsul a fost sters') Denumire, IFNULL(p.CodBare, '-') CodBare, IFNULL(p.CodPlu, '-') CodPlu, 
           e.TVA, IFNULL(ROUND(e.Cantitate, 2), 0) Cantitate, IFNULL(ROUND(e.Cost, 2), 0) Cost, IFNULL(ROUND(e.ValoareLei, 2), 0) ValoareLei, 
           IFNULL(ROUND(e.ValoareCuTVA, 2), 0) ValoareCuTVA, IFNULL(ROUND(e.Discount, 2), 0) Discount, IFNULL(ROUND(e.Profit, 2), 0) Profit
    FROM sell_prods e
    LEFT JOIN TProduse p on p.ID = e.ProdusId    
    LEFT Join TSubCategorii as sc on sc.IDSubCategorie = p.IDSubCategorie 
	LEFT JOIN TCategorii c on c.IDCategorie = sc.IdCategorie
    WHERE 
        (catId = 0 OR sc.IdCategorie = catId) AND
        (elemType = 0 OR 
         (elemType = 1 AND p.Complex = 0) OR 
         (elemType = 2 AND p.Complex = 1)) AND
        (IFNULL(@catType, '') = '' OR c.TipCategorie = @catType)
    ORDER BY Denumire;
    
    DROP TEMPORARY TABLE IF EXISTS sell_prods;    
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `RecalculateRegister` ()  BEGIN 
	SET @total = 0;
    UPDATE TRegistru 
    SET Total = ROUND((@total := @total + Incasari - Plati), 2) 
    ORDER by Data;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `RecieptsReport` (IN `startDate` DATETIME, IN `endDate` DATETIME, IN `nrReciept` INT, IN `clientId` INT, IN `shiftId` INT, IN `recipetType` TINYINT, IN `onlyFans` TINYINT)  BEGIN 
	SELECT tz.Id, Round(tz.TotalFiscal, 2) TotalFiscal, 
	Round(tz.TotalProtocol, 2) TotalProtocol, Round(tz.Numerar,2) Numerar,
	Round(tz.Card,2) Card,  Round(tz.Bonuri,2) Bonuri, Round(tz.Vaucher,2) Vaucher, 
	Round(tz.PlataModerna,2) PlataModerna, Round(tz.Factura,2) Factura,
	Round(tz.ClientCod,2) ClientCod, Round(tz.Aviz,2) Aviz, 
	Round(tz.Discount,2) Discount, tz.DataDeschidere, tz.DataInchidere, tz.NumeUser, 
	IF(tz.CodClient != -1 AND c.Denumire IS NOT NULL, CONCAT(c.Denumire, c.CodClient), '-') Client
	From TZ tz
	Left Join TClienti c on tz.CodClient = c.CodClient
	WHERE tz.DataInchidere BETWEEN startDate AND endDate AND
	    (nrReciept = 0 OR tz.Id = nrReciept) AND
	    (shiftId = 0 OR tz.IdTura = shiftId) AND
	    (clientId = 0 OR c.ID = clientId) AND
	    (recipetType = 0 OR 
		(recipetType = 1 AND tz.TotalFiscal > 0 AND tz.TotalProtocol = 0) OR
		(recipetType = 2 AND tz.TotalFiscal = 0 AND tz.TotalProtocol > 0) OR
		(recipetType = 3 AND tz.TotalFiscal > 0 AND tz.TotalProtocol > 0)) AND
	    (onlyFans = 0 OR (tz.CodClient != null AND tz.CodClient != -1))
	;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `RecieptStockUpdate` (IN `userId` INT, IN `bonId` INT)  BEGIN
	DECLARE rs_productieId INT DEFAULT 0;
    
    DECLARE EXIT HANDLER FOR SQLEXCEPTION   
    BEGIN    
        ROLLBACK;
        GET DIAGNOSTICS CONDITION 1 @`errno` = MYSQL_ERRNO, @`sqlstate` = RETURNED_SQLSTATE, @`text` = MESSAGE_TEXT;
        SET @full_error = CONCAT('ERROR ', @`errno`, ' (', @`sqlstate`, '): ', @`text`);
		INSERT INTO TErori (Aplicatie, Class, Functie, EROARE)
        SELECT 'Vanzare', 'DAL', 'Actualizare Stoc', @full_error;
    
    END;
	
    START TRANSACTION;
		IF (SELECT Count(1) FROM TZ tz WHERE tz.Id = bonId AND tz.StockUpdated = 0) > 0 
		THEN
			CREATE TEMPORARY TABLE r_products AS
			SELECT tzp.IdProdus ProdusId, tzp.Cantitate, tzp.Pret, tzp.PretA, 
				tzp.TVA TVAId, 0 Procent, 0 Stoc, 0 Complex, 1 BasicStock
			FROM TZ tz
			INNER JOIN TZProdus tzp ON tzp.IdBon = tz.Id
			WHERE tz.Id = bonId AND StockUpdated = 0
			Group BY tzp.Id;

			UPDATE r_products rp
			INNER JOIN TProduse p ON rp.ProdusId = p.ID
			INNER JOIN TTVA tva ON rp.TVAId = tva.ID
			SET rp.Procent = tva.Procent, rp.Stoc= p.Stoc, rp.Complex = p.Complex, 
				rp.BasicStock = (p.Complex = 0 OR p.Stoc - rp.Cantitate >= 0)
			WHERE p.Active = 1;

			IF(SELECT Count(1) FROM r_products WHERE BasicStock = 0) > 0 
			THEN
				CREATE TEMPORARY TABLE r_ingredients AS
				SELECT (rp.Cantitate - rp.Stoc) Cantitate, rp.Pret, rp.TVAId, pr.ProductId ProdusId, i.IngredientId, SUM(pr.Quantity*i.Quantity) BaseQ 
				FROM r_products rp 
				INNER JOIN ProductRecipes pr ON rp.ProdusId = pr.ProductId 
				INNER JOIN Ingredients i ON pr.RecipeId = i.RecipeId 
				WHERE rp.BasicStock = 0
				Group BY i.IngredientId;
		
				SELECT IFNULL(fp.Id, 0) INTO rs_productieId
				FROM FiseProductie fp
				WHERE fp.Instant = 1 AND fp.Active = 1 AND 
					fp.Closed = 0 AND DATE(Data) = CURRENT_DATE()
				ORDER BY Id DESC
				LIMIT 1;

				IF rs_productieId = 0 OR rs_productieId = NULL
				THEN
					INSERT INTO FiseProductie (UserId, Data, SerieFisa, NrFisa, Observatii, Instant, Closed) 
					Select userId, NOW(), s.SerieP, s.Productie+1, 'Fisa de Productie aferenta productiei instante realizate pe parcursul zilei.', 1, 0
					FROM TSerieF s 
					LIMIT 1;
					SELECT LAST_INSERT_ID() INTO rs_productieId;
					Update TSerieF Set Productie = Productie + 1;
				END IF;


				UPDATE ProduseFisaProductie pf
				INNER JOIN r_products rp ON rp.ProdusId = pf.ProdusId
				SET pf.Cantitate = pf.Cantitate + rp.Cantitate - rp.Stoc
				WHERE pf.ProductieId = rs_productieId AND rp.BasicStock = 0 
					AND pf.Pret = rp.Pret AND rp.TVAId = pf.TVAId;

				INSERT INTO ProduseFisaProductie (ProductieId, ProdusId, TVAId, Stoc, Pret, Cantitate, ValoareCuTVA, ValoareLei, ValoareTVA, TVAUnitar)
				SELECT rs_productieId, rp.ProdusId, rp.TVAId, 0, rp.Pret, rp.Cantitate - rp.Stoc, 0, 0, 0, 0
				FROM r_products rp
				LEFT JOIN ProduseFisaProductie pf ON pf.ProductieId = rs_productieId AND rp.ProdusId = pf.ProdusId 
												AND pf.Pret = rp.Pret AND rp.TVAId = pf.TVAId
				WHERE rp.BasicStock = 0 AND pf.Id IS NULL;

			
				UPDATE IngredienteFisaProductie ig
				INNER JOIN ProduseFisaProductie pf ON ig.ProdusFisaId = pf.Id
				INNER JOIN r_ingredients ri ON ri.IngredientId = ig.IngredientId
				SET ig.BaseQ = ri.BaseQ, ig.Cantitate = ig.Cantitate + ri.Cantitate*ri.BaseQ
				WHERE pf.ProductieId = rs_productieId AND pf.Pret = ri.Pret AND ri.TVAId = pf.TVAId;
			
				INSERT INTO IngredienteFisaProductie (ProductieId, ProdusFisaId, ProdusId, IngredientId, TVAId, Stoc, Pret, Cantitate, BaseQ, PretAchizitie, ValoareCuTVA, ValoareLei, ValoareTVA, TVAUnitar, MateriePrima)
				SELECT rs_productieId, pf.Id, ri.ProdusId, ri.IngredientId , p.TVA, p.Stoc, p.Pret, ri.Cantitate*ri.BaseQ, ri.BaseQ, p.PretAchizitie, 0, 0, 0, 0, p.MateriePrima
				FROM r_ingredients ri
				INNER JOIN TProduse p ON ri.IngredientId = p.ID
				INNER JOIN ProduseFisaProductie pf ON pf.ProductieId = rs_productieId AND ri.ProdusId = pf.ProdusId 
												AND pf.Pret = ri.Pret AND ri.TVAId = pf.TVAId
				LEFT JOIN IngredienteFisaProductie ig ON ig.ProductieId = rs_productieId AND 
													ig.ProdusId = ri.ProdusId AND
													ig.IngredientId = ri.IngredientId 
				WHERE p.Active = 1 AND ig.Id IS NULL;

				UPDATE TProduse p
				INNER JOIN (Select IngredientId, SUM(Cantitate) Cantitate, BaseQ 
					FROM r_ingredients GROUP BY IngredientId) rp ON rp.IngredientId = p.ID
				SET p.Stoc = p.Stoc - rp.Cantitate*rp.BaseQ
				WHERE p.Active = 1;
			END IF;

			UPDATE TProduse p
			INNER JOIN r_products rp ON rp.ProdusId = p.ID
			SET p.Stoc = IF(p.Complex = 0, p.Stoc - rp.Cantitate, GREATEST(p.Stoc - rp.Cantitate, 0))
			WHERE p.Active = 1;

			UPDATE TZ tz SET tz.StockUpdated = 1 WHERE tz.Id = bonId;
		END IF;
    COMMIT;

	DROP TEMPORARY TABLE IF EXISTS r_products;
	DROP TEMPORARY TABLE IF EXISTS r_ingredients;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `RecipesCostReport` (IN `subCatId` INT, IN `vatId` INT)  BEGIN 
	CREATE TEMPORARY TABLE products AS
	SELECT p.ID ProductId, p.IDSubCategorie, p.TVA, p.Denumire, 
		p.CodBare ,p.CodPlu, Round(p.Stoc, 3) Stoc, Round(p.Pret, 2) Pret
	FROM TProduse p
	Where p.Complex = 1 AND
		 (subCatId = 0 OR IFNULL(p.IDSubCategorie, 0) = subCatId) AND
		 (vatId = 0 OR IFNULL(p.TVA, 0) = vatId);
		 
	CREATE TEMPORARY TABLE recipies AS
	SELECT p.ProductId, p.RecipeId, p.Quantity
	FROM ProductRecipes p
	Where p.ProductId IN (Select ProductId From products);
		 
	CREATE TEMPORARY TABLE ingredients AS
	SELECT r.ProductId, SUM(Round(i.Quantity * r.Quantity * p.Pret, 2)) Cost
	FROM Ingredients i
	INNER Join recipies r on r.RecipeId = i.RecipeId
	INNER Join TProduse p on p.ID = i.IngredientId
	Group BY r.ProductId;
	
	
	Select p.Denumire, p.CodBare, p.CodPlu, sc.NumeSubCategorie, 
	tva.Denumire as TVA, p.Pret, p.Stoc, i.Cost
	From  products p
	INNER Join ingredients i on p.ProductId = i.ProductId 
	INNER Join TSubCategorii as sc on sc.IDSubCategorie = p.IDSubCategorie 
	INNER Join TTVA as tva on p.TVA = tva.ID;

	DROP TEMPORARY TABLE IF EXISTS recipies;
	DROP TEMPORARY TABLE IF EXISTS products;
	DROP TEMPORARY TABLE IF EXISTS ingredients;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `SearchCategory` (IN `filter` TEXT, IN `categoryType` VARCHAR(256))  BEGIN
    CALL PhraseSplitter(filter, ' ');
	SET @nbWords = IF(IFNULL(filter, '') = '', 0, (SELECT COUNT(*) FROM words));

    SELECT c.IDCategorie Id, c.NumeCategorie Nume, COUNT(c.IDCategorie) Distance
    FROM TCategorii c
    LEFT JOIN words w ON POSITION(LOWER(w.word) IN LOWER(c.NumeCategorie)) > 0
    WHERE (@nbWords = 0 or (@nbWords > 0 AND w.word IS NOT NULL)) AND
          (categoryType = '' OR (c.TipCategorie = categoryType))
	GROUP BY c.IDCategorie
	HAVING @nbWords = 0 OR Distance > @nbWords/2
    ORDER BY Distance DESC, Nume, Id
    LIMIT 50;
    
    DROP TEMPORARY TABLE IF EXISTS words;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `SearchClients` (IN `filter` TEXT)  BEGIN
    CALL PhraseSplitter(filter, ' ');
	SET @nbWords = IF(IFNULL(filter, '') = '', 0, (SELECT COUNT(*) FROM words));

    SELECT c.ID Id, CONCAT(c.Denumire, '-', c.CodClient) Nume, COUNT(c.ID) Distance
    FROM TClienti c
    LEFT JOIN words w ON POSITION(LOWER(w.word) IN LOWER(CONCAT(c.Denumire, '-', c.CodClient))) > 0
    WHERE (@nbWords = 0 or (@nbWords > 0 AND w.word IS NOT NULL))
	GROUP BY c.ID
	HAVING @nbWords = 0 OR Distance > @nbWords/2
    ORDER BY Distance DESC, Nume, Id
    LIMIT 50;
    
    DROP TEMPORARY TABLE IF EXISTS words;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `SearchPrinter` (IN `filter` TEXT, IN `categoryType` INT)  BEGIN
    CALL PhraseSplitter(filter, ' ');
	SET @nbWords = IF(IFNULL(filter, '') = '', 0, (SELECT COUNT(*) FROM words));

    SELECT c.Id, c.Name Nume, COUNT(c.Id) Distance
    FROM Printers c
    LEFT JOIN words w ON POSITION(LOWER(w.word) IN LOWER(c.Name)) > 0
    WHERE (@nbWords = 0 or (@nbWords > 0 AND w.word IS NOT NULL)) AND
          (categoryType = 0 OR (c.CategoryTypeId = categoryType))
	GROUP BY c.Id
	HAVING @nbWords = 0 OR Distance > @nbWords/2
    ORDER BY Distance DESC, Name, Id
    LIMIT 50;
    
    DROP TEMPORARY TABLE IF EXISTS words;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `SearchProducts` (IN `filter` TEXT, IN `complex` TINYINT, IN `raw` TINYINT)  BEGIN

    CALL PhraseSplitter(filter, ' ');
	SET @nbWords = IF(IFNULL(filter, '') = '', 0, (SELECT COUNT(*) FROM words));

    SELECT c.ID Id, CONCAT(c.Pret, ' x ', c.Denumire) Nume, COUNT(c.ID) Distance
    FROM TProduse c
    LEFT JOIN words w ON POSITION(LOWER(w.word) IN LOWER(c.Denumire)) > 0
    WHERE c.Active = 1 AND (@nbWords = 0 or (@nbWords > 0 AND w.word IS NOT NULL)) AND
          (complex < 0 OR (c.Complex = complex)) AND
          (raw < 0 OR (c.MateriePrima = raw))
	GROUP BY c.ID
	HAVING @nbWords = 0 OR Distance > @nbWords/2
    ORDER BY Distance DESC, c.Denumire, Id
    LIMIT 50;
    
    DROP TEMPORARY TABLE IF EXISTS words;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `SearchRecipes` (IN `filter` TEXT)  BEGIN

    CALL PhraseSplitter(filter, ' ');
	SET @nbWords = IF(IFNULL(filter, '') = '', 0, (SELECT COUNT(*) FROM words));

    SELECT c.Id, c.Name, c.Referinta, COUNT(c.ID) Distance
    FROM Recipes c
    LEFT JOIN words w ON POSITION(LOWER(w.word) IN LOWER(c.Name)) > 0
    WHERE (@nbWords = 0 or (@nbWords > 0 AND w.word IS NOT NULL))
	GROUP BY c.ID
	HAVING @nbWords = 0 OR Distance > @nbWords/2
    ORDER BY Distance DESC, c.Name, Id
    LIMIT 50;
    
    DROP TEMPORARY TABLE IF EXISTS words;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `SearchSubcategory` (IN `filter` TEXT, IN `catId` INT)  BEGIN

    CALL PhraseSplitter(filter, ' ');
	SET @nbWords = IF(IFNULL(filter, '') = '', 0, (SELECT COUNT(*) FROM words));

    SELECT c.IDSubCategorie Id, CONCAT(c.NumeSubCategorie, '    @', aux.NumeCategorie) Nume, COUNT(c.IDSubCategorie) Distance
    FROM TSubCategorii c
    INNER JOIN TCategorii aux ON aux.IDCategorie = c.IdCategorie
    LEFT JOIN words w ON POSITION(LOWER(w.word) IN LOWER(c.NumeSubCategorie)) > 0
    WHERE (@nbWords = 0 or (@nbWords > 0 AND w.word IS NOT NULL)) AND
          (catId = 0 OR (c.IdCategorie = catId))
	GROUP BY c.IDSubCategorie
	HAVING @nbWords = 0 OR Distance > @nbWords/2
    ORDER BY Distance DESC, c.NumeSubCategorie, Id
    LIMIT 50;
    
    DROP TEMPORARY TABLE IF EXISTS words;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `SearchTag` (IN `filter` TEXT, IN `docType` TINYINT)  BEGIN
    CALL PhraseSplitter(filter, ' ');
	SET @nbWords = IF(IFNULL(filter, '') = '', 0, (SELECT COUNT(*) FROM words));

    SELECT c.Id, c.Name Nume, COUNT(c.Id) Distance
    FROM Tags c
    LEFT JOIN words w ON POSITION(LOWER(w.word) IN LOWER(c.Name)) > 0
    WHERE (@nbWords = 0 or (@nbWords > 0 AND w.word IS NOT NULL)) AND
          (docType = -1 OR c.DocType = docType OR c.DocType = 0)
	GROUP BY c.Id
	HAVING @nbWords = 0 OR Distance > @nbWords/2
    ORDER BY Distance DESC, Nume, Id
    LIMIT 50;
    
    DROP TEMPORARY TABLE IF EXISTS words;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `SellProductsReport` (IN `startDate` DATETIME, IN `endDate` DATETIME, IN `catTypeId` INT, IN `elemType` INT, IN `userId` INT, IN `catId` INT, IN `full` INT)  BEGIN 
    SET @catType = (SELECT Type FROM CategoryTypes WHERE Id = catTypeId);

    CREATE TEMPORARY TABLE sell_prods AS
    SELECT tzp.IdProdus ProdusId, SUM(tzp.Cantitate-tzp.StornoQ) Cantitate, tzp.PretA, tzp.Pret, tzp.TVA,
    SUM((tzp.Cantitate-tzp.StornoQ)*tzp.PretA) ValoareA, SUM((tzp.Cantitate-tzp.StornoQ)*tzp.Pret) ValoareV
    FROM TZ tz
    INNER JOIN TZProdus tzp ON tzp.IdBon = tz.Id
    WHERE tz.DataInchidere BETWEEN startDate AND endDate AND
        (userId = 0 OR tz.UserId = userId) AND      
        ((full = 1 AND tz.TotalProtocol > 0) OR 
        (full = 0 AND tz.TotalProtocol <= 0) OR tz.TotalFiscal > 0)
    GROUP BY tzp.IdProdus;    
    

    CREATE TEMPORARY TABLE cats AS   
    SELECT p.ID ProdusId, c.IDCategorie, c.TipCategorie
    FROM TProduse p
    INNER Join TSubCategorii as sc on sc.IDSubCategorie = p.IDSubCategorie 
	INNER JOIN TCategorii c on c.IDCategorie = sc.IdCategorie
    WHERE ID IN (SELECT ProdusId FROM  sell_prods);

    
    SELECT e.ProdusId, IFNULL(p.Denumire, 'Produsul a fost sters') Denumire, IFNULL(p.CodBare, '-') CodBare, IFNULL(p.CodPlu, '-') CodPlu, 
           IFNULL(p.UM, '-') UM, IFNULL(tva.Denumire, '-') TVA, IFNULL(ROUND(e.Pret, 2), 0) Pret, 
           IFNULL(ROUND(e.PretA,2 ), 0) PretA, IFNULL(e.Cantitate, 0) Cantitate, 
           IFNULL(ROUND(e.ValoareA, 2), 0) ValoareA, IFNULL(ROUND(ValoareV, 2), 0) ValoareV
    FROM sell_prods e
    INNER JOIN TTVA as tva on e.TVA = tva.ID
    LEFT JOIN TProduse p on p.ID = e.ProdusId    
	LEFT JOIN cats c on c.ProdusId = e.ProdusId 
    WHERE 
        (catId = 0 OR c.IDCategorie = catId) AND
        (elemType = 0 OR 
         (elemType = 1 AND p.Complex = 0) OR 
         (elemType = 2 AND p.Complex = 1)) AND
        (IFNULL(@catType, '') = '' OR c.TipCategorie = @catType)
    ORDER BY Denumire;
    
    DROP TEMPORARY TABLE IF EXISTS cats;  
    DROP TEMPORARY TABLE IF EXISTS sell_prods;      
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `SetExpirationStatus` (IN `id` INT)  BEGIN
    UPDATE TProduse p
    INNER JOIN TSubCategorii sc ON sc.IDSubCategorie = p.IDSubCategorie
    LEFT JOIN TCategorii c ON c.IDCategorie = sc.IdCategorie
    SET HasExpirationDate = 1
    WHERE c.IDCategorie = id;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `ShifStockUpdate` (IN `docId` INT, IN `docType` TINYINT, IN `actionType` TINYINT)  begin
    DECLARE docNR INT DEFAULT 0;
    DECLARE docDate DATETIME;
    IF docType = 1 THEN
        Select DataFactura INTO docDate
        FROM NIRuri
        WHERE Id = docId
        LIMIT 1;
        If actionType = 1 THEN
            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseNIR pn ON pn.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pn.Cantitate, 
            st.STOCINITIAL = st.STOCINITIAL + pn.Cantitate 
            WHERE t.DATAO > docDate and pn.NIRId = docId; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseNIR pn ON pn.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pn.Cantitate 
            WHERE t.DATAC > docDate and 
            t.DATAO < docDate and pn.NIRId = docId;

        ELSEIF actionType = 2 THEN
            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseNIR pn ON pn.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pn.Cantitate, 
            st.STOCINITIAL = st.STOCINITIAL - pn.Cantitate 
            WHERE t.DATAO > docDate and pn.NIRId = docId; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseNIR pn ON pn.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pn.Cantitate 
            WHERE t.DATAC > docDate and 
            t.DATAO < docDate and pn.NIRId = docId;
            
        END IF;
    ELSEIF docType = 2 THEN
        Select DataAviz INTO docDate
        FROM Avize
        WHERE Id = docId
        LIMIT 1;
        If actionType = 1 THEN
            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseAviz pa ON pa.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pa.Cantitate, 
            st.STOCINITIAL = st.STOCINITIAL - pa.Cantitate 
            WHERE t.DATAO > docDate and pa.AvizId = docId; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseAviz pa ON pa.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pa.Cantitate 
            WHERE t.DATAC > docDate and 
            t.DATAO < docDate and pa.AvizId = docId;

        ELSEIF actionType = 2 THEN
            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseAviz pa ON pa.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pa.Cantitate, 
            st.STOCINITIAL = st.STOCINITIAL + pa.Cantitate 
            WHERE t.DATAO > docDate and pa.AvizId = docId; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseAviz pa ON pa.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pa.Cantitate 
            WHERE t.DATAC > docDate and t.DATAO < docDate and pa.AvizId = docId;     
            
        END IF;
    ELSEIF docType = 3 THEN
        Select DataBon INTO docDate
        FROM BonuriConsum
        WHERE Id = docId
        LIMIT 1;
        If actionType = 1 THEN
            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseBonConsum pbc ON pbc.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pbc.Cantitate, 
            st.STOCINITIAL = st.STOCINITIAL - pbc.Cantitate 
            WHERE t.DATAO > docDate and pbc.BonId = docId; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseBonConsum pbc ON pbc.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pbc.Cantitate 
            WHERE t.DATAC > docDate and 
            t.DATAO < docDate and pbc.BonId = docId;

        ELSEIF actionType = 2 THEN
            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseBonConsum pbc ON pbc.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pbc.Cantitate, 
            st.STOCINITIAL = st.STOCINITIAL + pbc.Cantitate 
            WHERE t.DATAO > docDate and pbc.BonId = docId; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseBonConsum pbc ON pbc.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pbc.Cantitate 
            WHERE t.DATAC > docDate and t.DATAO < docDate and pbc.BonId = docId;   
            
        END IF;
    ELSEIF docType = 4 THEN
        Select DataFisa INTO docDate
        FROM FiseRetur
        WHERE Id = docId
        LIMIT 1;
        If actionType = 1 THEN
            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseFisaRetur pfr ON pfr.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pfr.Cantitate, 
            st.STOCINITIAL = st.STOCINITIAL - pfr.Cantitate 
            WHERE t.DATAO > docDate and pfr.FisaId = docId; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseFisaRetur pfr ON pfr.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pfr.Cantitate 
            WHERE t.DATAC > docDate and 
            t.DATAO < docDate and pfr.FisaId = docId;

        ELSEIF actionType = 2 THEN
            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseFisaRetur pfr ON pfr.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pfr.Cantitate, 
            st.STOCINITIAL = st.STOCINITIAL + pfr.Cantitate 
            WHERE t.DATAO > docDate and pfr.FisaId = docId; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseFisaRetur pfr ON pfr.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pfr.Cantitate 
            WHERE t.DATAC > docDate and t.DATAO < docDate and pfr.FisaId = docId;     
            
        END IF;
    ELSEIF docType = 5 THEN
        Select DataFactura, CONVERT(NumarFactura, SIGNED INTEGER) INTO docDate, docNR
        FROM TFacturi
        WHERE (ID = docId AND actionType = 2) OR (NumarFactura = docId AND actionType = 1)
        LIMIT 1;
        If actionType = 1 THEN
            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join TFacturiProduse pf ON pf.IdP = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pf.Cantitate, 
            st.STOCINITIAL = st.STOCINITIAL - pf.Cantitate 
            WHERE t.DATAO > docDate and pf.NumarF = docNR; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join TFacturiProduse pf ON pf.IdP = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pf.Cantitate 
            WHERE t.DATAC > docDate and 
            t.DATAO < docDate and pf.NumarF = docNR;

        ELSEIF actionType = 2 THEN
            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join TFacturiProduse pf ON pf.IdP = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pf.Cantitate, 
            st.STOCINITIAL = st.STOCINITIAL + pf.Cantitate 
            WHERE t.DATAO > docDate and pf.NumarF = docNR; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join TFacturiProduse pf ON pf.IdP = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pf.Cantitate 
            WHERE t.DATAC > docDate and t.DATAO < docDate and pf.NumarF = docNR;  
        END IF;
    ELSEIF docType = 6 THEN
        Select Data INTO docDate
        FROM FiseNecesar
        WHERE Id = docId
        LIMIT 1;
        If actionType = 1 THEN
            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join (Select ProdusId, SUM(RecievedQuantity) RecievedQuantity FROM IngredienteFisaNecesar WHERE NecesarId = docId GROUP BY ProdusId) pfr ON pfr.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pfr.RecievedQuantity, 
            st.STOCINITIAL = st.STOCINITIAL - pfr.RecievedQuantity 
            WHERE t.DATAO > docDate; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join (Select ProdusId, SUM(RecievedQuantity) RecievedQuantity FROM IngredienteFisaNecesar WHERE NecesarId = docId GROUP BY ProdusId) pfr ON pfr.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pfr.RecievedQuantity 
            WHERE t.DATAC > docDate and t.DATAO < docDate;

        ELSEIF actionType = 2 THEN
            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join (Select ProdusId, SUM(RecievedQuantity) RecievedQuantity FROM IngredienteFisaNecesar WHERE NecesarId = docId GROUP BY ProdusId) pfr ON pfr.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pfr.RecievedQuantity, 
            st.STOCINITIAL = st.STOCINITIAL + pfr.RecievedQuantity 
            WHERE t.DATAO > docDate; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join (Select ProdusId, SUM(RecievedQuantity) RecievedQuantity FROM IngredienteFisaNecesar WHERE NecesarId = docId GROUP BY ProdusId) pfr ON pfr.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pfr.RecievedQuantity 
            WHERE t.DATAC > docDate and t.DATAO < docDate;
        END IF;
    ELSEIF docType = 7 THEN
        Select Data INTO docDate
        FROM BonTransfer
        WHERE Id = docId
        LIMIT 1;
        If actionType = 1 THEN
            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseBonTransfer pfr ON pfr.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pfr.Cantitate, 
            st.STOCINITIAL = st.STOCINITIAL - pfr.Cantitate 
            WHERE t.DATAO > docDate and pfr.TransferId = docId; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseBonTransfer pfr ON pfr.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pfr.Cantitate 
            WHERE t.DATAC > docDate and 
            t.DATAO < docDate and pfr.TransferId = docId;

        ELSEIF actionType = 2 THEN
            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseBonTransfer pfr ON pfr.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pfr.Cantitate, 
            st.STOCINITIAL = st.STOCINITIAL + pfr.Cantitate 
            WHERE t.DATAO > docDate and pfr.TransferId = docId; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseBonTransfer pfr ON pfr.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pfr.Cantitate 
            WHERE t.DATAC > docDate and t.DATAO < docDate and pfr.TransferId = docId;
        END IF;
    ELSEIF docType = 8 THEN
        Select Data INTO docDate
        FROM FiseProductie
        WHERE Id = docId
        LIMIT 1;
        If actionType = 1 THEN
            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join (Select IngredientId, SUM(Cantitate) Cantitate FROM IngredienteFisaProductie WHERE ProductieId = docId GROUP BY IngredientId) pfr ON pfr.IngredientId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pfr.Cantitate, 
            st.STOCINITIAL = st.STOCINITIAL - pfr.Cantitate 
            WHERE t.DATAO > docDate; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join (Select IngredientId, SUM(Cantitate) Cantitate FROM IngredienteFisaProductie WHERE ProductieId = docId GROUP BY IngredientId) pfr ON pfr.IngredientId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pfr.Cantitate 
            WHERE t.DATAC > docDate and t.DATAO < docDate;

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseFisaProductie pfr ON pfr.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pfr.Cantitate, 
            st.STOCINITIAL = st.STOCINITIAL + pfr.Cantitate 
            WHERE t.DATAO > docDate and pfr.ProductieId = docId; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseFisaProductie pfr ON pfr.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pfr.Cantitate 
            WHERE t.DATAC > docDate and t.DATAO < docDate and pfr.ProductieId = docId;

        ELSEIF actionType = 2 THEN
            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join (Select IngredientId, SUM(Cantitate) Cantitate FROM IngredienteFisaProductie WHERE ProductieId = docId GROUP BY IngredientId) pfr ON pfr.IngredientId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pfr.Cantitate, 
            st.STOCINITIAL = st.STOCINITIAL + pfr.Cantitate 
            WHERE t.DATAO > docDate; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join (Select IngredientId, SUM(Cantitate) Cantitate FROM IngredienteFisaProductie WHERE ProductieId = docId GROUP BY IngredientId) pfr ON pfr.IngredientId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL + pfr.Cantitate 
            WHERE t.DATAC > docDate and t.DATAO < docDate;

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseFisaProductie pfr ON pfr.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pfr.Cantitate, 
            st.STOCINITIAL = st.STOCINITIAL - pfr.Cantitate 
            WHERE t.DATAO > docDate and pfr.ProductieId = docId; 

            UPDATE TStocuriTura st 
            INNER JOIN TTure t ON st.IDTURA = t.ID 
            INNER Join ProduseFisaProductie pfr ON pfr.ProdusId = st.IDPRODUS 
            SET st.STOCFINAL = st.STOCFINAL - pfr.Cantitate 
            WHERE t.DATAC > docDate and t.DATAO < docDate and pfr.ProductieId = docId;
        END IF;
    END IF;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `UpdateProductStock` (IN `docId` INT, IN `docType` TINYINT, IN `actionType` TINYINT)  begin
    DECLARE docNR INT DEFAULT 0;
    IF docType = 1 THEN
        IF actionType = 1 THEN
            update TProduse as p 
            INNER Join ProduseNIR as pn on pn.ProdusId = p.ID 
                Set p.Stoc = p.Stoc + pn.Cantitate, 
                p.PretAchizitie = pn.PretAchizitie, 
                p.Pret = pn.PretVanzare, p.TVAF = pn.TVAFId, 
                p.AdaosNIR = IF(pn.AdaosType, (pn.Adaos * pn.PretAchizitie / 100), pn.Adaos) 
             WHERE p.Active = 1 AND pn.NIRId = docId;

            update TMarimi as m 
            INNER Join MarimiProduseNIR as mp on m.Id = mp.SizeId 
                Set m.Stoc = m.Stoc + mp.Cantitate 
            Where mp.NIRId = docId;

        ELSEIF actionType = 2 THEN
            update TProduse as p 
            INNER Join ProduseNIR as pn on pn.ProdusId = p.ID 
                Set p.Stoc = p.Stoc - pn.Cantitate
             WHERE p.Active = 1 AND pn.NIRId = docId;

            update TMarimi as m 
            INNER Join MarimiProduseNIR as mp on m.Id = mp.SizeId 
                Set m.Stoc = m.Stoc - mp.Cantitate 
            Where mp.NIRId = docId;

        ELSEIF actionType = 3 THEN
            update TProduse as p 
            INNER Join ProduseNIR as pn on pn.ProdusId = p.ID 
                Set p.Stoc = p.Stoc + pn.Cantitate 
             WHERE p.Active = 1 AND pn.NIRId = docId;

            update TMarimi as m 
            INNER Join MarimiProduseNIR as mp on m.Id = mp.SizeId 
                Set m.Stoc = m.Stoc + mp.Cantitate 
            Where mp.NIRId = docId;
            
        END IF;
    ELSEIF docType = 2 THEN
        IF actionType = 1 THEN
            update TProduse as p 
            INNER Join ProduseAviz pa on pa.ProdusId = p.ID 
                Set p.Stoc = p.Stoc - pa.Cantitate
            WHERE p.Active = 1 AND pa.AvizId = docId;
            
            update TMarimi as m 
            INNER Join MarimiProduseAviz as mp on m.Id = mp.SizeId 
                Set m.Stoc = m.Stoc - mp.Cantitate 
            Where mp.AvizId = docId;
        ELSEIf actionType = 2 THEN
            update TProduse as p 
            INNER Join ProduseAviz pa on pa.ProdusId = p.ID 
                Set p.Stoc = p.Stoc + pa.Cantitate
            WHERE p.Active = 1 AND pa.AvizId = docId;
            
            update TMarimi as m 
            INNER Join MarimiProduseAviz as mp on m.Id = mp.SizeId 
                Set m.Stoc = m.Stoc + mp.Cantitate 
            WHERE mp.AvizId = docId;
        END IF;
    ELSEIF docType = 3 THEN
        IF actionType = 1 THEN
            update TProduse as p 
            INNER Join ProduseBonConsum pbc ON pbc.ProdusId = p.ID 
                Set p.Stoc = p.Stoc - pbc.Cantitate
            WHERE p.Active = 1 AND pbc.BonId = docId;
            
            update TMarimi as m 
            INNER Join MarimiProduseBonConsum as mp on m.Id = mp.SizeId 
                Set m.Stoc = m.Stoc - mp.Cantitate 
            Where mp.BonConsumId = docId;
        ELSEIf actionType = 2 THEN
            update TProduse as p 
            INNER Join ProduseBonConsum pbc ON pbc.ProdusId = p.ID 
                Set p.Stoc = p.Stoc + pbc.Cantitate
            WHERE p.Active = 1 AND pbc.BonId = docId;
            
            update TMarimi as m 
            INNER Join MarimiProduseBonConsum as mp on m.Id = mp.SizeId 
                Set m.Stoc = m.Stoc + mp.Cantitate 
            Where mp.BonConsumId = docId;
        END IF;
    ELSEIF docType = 4 THEN
        IF actionType = 1 THEN
            update TProduse as p 
            INNER Join ProduseFisaRetur pfr ON pfr.ProdusId = p.ID 
                Set p.Stoc = p.Stoc - pfr.Cantitate
            WHERE p.Active = 1 AND pfr.FisaId = docId;
            
            update TMarimi as m 
            INNER Join MarimiProduseFisaRetur as mp on m.Id = mp.SizeId 
                Set m.Stoc = m.Stoc - mp.Cantitate 
            Where mp.FisaReturId = docId;
        ELSEIf actionType = 2 THEN
            update TProduse as p 
            INNER Join ProduseFisaRetur pfr ON pfr.ProdusId = p.ID 
                Set p.Stoc = p.Stoc + pfr.Cantitate
            WHERE p.Active = 1 AND pfr.FisaId = docId;
            
            update TMarimi as m 
            INNER Join MarimiProduseFisaRetur as mp on m.Id = mp.SizeId 
                Set m.Stoc = m.Stoc + mp.Cantitate 
            Where mp.FisaReturId = docId;
        END IF;
    ELSEIF docType = 5 THEN
        Select  CONVERT(NumarFactura, SIGNED INTEGER) INTO docNR
        FROM TFacturi
        WHERE (ID = docId AND actionType = 2) OR (NumarFactura = docId AND actionType = 1)
        LIMIT 1;
        IF actionType = 1 THEN
            update TProduse as p 
            INNER Join TFacturiProduse pf ON pf.IdP = p.ID 
                Set p.Stoc = p.Stoc - pf.Cantitate
            WHERE p.Active = 1 AND pf.NumarF = docNR;
            
        ELSEIf actionType = 2 THEN
            update TProduse as p 
            INNER Join TFacturiProduse pf ON pf.IdP = p.ID 
                Set p.Stoc = p.Stoc + pf.Cantitate
            WHERE p.Active = 1 AND pf.NumarF = docNR;

        END IF;
    ELSEIF docType = 6 THEN
        IF actionType = 1 THEN
            update TProduse as p 
            INNER Join (Select ProdusId, SUM(RecievedQuantity) RecievedQuantity FROM IngredienteFisaNecesar WHERE NecesarId = docId GROUP BY ProdusId) i ON i.ProdusId = p.ID 
                Set p.Stoc = p.Stoc - i.RecievedQuantity
            WHERE p.Active = 1;
        ELSEIf actionType = 2 THEN
            update TProduse as p 
            INNER Join (Select ProdusId, SUM(RecievedQuantity) RecievedQuantity FROM IngredienteFisaNecesar WHERE NecesarId = docId GROUP BY ProdusId) i ON i.ProdusId = p.ID 
                Set p.Stoc = p.Stoc + i.RecievedQuantity
            WHERE p.Active = 1;
        END IF;
    ELSEIF docType = 7 THEN
        IF actionType = 1 THEN
            update TProduse as p 
            INNER Join ProduseBonTransfer t ON t.ProdusId = p.ID 
                Set p.Stoc = p.Stoc - t.Cantitate
            WHERE p.Active = 1 AND t.TransferId = docId;
        ELSEIf actionType = 2 THEN
            update TProduse as p 
            INNER Join ProduseBonTransfer t ON t.ProdusId = p.ID 
                Set p.Stoc = p.Stoc + t.Cantitate
            WHERE p.Active = 1 AND t.TransferId = docId;
        END IF;
    ELSEIF docType = 8 THEN
        IF actionType = 1 THEN
            update TProduse as p 
            INNER Join (Select IngredientId, SUM(Cantitate) Cantitate FROM IngredienteFisaProductie WHERE ProductieId = docId GROUP BY IngredientId) i ON i.IngredientId = p.ID 
                Set p.Stoc = p.Stoc - i.Cantitate
            WHERE p.Active = 1;

            update TProduse as p 
            INNER Join ProduseFisaProductie i ON i.ProdusId = p.ID 
                Set p.Stoc = p.Stoc + i.Cantitate
            WHERE p.Active = 1 AND i.ProductieId = docId;
        ELSEIf actionType = 2 THEN
            update TProduse as p 
            INNER Join (Select IngredientId, SUM(Cantitate) Cantitate FROM IngredienteFisaProductie WHERE ProductieId = docId GROUP BY IngredientId) i ON i.IngredientId = p.ID 
                Set p.Stoc = p.Stoc + i.Cantitate
            WHERE p.Active = 1;

            update TProduse as p 
            INNER Join ProduseFisaProductie i ON i.ProdusId = p.ID 
                Set p.Stoc = p.Stoc - i.Cantitate
            WHERE p.Active = 1 AND i.ProductieId = docId;
        END IF;
    END IF;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `UpsertNIRs` (IN `docId` INT, IN `docNr` INT, IN `userId` INT, IN `docVAT` DOUBLE, IN `docValue` DOUBLE, IN `docDate` DATETIME, IN `docTerm` DATETIME, IN `docObs` VARCHAR(256), IN `recalculateStocks` TINYINT, IN `actionType` TINYINT)  BEGIN
    If actionType = 1 THEN
        DELETE FROM ProduseNIR where NIRId = docId;
        DELETE FROM MarimiProduseNIR where NIRId = docId;
                
        CALL UpsertNIRSwitcher(docId, userId, actionType);
        
        UPDATE NIRuri Set UserId = userId, DataNIR = docDate, DataScadenta = docTerm, Active = 1, NrNIR = docNr, 
            TotalNIR = docValue, TVANIR = docVAT, Observatii = docObs where Id = docId;
        
        DELETE FROM ProduseNIRAux where NIRId = docId;
        DELETE FROM MarimiProduseNIRAux where NIRId = docId;
        
        CALL UpdateProductStock(docId, 1, actionType);
        CALL ShifStockUpdate(docId, 1, actionType);    

    ELSEIF actionType = 2 THEN
        IF recalculateStocks = 1 THEN
            CALL ShifStockUpdate(docId, 1, actionType);
        END IF;
        CALL UpdateProductStock(docId, 1, actionType);
        
        DELETE FROM ProduseNIR 
        Where NIRId = docId and ProdusId not in 
            (Select ProdusId 
            From ProduseNIRAux 
            where NIRId = docId and Active = 1);
        
        DELETE FROM MarimiProduseNIR 
        Where NIRId = docId and ProdusId not in 
            (Select ProdusId 
            From ProduseNIRAux 
            where NIRId = docId and Active = 1);
        
        UPDATE ProduseNIR as pn
        INNER Join ProduseNIRAux as pna on pn.ProdusId = pna.ProdusId and pn.NIRId = pna.NIRId 
        Set pn.TVAFId = pna.TVAFId, pn.Editing = 0, pn.Cantitate = pna.Cantitate, 
        pn.Adaos = pna.Adaos, pn.Discount = pna.Discount, pn.PretAchizitie = pna.PretAchizitie, 
        pn.PretVanzare = pna.PretVanzare, pn.Expirare = pna.Expirare, pn.NrLot = pna.NrLot, pn.ValoareLei = pna.ValoareLei, 
        pn.ValoareTVA = pna.ValoareTVA, pn.ValoareLeiFaraDiscount = pna.ValoareLeiFaraDiscount, 
        pn.ValoareLeiVanzare = pna.ValoareLeiVanzare, pn.ValoareTVAVanzare = pna.ValoareTVAVanzare, pn.TVAUnitar = pna.TVAUnitar, 
        pn.AdaosType = pna.AdaosType, pn.DiscountType = pna.DiscountType 
        Where pn.NIRId = docId;
        
        update MarimiProduseNIR mp
        INNER Join MarimiProduseNIRAux as mpa on mp.ProdusId = mpa.ProdusId and mp.SizeId = mpa.Id and mp.NIRId = mpa.NIRId
        Set mp.Cantitate = mpa.Cantitate 
        Where  mp.NIRId = docId;
        
        CALL UpsertNIRSwitcher(docId, userId, 1);
        
        UPDATE NIRuri Set UserId = userId, DataNIR = docDate, DataScadenta = docTerm, Active = 1, Editing = 0, NrNIR = docNr, 
            TotalNIR = docValue, TVANIR = docVAT, Observatii = docObs where Id = docId;
            
        DELETE FROM ProduseNIRAux where NIRId = docId;
        DELETE FROM MarimiProduseNIRAux where NIRId = docId;
        
        CALL UpdateProductStock(docId, 1, 1);
        IF recalculateStocks = 1 THEN
            CALL ShifStockUpdate(docId, 1, 1);
        END IF;
    ELSEIF actionType = 3 THEN
        IF recalculateStocks = 1 THEN
            CALL ShifStockUpdate(docId, 1, 2);
        END IF;
        CALL UpdateProductStock(docId, 1, 2);
        
        DELETE FROM ProduseNIR 
        Where NIRId = docId and ProdusId not in 
            (Select ProdusId 
            From ProduseNIRAux 
            where NIRId = docId and Active = 1);
        
        DELETE FROM MarimiProduseNIR 
        Where NIRId = docId and ProdusId not in 
            (Select ProdusId 
            From ProduseNIRAux 
            where NIRId = docId and Active = 1);
        
        UPDATE ProduseNIR as pn
        INNER Join ProduseNIRAux as pna on pn.ProdusId = pna.ProdusId and pn.NIRId = pna.NIRId 
        Set pn.TVAFId = pna.TVAFId, pn.Editing = 0, pn.Cantitate = pna.Cantitate, 
        pn.Adaos = pna.Adaos, pn.Discount = pna.Discount, pn.PretAchizitie = pna.PretAchizitie, 
        pn.PretVanzare = pna.PretVanzare, pn.Expirare = pna.Expirare, pn.NrLot = pna.NrLot, pn.ValoareLei = pna.ValoareLei, 
        pn.ValoareTVA = pna.ValoareTVA, pn.ValoareLeiFaraDiscount = pna.ValoareLeiFaraDiscount, 
        pn.ValoareLeiVanzare = pna.ValoareLeiVanzare, pn.ValoareTVAVanzare = pna.ValoareTVAVanzare, pn.TVAUnitar = pna.TVAUnitar, 
        pn.AdaosType = pna.AdaosType, pn.DiscountType = pna.DiscountType 
        Where pn.NIRId = docId;
        
        update MarimiProduseNIR mp
        INNER Join MarimiProduseNIRAux as mpa on mp.ProdusId = mpa.ProdusId and mp.SizeId = mpa.Id and mp.NIRId = mpa.NIRId
        Set mp.Cantitate = mpa.Cantitate 
        Where  mp.NIRId = docId;
        
        CALL UpsertNIRSwitcher(docId, userId, 1);
        
        UPDATE NIRuri Set UserId = userId, DataNIR = docDate, DataScadenta = docTerm, Active = 1, Editing = 0, NrNIR = docNr, 
            TotalNIR = docValue, TVANIR = docVAT, Observatii = docObs where Id = docId;
            
        DELETE FROM ProduseNIRAux where NIRId = docId;
        DELETE FROM MarimiProduseNIRAux where NIRId = docId;
        
        CALL UpdateProductStock(docId, 1, actionType);
        IF recalculateStocks = 1 THEN
            CALL ShifStockUpdate(docId, 1, 1);
        END IF;
    END IF;

END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `UpsertNIRSwitcher` (IN `docId` INT, IN `userId` INT, IN `actionType` TINYINT)  BEGIN
    If actionType = 1 THEN
        INSERT INTO ProduseNIR 
            (NIRId, ProdusId, TVAId, TVAFId, Stoc, Cantitate, SelledQuantity, 
            Adaos, Discount, PretAchizitie, ValoareLei, ValoareLeiFaraDiscount, ValoareTVA, 
            PretVanzare, TVAUnitar, ValoareLeiVanzare, ValoareTVAVanzare, Expirare, NrLot, AdaosType, 
            DiscountType, Labels, Editing, Active) 
        SELECT NIRId, ProdusId, TVAId, TVAFId, Stoc, Cantitate, SelledQuantity, 
            Adaos, Discount, PretAchizitie, ValoareLei, ValoareLeiFaraDiscount, ValoareTVA, 
            PretVanzare, TVAUnitar, ValoareLeiVanzare, ValoareTVAVanzare, Expirare, NrLot, AdaosType, 
            DiscountType, Labels, 0, 1 
        FROM ProduseNIRAux 
        where Active = 0 and NIRId = docId;
        
        INSERT INTO MarimiProduseNIR 
            (NIRId,SizeId, ProdusId, Nume, Stoc, Cantitate, Active) 
        SELECT NIRId, SizeId, ProdusId, Nume, Stoc, Cantitate, 1 
        FROM MarimiProduseNIRAux 
        where Active = 0 and NIRId = docId;   

    ELSEIF actionType = 2 THEN
	    Update NIRuri Set UserId = userId, Editing = 1 where Id = docId;

	    INSERT INTO ProduseNIRAux 
            (NIRId, ProdusId, TVAId, TVAFId, Stoc, Cantitate, SelledQuantity, 
            Adaos, Discount, PretAchizitie, ValoareLei, ValoareLeiFaraDiscount, ValoareTVA, 
            PretVanzare, TVAUnitar, ValoareLeiVanzare, ValoareTVAVanzare, Expirare, NrLot, AdaosType, 
            DiscountType, Labels, Editing, Active)
        SELECT NIRId, ProdusId, TVAId, TVAFId, Stoc, Cantitate, SelledQuantity, 
            Adaos, Discount, PretAchizitie, ValoareLei, ValoareLeiFaraDiscount, ValoareTVA, 
            PretVanzare, TVAUnitar, ValoareLeiVanzare, ValoareTVAVanzare, Expirare, NrLot, AdaosType, 
            DiscountType, Labels, Editing, Active 
        FROM ProduseNIR 
        where NIRId = docId;

        INSERT INTO MarimiProduseNIRAux 
            (NIRId,SizeId, ProdusId, Nume, Stoc, Cantitate, Active)
        SELECT NIRId, SizeId, ProdusId, Nume, Stoc, Cantitate, Active 
        FROM MarimiProduseNIR 
        where NIRId = docId;
    
        Update ProduseNIR Set Editing = 1 where NIRId = docId;
    END IF;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `UpsertProductRecipesTrr` (IN `id` INT)  BEGIN
	CREATE TEMPORARY TABLE tr_ingredients AS 
	SELECT pr.ProductId, SUM(pr.Quantity*i.Quantity*p.PretAchizitie) Cost 
	FROM ProductRecipes pr 
    INNER JOIN Ingredients i ON pr.RecipeId = i.RecipeId 
    INNER JOIN TProduse p ON p.ID = i.IngredientId 
    WHERE pr.ProductId = id
    GROUP BY pr.ProductId;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `UpsertRecipeTrr` (IN `id` INT)  BEGIN
	CREATE TEMPORARY TABLE tr_Ids AS 
	SELECT pr.ProductId 
	FROM ProductRecipes pr 
    WHERE pr.RecipeId = id;

	CREATE TEMPORARY TABLE tr_ingredients AS 
	SELECT pr.ProductId, SUM(pr.Quantity*i.Quantity*p.PretAchizitie) Cost 
	FROM ProductRecipes pr 
    INNER JOIN tr_Ids ids ON ids.ProductId = pr.ProductId 
    INNER JOIN Ingredients i ON pr.RecipeId = i.RecipeId 
    INNER JOIN TProduse p ON p.ID = i.IngredientId 
    GROUP BY pr.ProductId;
    
    DROP TEMPORARY TABLE IF EXISTS tr_Ids;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `UserCategoryTypeSellReport` (IN `startDate` DATETIME, IN `endDate` DATETIME, IN `includeProtocol` TINYINT)  BEGIN
    DECLARE u_Id INTEGER DEFAULT 0;
	DECLARE finished INTEGER DEFAULT 0;	
    DECLARE u_Name VARCHAR(255) DEFAULT '';
    
	DECLARE curs CURSOR FOR SELECT ID, NumeUtilizator FROM TUsers;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET finished = 1;
     

	CREATE TEMPORARY TABLE Desired_Types as
	SELECT p.ID, c.TipCategorie
	FROM TCategorii c  
	INNER JOIN TSubCategorii sc ON sc.IdCategorie = c.IDCategorie
	INNER JOIN TProduse p ON sc.IDSubCategorie = p.IDSubCategorie;

	CREATE TEMPORARY TABLE Reciept_Products as
	SELECT UserId, tzp.IdProdus, tzp.Cantitate, tzp.Pret
	FROM TZ tz
	INNER JOIN TZProdus tzp ON tz.Id = tzp.IdBon
	WHERE ((includeProtocol = 0 AND tz.TotalFiscal > 0 AND tz.TotalProtocol = 0) OR
			(includeProtocol = 1 AND (tz.TotalFiscal > 0 OR tz.TotalProtocol > 0))) AND
		tz.DataInchidere BETWEEN startDate AND endDate;
    
    CREATE TEMPORARY TABLE UserCategoryType AS
	SELECT Type CategoryType FROM CategoryTypes;
    
	OPEN curs;
	read_loop: LOOP
		FETCH curs INTO u_Id, u_Name;
		IF finished 
        THEN
			LEAVE read_loop;
		END IF;
        
		DROP TEMPORARY TABLE IF EXISTS Total_Values;

		SET @cmd = CONCAT('ALTER TABLE UserCategoryType ADD COLUMN `', u_Id, '_', TRIM(u_Name), '` Double(10,2) DEFAULT 0;');
 
		PREPARE stmt1 FROM @cmd ;
		EXECUTE stmt1;
		DEALLOCATE PREPARE stmt1;
		
		CREATE TEMPORARY TABLE Total_Values AS
		SELECT p.TipCategorie, SUM(rp.Cantitate*rp.Pret) Total
		FROM Reciept_Products rp
		INNER JOIN Desired_Types p ON p.ID = rp.IdProdus
		WHERE rp.UserId = u_Id 
		GROUP BY p.TipCategorie;
		
		SET @cmd = CONCAT('UPDATE UserCategoryType uc INNER JOIN Total_Values v ON v.TipCategorie = uc.CategoryType SET uc.`', u_Id, '_', TRIM(u_Name), '` = v.Total;');
        
		PREPARE stmt1 FROM @cmd ;
		EXECUTE stmt1;
		DEALLOCATE PREPARE stmt1;
	END LOOP;
	CLOSE curs;
    
	SELECT * FROM UserCategoryType;

	DROP TEMPORARY TABLE IF EXISTS Desired_Types;
	DROP TEMPORARY TABLE IF EXISTS Reciept_Products;
	DROP TEMPORARY TABLE IF EXISTS UserCategoryType;
END$$

CREATE DEFINER=`local`@`localhost` PROCEDURE `UserSellReport` (IN `startDate` DATETIME, IN `endDate` DATETIME, IN `includeProtocol` TINYINT)  BEGIN 
	SELECT u.ID, u.NumeUtilizator, u.TipUser, IFNULL(SUM(tz.TotalFiscal), 0) 'Total Fiscal', 
		IF(includeProtocol > 0, IFNULL(SUM(tz.TotalProtocol), 0), 0) 'Total Protocol', 
		IFNULL(SUM(tz.Numerar), 0) Numerar, IFNULL(SUM(tz.Card), 0) Card, IFNULL(SUM(tz.Bonuri), 0) Bonuri,
		IFNULL(SUM(tz.Vaucher), 0) Vaucher, IFNULL(SUM(tz.PlataModerna), 0) PlataModerna, IFNULL(SUM(tz.Factura), 0) Factura,
		IFNULL(SUM(tz.ClientCod), 0) 'Puncte Fidelitate', IFNULL(SUM(tz.Aviz), 0) Aviz,
		(IFNULL(SUM(tz.TotalFiscal), 0) + IF(includeProtocol > 0, IFNULL(SUM(tz.TotalProtocol), 0), 0)) Total
	FROM TZ tz
	INNER JOIN TUsers u ON u.ID = tz.UserId
	WHERE tz.DataInchidere Between startDate and endDate
	GROUP BY u.ID;
END$$

--
-- Functions
--
CREATE DEFINER=`local`@`localhost` FUNCTION `ExistTableByName` (`_tableName` VARCHAR(255)) RETURNS INT(11) SQL SECURITY INVOKER
BEGIN
  DECLARE ret INT DEFAULT 0;
  SELECT EXISTS (SELECT * FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = DATABASE() 
  AND LOWER(TABLE_NAME) = LOWER(_tablename )
  LIMIT 1)  INTO ret;
  RETURN ret;
END$$

CREATE DEFINER=`local`@`localhost` FUNCTION `GetProductLast3AvgInPrice` (`productId` INT) RETURNS INT(11) begin
	DECLARE price DOUBLE DEFAULT 0;
	
	SELECT IFNULL(SUM(pn.ValoareLei), 0)/IFNULL(SUM(pn.Cantitate), 1) INTO price
    FROM ProduseNIR pn
	INNER JOIN NIRuri n on pn.NIRId = n.Id
	WHERE pn.ProdusId = productId
	ORDER BY n.DataFactura DESC
	LIMIT 3;
    RETURN price;
END$$

CREATE DEFINER=`local`@`localhost` FUNCTION `GetShiftId` (`startDate` DATETIME, `endDate` DATETIME, `direction` TINYINT) RETURNS INT(11) begin
	DECLARE id INT DEFAULT 0;
	Select t.ID into id 
    FROM TTure t 
    WHERE t.DATAO BETWEEN startDate AND endDate AND 
	t.DATAC <= endDate and t.DataClose != 0
	ORDER BY
	CASE direction WHEN 1 THEN t.DATAO END ASC,
	CASE direction WHEN 0 THEN t.DATAO END DESC
	LIMIT 1;
    RETURN id;
END$$

CREATE DEFINER=`local`@`localhost` FUNCTION `GetShiftMonthId` (`rDate` DATE, `direction` TINYINT) RETURNS INT(11) begin
	DECLARE id INT DEFAULT 0;
	Select t.ID into id 
    FROM TTure t 
    WHERE MONTH(t.DATAO) = MONTH(rDate) AND YEAR(t.DATAO) = YEAR(rDate)
	ORDER BY
	CASE direction WHEN 1 THEN t.DATAO END ASC,
	CASE direction WHEN 0 THEN t.DATAO END DESC
	LIMIT 1;
    RETURN id;
END$$

CREATE DEFINER=`local`@`localhost` FUNCTION `ISNUMERIC` (`sIn` VARCHAR(1024)) RETURNS TINYINT(4) BEGIN
	RETURN sIn REGEXP '^(-|\\+){0,1}([0-9]+\\.[0-9]*|[0-9]*\\.[0-9]+|[0-9]+)$';
END$$

CREATE DEFINER=`local`@`localhost` FUNCTION `ProductsCount` (`id` INT) RETURNS INT(11) begin
	DECLARE nr INT DEFAULT 0;
	Select COUNT(ID) into nr 
    FROM TProduse
     WHERE Active = 1 AND IDSubCategorie = id;
    RETURN nr;
END$$

CREATE DEFINER=`local`@`localhost` FUNCTION `ProductValidation` (`id` INT) RETURNS INT(11) begin
	DECLARE nr INT DEFAULT 0;
	SELECT IFNULL(SUM(f.Nr), 0) INTO nr
	FROM (
	SELECT COUNT(ProdusId) Nr
		FROM IngredienteFisaNecesar
		WHERE ProdusId = id
		UNION
		SELECT COUNT(IngredientId) Nr
		FROM IngredienteFisaProductie
		WHERE IngredientId = id
		UNION
		SELECT COUNT(IngredientId) Nr
		FROM Ingredients
		WHERE IngredientId = id
		UNION
		SELECT COUNT(ProdusId) Nr
		FROM ProduseBonConsum
		WHERE ProdusId = id
		UNION
		SELECT COUNT(ProdusId) Nr
		FROM ProduseFisaNecesar
		WHERE ProdusId = id
		UNION
		SELECT COUNT(ProdusId) Nr
		FROM ProduseFisaProductie
		WHERE ProdusId = id
		UNION
		SELECT COUNT(ProdusId) Nr
		FROM ProduseFisaRetur
		WHERE ProdusId = id
		UNION
		SELECT COUNT(ProdusId) Nr
		FROM ProduseNIR
		WHERE ProdusId = id
		UNION
		SELECT COUNT(IdP) Nr
		FROM TFacturiProduse
		WHERE IdP = id
		UNION
		SELECT COUNT(IdProdus) Nr
		FROM TZProdus
		WHERE IdProdus = id) f;
    RETURN nr;
END$$

CREATE DEFINER=`local`@`localhost` FUNCTION `SubcategoriesCount` (`id` INT) RETURNS INT(11) begin
	DECLARE nr INT DEFAULT 0;
	Select COUNT(IDSubCategorie) into nr 
    FROM TSubCategorii
    WHERE IdCategorie = id;
    RETURN nr;
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `ActionTypes`
--

CREATE TABLE `ActionTypes` (
  `Id` int(10) UNSIGNED NOT NULL,
  `Name` varchar(50) NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `AdreseLivrrare`
--

CREATE TABLE `AdreseLivrrare` (
  `id` int(11) NOT NULL,
  `idclient` int(11) NOT NULL,
  `Oras` varchar(254) NOT NULL,
  `Strada` varchar(254) NOT NULL,
  `Numar` varchar(254) NOT NULL,
  `Bloc` varchar(254) NOT NULL,
  `Scara` varchar(254) NOT NULL,
  `Etaj` varchar(254) NOT NULL,
  `Apartament` varchar(254) NOT NULL,
  `Reper` varchar(254) NOT NULL,
  `Observatii` varchar(254) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `Atribute`
--

CREATE TABLE `Atribute` (
  `ID` int(11) NOT NULL,
  `Atribut` varchar(256) NOT NULL,
  `IDCAT` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `Avize`
--

CREATE TABLE `Avize` (
  `Id` int(11) NOT NULL,
  `TagId` int(11) DEFAULT NULL,
  `UserId` int(11) NOT NULL DEFAULT '1',
  `ClientId` int(11) NOT NULL,
  `GestClientId` int(11) NOT NULL DEFAULT '0',
  `SerieAviz` varchar(200) NOT NULL,
  `NrAviz` int(25) NOT NULL,
  `TotalAviz` double(10,2) NOT NULL,
  `TVAAviz` double(10,2) NOT NULL,
  `DataAviz` datetime NOT NULL,
  `Observatii` varchar(256) NOT NULL,
  `TransferId` int(11) DEFAULT NULL,
  `TransferGestiune` tinyint(1) NOT NULL,
  `Type` tinyint(1) NOT NULL,
  `Facturate` tinyint(1) NOT NULL DEFAULT '0',
  `WithStock` tinyint(1) NOT NULL DEFAULT '1',
  `Active` tinyint(1) NOT NULL DEFAULT '1',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `BankDetails`
--

CREATE TABLE `BankDetails` (
  `Id` int(11) NOT NULL COMMENT 'It should start from 2',
  `Banca` mediumtext NOT NULL,
  `IBAN` mediumtext NOT NULL,
  `Active` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `BonTransfer`
--

CREATE TABLE `BonTransfer` (
  `Id` int(11) NOT NULL,
  `TagId` int(11) DEFAULT NULL,
  `UserId` int(11) NOT NULL DEFAULT '1',
  `SerieTransfer` varchar(200) NOT NULL,
  `NrTransfer` bigint(20) NOT NULL,
  `Total` double(10,2) NOT NULL,
  `TVA` double(10,2) NOT NULL,
  `Data` datetime NOT NULL,
  `Type` tinyint(4) NOT NULL,
  `DocumentType` tinyint(4) NOT NULL DEFAULT '5',
  `Referinta` varchar(36) NOT NULL,
  `Observatii` varchar(256) NOT NULL,
  `Closed` tinyint(1) NOT NULL DEFAULT '0',
  `Active` tinyint(1) NOT NULL DEFAULT '1',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `BonuriAvize`
--

CREATE TABLE `BonuriAvize` (
  `Id` int(11) NOT NULL,
  `BonId` int(11) NOT NULL,
  `AvizId` int(11) NOT NULL,
  `Facturate` tinyint(1) NOT NULL DEFAULT '0',
  `Active` tinyint(1) NOT NULL DEFAULT '1',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `BonuriConsum`
--

CREATE TABLE `BonuriConsum` (
  `Id` int(11) NOT NULL,
  `TagId` int(11) DEFAULT NULL,
  `UserId` int(11) NOT NULL DEFAULT '1',
  `SerieBon` varchar(200) NOT NULL,
  `NrBon` int(25) NOT NULL,
  `TotalBon` double(10,2) NOT NULL,
  `TVABon` double(10,2) NOT NULL,
  `TotalVanzareBon` double(10,2) NOT NULL,
  `TVAVanzareBon` double(10,2) NOT NULL,
  `DataBon` datetime NOT NULL,
  `Observatii` varchar(256) NOT NULL,
  `Active` tinyint(1) NOT NULL DEFAULT '1',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `BonuriFacturi`
--

CREATE TABLE `BonuriFacturi` (
  `Id` int(11) NOT NULL,
  `BonId` int(11) NOT NULL,
  `FacturaId` int(11) NOT NULL,
  `Storno` tinyint(1) NOT NULL DEFAULT '0',
  `Active` tinyint(1) NOT NULL DEFAULT '1',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `Calls`
--

CREATE TABLE `Calls` (
  `Id` int(11) NOT NULL,
  `UserId` int(11) NOT NULL DEFAULT '-1',
  `PhoneNumber` varchar(100) DEFAULT NULL,
  `Caller` varchar(100) DEFAULT NULL,
  `Active` tinyint(1) DEFAULT '1',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `CategoryHistory`
--

CREATE TABLE `CategoryHistory` (
  `Id` int(10) UNSIGNED NOT NULL,
  `CategoryId` int(10) UNSIGNED NOT NULL,
  `UpdatedById` int(11) UNSIGNED NOT NULL DEFAULT '1',
  `Type` varchar(100) NOT NULL,
  `Name` text NOT NULL,
  `Description` varchar(256) NOT NULL DEFAULT '',
  `Action` tinyint(4) UNSIGNED NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `CategoryHistory`
--

INSERT INTO `CategoryHistory` (`Id`, `CategoryId`, `UpdatedById`, `Type`, `Name`, `Description`, `Action`, `Timestamp`) VALUES
(1, 1, 1, 'bar', 'BAR', 'INSERTED NEW SUBCATEGORY: WHISKI; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(2, 1, 1, 'bar', 'BAR', 'INSERTED NEW SUBCATEGORY: VODKA; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(3, 1, 1, 'bar', 'BAR', 'INSERTED NEW SUBCATEGORY: DIGESTIVE; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(4, 1, 1, 'bar', 'BAR', 'INSERTED NEW SUBCATEGORY: COCKTAILS; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(5, 1, 1, 'bar', 'BAR', 'INSERTED NEW SUBCATEGORY: CAFEA; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(6, 1, 1, 'bar', 'BAR', 'INSERTED NEW SUBCATEGORY: BERE; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(7, 1, 1, 'bar', 'BAR', 'INSERTED NEW SUBCATEGORY: SUCURI; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(8, 1, 1, 'bar', 'BAR', 'INSERTED NEW SUBCATEGORY: Vin pah/carafa; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(9, 1, 1, 'bar', 'BAR', 'INSERTED NEW SUBCATEGORY: VIN ITALIA rosu; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(10, 1, 1, 'bar', 'BAR', 'INSERTED NEW SUBCATEGORY: VIN ITALIA rose; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(11, 1, 1, 'bar', 'BAR', 'INSERTED NEW SUBCATEGORY: VIN ITALIA alb; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(12, 1, 1, 'bar', 'BAR', 'INSERTED NEW SUBCATEGORY: VIN ROMANIA 2; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(13, 2, 1, 'bucatarie', 'Bucatarie', 'INSERTED NEW SUBCATEGORY: ANTIPASTI; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(14, 2, 1, 'bucatarie', 'Bucatarie', 'INSERTED NEW SUBCATEGORY: SALATE; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(15, 2, 1, 'bucatarie', 'Bucatarie', 'INSERTED NEW SUBCATEGORY: PASTE; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(16, 2, 1, 'bucatarie', 'Bucatarie', 'INSERTED NEW SUBCATEGORY: SECODI DI CARNE; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(17, 2, 1, 'bucatarie', 'Bucatarie', 'INSERTED NEW SUBCATEGORY: SECODI DI PESCE; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(18, 2, 1, 'bucatarie', 'Bucatarie', 'INSERTED NEW SUBCATEGORY: CONTORNI; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(19, 2, 1, 'bucatarie', 'Bucatarie', 'INSERTED NEW SUBCATEGORY: PIZZA; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(20, 2, 1, 'bucatarie', 'Bucatarie', 'INSERTED NEW SUBCATEGORY: DESERT; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(21, 2, 1, 'bucatarie', 'Bucatarie', 'INSERTED NEW SUBCATEGORY: EXTRA ; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(22, 2, 1, 'bucatarie', 'Bucatarie', 'INSERTED NEW SUBCATEGORY: PIZZA HAPPY HOUR; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(23, 2, 1, 'bucatarie', 'Bucatarie', 'INSERTED NEW SUBCATEGORY:  HAPPY HOUR; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(24, 2, 1, 'bucatarie', 'Bucatarie', 'INSERTED NEW SUBCATEGORY: Mic dejun; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(25, 1, 1, 'bar', 'BAR', 'INSERTED NEW SUBCATEGORY:  LIVRARI; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13'),
(26, 2, 1, 'bucatarie', 'Bucatarie', 'INSERTED NEW SUBCATEGORY: test; Type: simplu; Description: ; By: 1', 3, '2023-02-10 10:55:13');

-- --------------------------------------------------------

--
-- Table structure for table `CategoryTypes`
--

CREATE TABLE `CategoryTypes` (
  `Id` int(11) NOT NULL,
  `Type` varchar(256) NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `CategoryTypes`
--

INSERT INTO `CategoryTypes` (`Id`, `Type`, `Timestamp`) VALUES
(1, 'bar', '2021-05-11 07:25:00'),
(2, 'bufet', '2021-05-11 07:25:00'),
(3, 'bacanie', '2021-05-11 07:25:00'),
(4, 'diverse', '2021-05-11 07:25:00'),
(5, 'bucatarie', '2021-05-11 07:25:00'),
(6, 'retetar', '2021-05-11 07:25:00');

-- --------------------------------------------------------

--
-- Table structure for table `Chitante`
--

CREATE TABLE `Chitante` (
  `Id` int(11) NOT NULL,
  `UserId` int(11) NOT NULL DEFAULT '1',
  `Referinta` varchar(36) COLLATE utf8_bin NOT NULL,
  `NrC` int(25) NOT NULL,
  `SerieC` varchar(200) COLLATE utf8_bin NOT NULL,
  `Data` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Detalii` mediumtext COLLATE utf8_bin NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Active` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- --------------------------------------------------------

--
-- Table structure for table `Connections`
--

CREATE TABLE `Connections` (
  `Id` int(11) NOT NULL,
  `Name` varchar(256) NOT NULL,
  `Server` varchar(50) NOT NULL DEFAULT ' 127.0.0.1',
  `Port` int(11) NOT NULL DEFAULT '3306',
  `dbName` varchar(200) NOT NULL DEFAULT '',
  `UId` varchar(200) NOT NULL DEFAULT '',
  `Pass` varchar(256) NOT NULL DEFAULT '',
  `SslMode` varchar(256) NOT NULL DEFAULT 'Prefered',
  `Pooling` tinyint(1) NOT NULL DEFAULT '1',
  `Lifetime` int(11) NOT NULL DEFAULT '600',
  `PoolSize` int(11) NOT NULL DEFAULT '1000',
  `ConnectionTimeout` int(11) NOT NULL DEFAULT '600',
  `ConnectionLifetime` int(11) NOT NULL DEFAULT '600',
  `Keepalive` int(11) NOT NULL DEFAULT '300',
  `DefaultCommandTimeout` int(11) NOT NULL DEFAULT '600',
  `Language` varchar(50) NOT NULL DEFAULT 'en-US',
  `Warehouse` tinyint(1) NOT NULL DEFAULT '0',
  `Reference` varchar(36) NOT NULL,
  `Foregorund` varchar(50) NOT NULL DEFAULT 'Black',
  `Backgorund` varchar(50) NOT NULL DEFAULT 'Window'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `Devize`
--

CREATE TABLE `Devize` (
  `ID` int(11) NOT NULL,
  `SerieDeviz` varchar(50) NOT NULL DEFAULT 'DV',
  `NrDeviz` int(11) NOT NULL DEFAULT '0',
  `UserId` int(11) NOT NULL DEFAULT '1',
  `ClientId` int(11) NOT NULL DEFAULT '0',
  `TotalDeviz` double(10,2) NOT NULL DEFAULT '0.00',
  `TVADeviz` double(10,2) NOT NULL DEFAULT '0.00',
  `DataDeviz` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Marca` varchar(255) NOT NULL DEFAULT '''Marca''',
  `Model` varchar(255) NOT NULL DEFAULT '''Model''',
  `SN` varchar(255) NOT NULL DEFAULT '''SN''',
  `Observatii` text NOT NULL,
  `ProblemaRaportata` text NOT NULL,
  `Garantie` int(11) NOT NULL DEFAULT '0',
  `IdBon` int(11) NOT NULL DEFAULT '0',
  `Incasat` tinyint(4) NOT NULL DEFAULT '0',
  `Status` varchar(50) NOT NULL DEFAULT 'Pending',
  `Activ` tinyint(4) NOT NULL DEFAULT '1',
  `Deleted` tinyint(4) NOT NULL DEFAULT '0',
  `UpdatedBy` int(11) NOT NULL DEFAULT '1',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `Etichete`
--

CREATE TABLE `Etichete` (
  `Id` int(11) NOT NULL,
  `IdProdus` int(11) NOT NULL,
  `NrEtichete` int(11) NOT NULL,
  `Printata` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `FiscalSettings`
--

CREATE TABLE `FiscalSettings` (
  `Id` int(11) NOT NULL,
  `Protocol` tinyint(4) NOT NULL DEFAULT '1',
  `COMvIP` varchar(15) COLLATE utf8_bin NOT NULL DEFAULT '1',
  `BandvPort` int(11) NOT NULL DEFAULT '115200',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `Active` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- --------------------------------------------------------

--
-- Table structure for table `FiseNecesar`
--

CREATE TABLE `FiseNecesar` (
  `Id` int(11) NOT NULL,
  `TagId` int(11) DEFAULT NULL,
  `SerieFisa` varchar(200) NOT NULL,
  `NrFisa` bigint(20) NOT NULL,
  `Total` double(10,2) NOT NULL,
  `TVA` double(10,2) NOT NULL,
  `Data` datetime NOT NULL,
  `Observatii` varchar(256) NOT NULL,
  `TransferRef` varchar(36) NOT NULL,
  `Type` tinyint(4) NOT NULL,
  `CreatDe` varchar(100) NOT NULL DEFAULT '',
  `InchisDe` varchar(100) NOT NULL DEFAULT '',
  `Referinta` varchar(36) NOT NULL,
  `Resolved` tinyint(1) NOT NULL DEFAULT '0',
  `Closed` tinyint(1) NOT NULL DEFAULT '0',
  `Editing` tinyint(1) NOT NULL DEFAULT '0',
  `Active` tinyint(1) NOT NULL DEFAULT '1',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `FiseProductie`
--

CREATE TABLE `FiseProductie` (
  `Id` int(11) NOT NULL,
  `TagId` int(11) DEFAULT NULL,
  `UserId` int(11) NOT NULL,
  `Data` datetime NOT NULL,
  `SerieFisa` varchar(200) NOT NULL,
  `NrFisa` bigint(20) NOT NULL,
  `Total` double(10,2) NOT NULL,
  `TVA` double(10,2) NOT NULL,
  `Observatii` varchar(256) NOT NULL,
  `Instant` tinyint(1) NOT NULL DEFAULT '0',
  `Closed` tinyint(1) NOT NULL DEFAULT '1',
  `Active` tinyint(1) NOT NULL DEFAULT '1',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `FiseRetur`
--

CREATE TABLE `FiseRetur` (
  `Id` int(11) NOT NULL,
  `TagId` int(11) DEFAULT NULL,
  `UserId` int(11) NOT NULL DEFAULT '1',
  `FurnizorId` int(11) NOT NULL,
  `SerieFisa` varchar(200) NOT NULL,
  `NrFisa` int(25) NOT NULL,
  `TotalFisa` double(10,2) NOT NULL,
  `TVAFisa` double(10,2) NOT NULL,
  `TotalVanzareFisa` double(10,2) NOT NULL,
  `TVAVanzareFisa` double(10,2) NOT NULL,
  `DataFisa` datetime NOT NULL,
  `Observatii` varchar(256) NOT NULL,
  `SerieFactura` text NOT NULL,
  `NumarFactura` int(25) NOT NULL,
  `TVAFactura` double(10,2) NOT NULL DEFAULT '0.00',
  `TotalFactura` double(10,2) NOT NULL DEFAULT '0.00',
  `DataFactura` datetime NOT NULL,
  `Active` tinyint(1) NOT NULL DEFAULT '1',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `Furnizori`
--

CREATE TABLE `Furnizori` (
  `ID` int(11) NOT NULL,
  `Nume` longtext NOT NULL,
  `CUI` longtext NOT NULL,
  `Adresa` longtext NOT NULL,
  `Localitate` varchar(254) NOT NULL,
  `Judet` varchar(254) NOT NULL,
  `Tara` varchar(254) NOT NULL,
  `RegCom` varchar(254) NOT NULL,
  `CodClient` varchar(254) NOT NULL,
  `Iban` varchar(254) NOT NULL,
  `Banca` varchar(254) NOT NULL,
  `Mail` varchar(254) NOT NULL,
  `PeresoanaContact` varchar(254) NOT NULL,
  `Telefon` varchar(254) NOT NULL,
  `Discount` double NOT NULL DEFAULT '0',
  `Tip` varchar(25) NOT NULL DEFAULT 'Client'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `GestiuneClientiFacturi`
--

CREATE TABLE `GestiuneClientiFacturi` (
  `Id` int(11) NOT NULL,
  `ClientId` int(11) NOT NULL,
  `Nume` varchar(250) NOT NULL,
  `Adresa` varchar(250) NOT NULL,
  `Localitate` varchar(250) NOT NULL,
  `Judet` varchar(250) NOT NULL,
  `Tara` varchar(250) NOT NULL,
  `PersContact` varchar(250) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ImportNirTemp`
--

CREATE TABLE `ImportNirTemp` (
  `IdProd` int(11) NOT NULL,
  `CodBare` varchar(250) NOT NULL,
  `StocCurent` double(10,3) NOT NULL,
  `CantRec` double(10,3) NOT NULL,
  `PretA` double(10,2) NOT NULL,
  `PretAcuTVA` double(10,2) NOT NULL,
  `PretV` double(10,2) NOT NULL,
  `PretVfaraTVA` double(10,2) NOT NULL,
  `AdaosVU` double(10,2) NOT NULL,
  `AdaosPU` double(10,2) NOT NULL,
  `ValAch` double(10,2) NOT NULL,
  `ValVanzare` double(10,2) NOT NULL,
  `ValVanzareFaraTVA` double(10,2) NOT NULL,
  `ProcTvaA` int(11) NOT NULL,
  `IdTva` int(11) NOT NULL,
  `ProcTvaV` int(11) NOT NULL,
  `IdTvaf` int(11) NOT NULL,
  `TVaAU` double(10,2) NOT NULL,
  `TvaA` double(10,2) NOT NULL,
  `TvaVU` double(10,2) NOT NULL,
  `TvaV` double(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `IngredienteFisaNecesar`
--

CREATE TABLE `IngredienteFisaNecesar` (
  `Id` int(11) UNSIGNED NOT NULL,
  `ProdusId` int(11) NOT NULL,
  `NecesarId` int(11) NOT NULL,
  `RequestedQuantity` double(10,3) NOT NULL,
  `RecievedQuantity` double(10,3) NOT NULL DEFAULT '0.000',
  `Stoc` double(10,3) NOT NULL,
  `Pret` double(10,2) NOT NULL,
  `TVAId` int(11) NOT NULL,
  `TVAUnitar` double(10,2) NOT NULL,
  `ValoareLei` double(10,2) NOT NULL,
  `ValoareTVA` double(10,2) NOT NULL,
  `ValoareCuTVA` double(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `IngredienteFisaProductie`
--

CREATE TABLE `IngredienteFisaProductie` (
  `Id` int(11) UNSIGNED NOT NULL,
  `ProductieId` int(11) NOT NULL,
  `ProdusFisaId` int(11) NOT NULL,
  `ProdusId` int(11) NOT NULL,
  `IngredientId` int(11) NOT NULL,
  `TVAId` int(11) NOT NULL,
  `Cantitate` double(10,3) NOT NULL,
  `BaseQ` double(10,3) NOT NULL,
  `Stoc` double(10,3) NOT NULL,
  `Pret` double(10,2) NOT NULL,
  `PretAchizitie` double(10,2) NOT NULL,
  `TVAUnitar` double(10,2) NOT NULL,
  `ValoareLei` double(10,2) NOT NULL,
  `ValoareTVA` double(10,2) NOT NULL,
  `ValoareCuTVA` double(10,2) NOT NULL,
  `MateriePrima` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `Ingredients`
--

CREATE TABLE `Ingredients` (
  `Id` int(11) UNSIGNED NOT NULL,
  `RecipeId` int(11) NOT NULL DEFAULT '-1',
  `IngredientId` int(11) NOT NULL DEFAULT '-1',
  `Quantity` double(10,3) NOT NULL DEFAULT '0.000',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `IntinzatorDeGarnitura`
--

CREATE TABLE `IntinzatorDeGarnitura` (
  `Id` int(10) UNSIGNED NOT NULL,
  `UserId` int(10) UNSIGNED NOT NULL,
  `Action` int(10) UNSIGNED NOT NULL,
  `Hour` time NOT NULL,
  `Phone` varchar(10) NOT NULL,
  `Address` varchar(350) NOT NULL,
  `FullName` varchar(100) NOT NULL,
  `Consent` text NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `InventarHistory`
--

CREATE TABLE `InventarHistory` (
  `Id` int(11) NOT NULL,
  `InventarId` int(11) NOT NULL,
  `ProdusId` int(11) NOT NULL,
  `PretAchizitie` double(10,2) NOT NULL DEFAULT '0.00',
  `Pret` double(10,2) NOT NULL DEFAULT '0.00',
  `StocInventar` double(10,3) NOT NULL DEFAULT '0.000',
  `StocProdus` double(10,3) NOT NULL DEFAULT '0.000',
  `Diferenta` double(10,3) NOT NULL DEFAULT '0.000',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `LOG`
--

CREATE TABLE `LOG` (
  `ID` int(11) NOT NULL,
  `IDPRODUS` int(11) NOT NULL,
  `INITIAL` varchar(254) NOT NULL,
  `DETALII` varchar(254) NOT NULL,
  `DETALII2` varchar(254) NOT NULL,
  `PRET` decimal(10,2) NOT NULL,
  `PRETNOU` decimal(10,2) NOT NULL,
  `PROCENT` decimal(10,2) NOT NULL,
  `DATA` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `LogDangerousActions`
--

CREATE TABLE `LogDangerousActions` (
  `Id` int(11) NOT NULL,
  `ActionTitle` mediumtext NOT NULL,
  `UserId` int(11) NOT NULL,
  `InputName` mediumtext NOT NULL,
  `ExtraDetails` mediumtext NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `LogDoc`
--

CREATE TABLE `LogDoc` (
  `Id` bigint(20) NOT NULL,
  `DocId` int(11) NOT NULL,
  `UserId` int(11) NOT NULL,
  `ClientId` int(11) DEFAULT NULL,
  `DocType` int(11) NOT NULL,
  `SerieDoc` varchar(200) NOT NULL DEFAULT '',
  `NrDoc` int(25) NOT NULL,
  `DataDoc` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Discount` double(10,2) NOT NULL,
  `ValoareLei` double(10,2) NOT NULL,
  `ValoareTVA` double(10,2) NOT NULL,
  `ValoareLeiVanzare` double(10,2) NOT NULL,
  `ValoareTVAVanzare` double(10,2) NOT NULL,
  `Storno` tinyint(1) DEFAULT NULL,
  `Active` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `LogVanzare`
--

CREATE TABLE `LogVanzare` (
  `ID` int(11) NOT NULL,
  `Data` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `User` varchar(200) NOT NULL,
  `TipActiune` varchar(200) NOT NULL,
  `IdBon` int(11) NOT NULL,
  `IdTura` int(11) NOT NULL,
  `Masa` int(11) NOT NULL,
  `Observatii` text NOT NULL,
  `IdProdus` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `MarimiProduseAviz`
--

CREATE TABLE `MarimiProduseAviz` (
  `Id` int(11) UNSIGNED NOT NULL,
  `SizeId` int(11) NOT NULL DEFAULT '0',
  `AvizId` int(11) NOT NULL DEFAULT '0',
  `ProdusId` int(11) NOT NULL DEFAULT '0',
  `Nume` varchar(256) NOT NULL,
  `Stoc` double(10,3) NOT NULL DEFAULT '0.000',
  `Cantitate` double(10,3) NOT NULL DEFAULT '0.000'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `MarimiProduseBonConsum`
--

CREATE TABLE `MarimiProduseBonConsum` (
  `Id` int(11) NOT NULL,
  `SizeId` int(11) NOT NULL DEFAULT '0',
  `BonConsumId` int(11) NOT NULL DEFAULT '0',
  `ProdusId` int(11) NOT NULL DEFAULT '0',
  `Nume` varchar(256) NOT NULL,
  `Stoc` double(10,3) NOT NULL DEFAULT '0.000',
  `Cantitate` double(10,3) NOT NULL DEFAULT '0.000'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `MarimiProduseFisaRetur`
--

CREATE TABLE `MarimiProduseFisaRetur` (
  `Id` int(11) NOT NULL,
  `SizeId` int(11) NOT NULL DEFAULT '0',
  `FisaReturId` int(11) NOT NULL DEFAULT '0',
  `ProdusId` int(11) NOT NULL DEFAULT '0',
  `Nume` varchar(256) NOT NULL,
  `Stoc` double(10,3) NOT NULL DEFAULT '0.000',
  `Cantitate` double(10,3) NOT NULL DEFAULT '0.000'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `MarimiProduseNIR`
--

CREATE TABLE `MarimiProduseNIR` (
  `Id` int(11) NOT NULL,
  `SizeId` int(11) NOT NULL DEFAULT '0',
  `NIRId` int(11) NOT NULL DEFAULT '0',
  `ProdusId` int(11) NOT NULL DEFAULT '0',
  `Nume` varchar(256) NOT NULL,
  `Stoc` double(10,3) NOT NULL DEFAULT '0.000',
  `Cantitate` double(10,3) NOT NULL DEFAULT '0.000',
  `Active` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `MarimiProduseNIRAux`
--

CREATE TABLE `MarimiProduseNIRAux` (
  `Id` int(11) NOT NULL,
  `SizeId` int(11) NOT NULL DEFAULT '0',
  `NIRId` int(11) NOT NULL DEFAULT '0',
  `ProdusId` int(11) NOT NULL DEFAULT '0',
  `Nume` varchar(256) NOT NULL,
  `Stoc` double(10,3) NOT NULL DEFAULT '0.000',
  `Cantitate` double(10,3) NOT NULL DEFAULT '0.000',
  `Active` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `MetroReports`
--

CREATE TABLE `MetroReports` (
  `Id` int(11) NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `Date` date DEFAULT NULL,
  `ReportType` varchar(255) NOT NULL DEFAULT 'qqq',
  `IdTura` int(11) NOT NULL DEFAULT '0',
  `Result` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `NIRuri`
--

CREATE TABLE `NIRuri` (
  `Id` int(11) NOT NULL,
  `TagId` int(11) DEFAULT NULL,
  `UserId` int(11) NOT NULL DEFAULT '1',
  `FurnizorId` int(11) NOT NULL,
  `Referinta` varchar(36) DEFAULT NULL,
  `DataFactura` datetime NOT NULL,
  `DataNIR` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `DataScadenta` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `SerieFactura` varchar(200) NOT NULL,
  `NrFactura` varchar(50) NOT NULL,
  `TotalFactura` double(10,2) NOT NULL,
  `Discount` double(10,2) NOT NULL,
  `DiscountType` tinyint(1) NOT NULL DEFAULT '0',
  `NrNIR` int(11) NOT NULL,
  `TVAFactura` double(10,2) NOT NULL,
  `TotalNIR` double(10,2) NOT NULL,
  `TVANIR` double(10,2) NOT NULL,
  `AvizId` int(11) NOT NULL DEFAULT '-1',
  `TransferGestiune` tinyint(1) NOT NULL DEFAULT '0',
  `Observatii` varchar(256) NOT NULL,
  `Negative` tinyint(1) NOT NULL DEFAULT '0',
  `Editing` tinyint(1) NOT NULL DEFAULT '0',
  `Active` tinyint(1) NOT NULL DEFAULT '0',
  `Achitata` tinyint(1) NOT NULL DEFAULT '1',
  `CurrencyValue` double DEFAULT NULL,
  `Currency` varchar(4) NOT NULL DEFAULT 'LEU'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `NIRUsers`
--

CREATE TABLE `NIRUsers` (
  `Id` int(11) NOT NULL,
  `ProductId` int(11) NOT NULL DEFAULT '-1',
  `UserId` int(11) NOT NULL DEFAULT '0',
  `Quantity` double(10,3) NOT NULL DEFAULT '0.000',
  `Value` double(10,2) NOT NULL DEFAULT '0.00',
  `PendingId` int(11) NOT NULL DEFAULT '-1',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Deleted` tinyint(1) NOT NULL DEFAULT '0',
  `Active` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `OptiuniMeniu`
--

CREATE TABLE `OptiuniMeniu` (
  `Id` int(11) NOT NULL,
  `NrOptiune` int(11) NOT NULL DEFAULT '0',
  `IdProdus` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `Packages`
--

CREATE TABLE `Packages` (
  `Id` int(11) NOT NULL,
  `Denumire` varchar(75) NOT NULL,
  `Quantity` double NOT NULL DEFAULT '0',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `Active` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `PaymentTypes`
--

CREATE TABLE `PaymentTypes` (
  `Id` int(10) UNSIGNED NOT NULL,
  `Type` varchar(256) NOT NULL,
  `Number` int(11) NOT NULL DEFAULT '0',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `PaymentTypes`
--

INSERT INTO `PaymentTypes` (`Id`, `Type`, `Number`, `Timestamp`) VALUES
(1, 'Numerar', 0, '2021-06-07 10:17:20'),
(2, 'Card', 0, '2021-06-07 10:17:20'),
(3, 'Bonuri', 0, '2021-06-07 10:17:20'),
(4, 'Vaucher', 0, '2021-06-07 10:17:20'),
(5, 'Plata Moderna', 0, '2021-06-07 10:17:20'),
(6, 'Factura', 0, '2021-06-07 10:17:20'),
(7, 'Cod Client', 0, '2021-06-07 10:17:20'),
(8, 'Aviz', 0, '2021-06-07 10:17:20');

-- --------------------------------------------------------

--
-- Table structure for table `PendingProducts`
--

CREATE TABLE `PendingProducts` (
  `Id` int(11) NOT NULL,
  `UserId` int(11) NOT NULL,
  `Denumire` mediumtext NOT NULL,
  `CodBare` mediumtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `PlatiFacturi`
--

CREATE TABLE `PlatiFacturi` (
  `Id` int(11) NOT NULL,
  `DocumentId` int(11) NOT NULL DEFAULT '0',
  `RegistruId` int(11) NOT NULL DEFAULT '-1',
  `ChitantaId` int(11) NOT NULL DEFAULT '-1',
  `Referinta` varchar(36) DEFAULT NULL,
  `TipPlata` int(11) NOT NULL DEFAULT '0',
  `SerieNr` mediumtext NOT NULL,
  `Valoare` double(10,2) NOT NULL DEFAULT '0.00',
  `Detalii` mediumtext NOT NULL,
  `Data` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `PlatiNIRuri`
--

CREATE TABLE `PlatiNIRuri` (
  `Id` int(11) NOT NULL,
  `DocumentId` int(11) NOT NULL DEFAULT '0',
  `RegistruId` int(11) NOT NULL DEFAULT '-1',
  `Referinta` varchar(36) DEFAULT NULL,
  `TipPlata` int(11) NOT NULL DEFAULT '0',
  `SerieNr` mediumtext NOT NULL,
  `Valoare` double(10,2) NOT NULL DEFAULT '0.00',
  `Detalii` mediumtext NOT NULL,
  `Data` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Triggers `PlatiNIRuri`
--
DELIMITER $$
CREATE TRIGGER `LogPlatiNIRuriDelete` BEFORE DELETE ON `PlatiNIRuri` FOR EACH ROW BEGIN
	INSERT INTO PlatiNIRuriHistory (DocumentId, RegistruId, TipPlata, SerieNr, Valoare, Detalii, Data, Action) VALUES 
                (OLD.DocumentId, OLD.RegistruId, OLD.TipPlata, OLD.SerieNr, OLD.Valoare, OLD.Detalii, OLD.Data, 2);
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `PlatiNIRuriHistory`
--

CREATE TABLE `PlatiNIRuriHistory` (
  `Id` int(11) NOT NULL,
  `DocumentId` int(11) NOT NULL DEFAULT '0',
  `RegistruId` int(11) NOT NULL DEFAULT '-1',
  `TipPlata` int(11) NOT NULL DEFAULT '0',
  `SerieNr` mediumtext NOT NULL,
  `Valoare` double(10,2) NOT NULL DEFAULT '0.00',
  `Detalii` mediumtext NOT NULL,
  `Data` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Action` tinyint(4) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `Printers`
--

CREATE TABLE `Printers` (
  `Id` int(11) NOT NULL,
  `CategoryTypeId` int(11) NOT NULL,
  `Name` varchar(50) NOT NULL,
  `PrinterName` varchar(150) NOT NULL,
  `Title` varchar(200) NOT NULL,
  `Footer` varchar(100) NOT NULL,
  `Count` int(11) NOT NULL,
  `Width` int(11) NOT NULL,
  `Height` int(11) NOT NULL,
  `ExcludePrice` tinyint(1) NOT NULL DEFAULT '0',
  `TableAtEnd` tinyint(1) NOT NULL DEFAULT '0',
  `InlineQ` tinyint(1) NOT NULL DEFAULT '0',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ProductHistory`
--

CREATE TABLE `ProductHistory` (
  `Id` bigint(20) UNSIGNED NOT NULL,
  `ProdusId` int(11) NOT NULL,
  `WebProductId` int(11) NOT NULL DEFAULT '-1',
  `IDSubCategorie` int(11) NOT NULL,
  `TVA` int(11) NOT NULL DEFAULT '1',
  `TVAL` int(11) NOT NULL DEFAULT '1',
  `TVAF` int(1) NOT NULL DEFAULT '1',
  `Denumire` text NOT NULL,
  `Descriere` text NOT NULL,
  `CodBare` varchar(255) NOT NULL DEFAULT '',
  `CodPlu` varchar(255) NOT NULL DEFAULT '''0''',
  `Pret` double(10,2) NOT NULL,
  `AdaosNIR` double(10,2) NOT NULL DEFAULT '0.00',
  `PretAchizitie` double(10,2) NOT NULL DEFAULT '0.00',
  `Stoc` double(10,3) NOT NULL DEFAULT '0.000',
  `UM` varchar(254) NOT NULL DEFAULT '''bucata''',
  `MateriePrima` tinyint(1) NOT NULL DEFAULT '0',
  `OnlineSync` tinyint(4) NOT NULL DEFAULT '-1',
  `Complex` tinyint(1) NOT NULL DEFAULT '0',
  `Sizeable` tinyint(1) NOT NULL DEFAULT '0',
  `Action` tinyint(4) NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ProductRecipes`
--

CREATE TABLE `ProductRecipes` (
  `Id` int(11) NOT NULL,
  `ProductId` int(11) NOT NULL DEFAULT '-1',
  `RecipeId` int(11) NOT NULL DEFAULT '-1',
  `Quantity` double(10,3) NOT NULL DEFAULT '1.000',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Triggers `ProductRecipes`
--
DELIMITER $$
CREATE TRIGGER `ProductRecipesDelete` AFTER DELETE ON `ProductRecipes` FOR EACH ROW BEGIN
    CALL UpsertProductRecipesTrr(OLD.ProductId);

    UPDATE TProduse p
    INNER JOIN tr_ingredients i ON p.ID = i.ProductId
    SET p.PretAchizitie = i.Cost;

    DROP TEMPORARY TABLE IF EXISTS tr_ingredients;
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `ProductRecipesInsert` AFTER INSERT ON `ProductRecipes` FOR EACH ROW BEGIN
    CALL UpsertProductRecipesTrr(NEW.ProductId);

    UPDATE TProduse p
    INNER JOIN tr_ingredients i ON p.ID = i.ProductId
    SET p.PretAchizitie = i.Cost;

    DROP TEMPORARY TABLE IF EXISTS tr_ingredients;
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `ProductRecipesUpdate` AFTER UPDATE ON `ProductRecipes` FOR EACH ROW BEGIN
    CALL UpsertProductRecipesTrr(NEW.ProductId);

    UPDATE TProduse p
    INNER JOIN tr_ingredients i ON p.ID = i.ProductId
    SET p.PretAchizitie = i.Cost;

    DROP TEMPORARY TABLE IF EXISTS tr_ingredients;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `Products`
--

CREATE TABLE `Products` (
  `ID` int(11) NOT NULL,
  `NrCatalog` int(11) NOT NULL DEFAULT '0',
  `Data` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0 Activ/1 Sters',
  `CodBare` varchar(50) NOT NULL DEFAULT '0',
  `CodPLU` varchar(50) NOT NULL DEFAULT '0',
  `CodAditionalFurnizor` varchar(50) NOT NULL DEFAULT '0',
  `CodCategorie` int(11) NOT NULL DEFAULT '0',
  `NumeCategorie` varchar(250) NOT NULL DEFAULT 'CategoryName',
  `Denumire` varchar(250) NOT NULL DEFAULT 'ProductName',
  `UM` varchar(50) NOT NULL DEFAULT 'bucata',
  `ProcentTVA` int(2) NOT NULL DEFAULT '0',
  `OtherBarcode` varchar(50) NOT NULL DEFAULT '0',
  `Updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `IdTVA` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `Products1`
--

CREATE TABLE `Products1` (
  `ID` int(11) NOT NULL,
  `NrCatalog` int(11) NOT NULL DEFAULT '0',
  `Data` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0 Activ/1 Sters',
  `CodBare` varchar(50) NOT NULL DEFAULT '0',
  `CodPLU` varchar(50) NOT NULL DEFAULT '0',
  `CodAditionalFurnizor` varchar(50) NOT NULL DEFAULT '0',
  `CodCategorie` int(11) NOT NULL DEFAULT '0',
  `NumeCategorie` varchar(250) NOT NULL DEFAULT 'CategoryName',
  `Denumire` varchar(250) NOT NULL DEFAULT 'ProductName',
  `UM` varchar(50) NOT NULL DEFAULT 'bucata',
  `ProcentTVA` int(2) NOT NULL DEFAULT '0',
  `OtherBarcode` varchar(50) NOT NULL DEFAULT '0',
  `Updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `IdTVA` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ProduseAviz`
--

CREATE TABLE `ProduseAviz` (
  `Id` int(11) NOT NULL,
  `ProdusId` int(11) NOT NULL,
  `AvizId` int(11) NOT NULL,
  `TVAId` int(11) NOT NULL,
  `Stoc` double(10,3) NOT NULL,
  `Cantitate` double(10,3) NOT NULL,
  `Pret` double(10,2) NOT NULL,
  `Adaos` double(10,2) NOT NULL,
  `TVAUnitar` double(10,2) NOT NULL,
  `ValoareLei` double(10,2) NOT NULL,
  `ValoareTVA` double(10,2) NOT NULL,
  `Type` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ProduseBonConsum`
--

CREATE TABLE `ProduseBonConsum` (
  `Id` int(11) NOT NULL,
  `ProdusId` int(11) NOT NULL,
  `BonId` int(11) NOT NULL,
  `TVAId` int(11) NOT NULL,
  `Stoc` double(10,3) NOT NULL,
  `Cantitate` double(10,3) NOT NULL,
  `Pret` double(10,2) NOT NULL,
  `PretVanzare` double(10,2) NOT NULL,
  `Adaos` double(10,2) NOT NULL,
  `TVAUnitar` double(10,2) NOT NULL,
  `ValoareLei` double(10,2) NOT NULL,
  `ValoareTVA` double(10,2) NOT NULL,
  `ValoareLeiVanzare` double(10,2) NOT NULL,
  `ValoareTVAVanzare` double(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ProduseBonTransfer`
--

CREATE TABLE `ProduseBonTransfer` (
  `Id` int(11) NOT NULL,
  `ProdusId` int(11) NOT NULL,
  `TransferId` int(11) NOT NULL,
  `Cantitate` double(10,3) NOT NULL,
  `Stoc` double(10,3) NOT NULL,
  `Pret` double(10,2) NOT NULL,
  `TVAId` int(11) NOT NULL,
  `TVAUnitar` double(10,2) NOT NULL,
  `ValoareLei` double(10,2) NOT NULL,
  `ValoareTVA` double(10,2) NOT NULL,
  `ValoareCuTVA` double(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ProduseDeviz`
--

CREATE TABLE `ProduseDeviz` (
  `ID` int(11) NOT NULL,
  `DevizId` int(11) NOT NULL DEFAULT '0',
  `ProdusId` int(11) NOT NULL DEFAULT '0',
  `Cantitate` double(10,2) NOT NULL DEFAULT '0.00',
  `Pret` double(10,3) NOT NULL DEFAULT '0.000',
  `ValoareLei` double(10,2) NOT NULL DEFAULT '0.00',
  `UpdatedBy` int(11) NOT NULL DEFAULT '1',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ProduseFacturaAnulata`
--

CREATE TABLE `ProduseFacturaAnulata` (
  `ID` int(11) NOT NULL,
  `FacturaId` int(11) NOT NULL,
  `TVA` int(11) NOT NULL,
  `Cantitate` double NOT NULL,
  `PterUnitar` double NOT NULL,
  `TotalProduse` double NOT NULL,
  `TotalTvaProdus` double NOT NULL,
  `TPretUnitarFaraTVA` double NOT NULL,
  `TTotalProduseFaraTva` double NOT NULL,
  `IdP` int(11) NOT NULL,
  `TVA1` double NOT NULL,
  `TVA2` double NOT NULL,
  `TVA3` double NOT NULL,
  `TVA4` double NOT NULL,
  `TVA5` double NOT NULL,
  `TVA6` double NOT NULL,
  `TVA7` double NOT NULL,
  `Type` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ProduseFisaNecesar`
--

CREATE TABLE `ProduseFisaNecesar` (
  `Id` int(11) NOT NULL,
  `ProdusId` int(11) NOT NULL,
  `NecesarId` int(11) NOT NULL,
  `TVAId` int(11) NOT NULL,
  `Cantitate` double(10,3) NOT NULL,
  `Stoc` double(10,3) NOT NULL,
  `Pret` double(10,2) NOT NULL,
  `TVAUnitar` double(10,2) NOT NULL,
  `ValoareLei` double(10,2) NOT NULL,
  `ValoareTVA` double(10,2) NOT NULL,
  `ValoareCuTVA` double(10,2) NOT NULL,
  `Complex` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ProduseFisaProductie`
--

CREATE TABLE `ProduseFisaProductie` (
  `Id` int(11) NOT NULL,
  `ProductieId` int(11) NOT NULL,
  `ProdusId` int(11) NOT NULL,
  `TVAId` int(11) NOT NULL,
  `Cantitate` double(10,3) NOT NULL,
  `Stoc` double(10,3) NOT NULL,
  `Pret` double(10,2) NOT NULL,
  `TVAUnitar` double(10,2) NOT NULL,
  `ValoareLei` double(10,2) NOT NULL,
  `ValoareTVA` double(10,2) NOT NULL,
  `ValoareCuTVA` double(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ProduseFisaRetur`
--

CREATE TABLE `ProduseFisaRetur` (
  `Id` int(11) NOT NULL,
  `ProdusId` int(11) NOT NULL,
  `FisaId` int(11) NOT NULL,
  `TVAId` int(11) NOT NULL,
  `Stoc` double(10,3) NOT NULL,
  `Cantitate` double(10,3) NOT NULL,
  `Pret` double(10,2) NOT NULL,
  `PretVanzare` double(10,2) NOT NULL,
  `Adaos` double(10,2) NOT NULL,
  `TVAUnitar` double(10,2) NOT NULL,
  `ValoareLei` double(10,2) NOT NULL,
  `ValoareTVA` double(10,2) NOT NULL,
  `ValoareLeiVanzare` double(10,2) NOT NULL,
  `ValoareTVAVanzare` double(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ProduseNIR`
--

CREATE TABLE `ProduseNIR` (
  `Id` int(11) NOT NULL,
  `NIRId` int(11) NOT NULL DEFAULT '0',
  `ProdusId` int(11) NOT NULL DEFAULT '0',
  `TVAId` int(11) NOT NULL DEFAULT '0',
  `TVAFId` int(11) NOT NULL DEFAULT '0',
  `Stoc` double(10,3) NOT NULL DEFAULT '0.000',
  `Cantitate` double(10,3) NOT NULL DEFAULT '0.000',
  `SelledQuantity` double(10,3) NOT NULL DEFAULT '0.000',
  `Adaos` double(10,2) NOT NULL DEFAULT '0.00',
  `Discount` double(10,2) NOT NULL DEFAULT '0.00',
  `PretAchizitie` double(10,2) NOT NULL DEFAULT '0.00',
  `ValoareLei` double(10,2) NOT NULL DEFAULT '0.00',
  `ValoareLeiFaraDiscount` double(10,2) NOT NULL DEFAULT '0.00',
  `ValoareTVA` double(10,2) NOT NULL DEFAULT '0.00',
  `PretVanzare` double(10,2) NOT NULL DEFAULT '0.00',
  `TVAUnitar` double(10,2) NOT NULL DEFAULT '0.00',
  `ValoareLeiVanzare` double(10,2) NOT NULL DEFAULT '0.00',
  `ValoareTVAVanzare` double(10,2) NOT NULL DEFAULT '0.00',
  `Expirare` datetime NOT NULL,
  `NrLot` varchar(100) NOT NULL DEFAULT '',
  `AdaosType` tinyint(1) NOT NULL DEFAULT '0',
  `DiscountType` tinyint(1) NOT NULL DEFAULT '0',
  `Labels` tinyint(1) NOT NULL DEFAULT '0',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `Editing` tinyint(1) NOT NULL DEFAULT '0',
  `Active` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ProduseNIRAux`
--

CREATE TABLE `ProduseNIRAux` (
  `Id` int(11) NOT NULL,
  `NIRId` int(11) NOT NULL DEFAULT '0',
  `ProdusId` int(11) NOT NULL DEFAULT '0',
  `TVAId` int(11) NOT NULL DEFAULT '0',
  `TVAFId` int(11) NOT NULL DEFAULT '0',
  `Stoc` double(10,3) NOT NULL DEFAULT '0.000',
  `Cantitate` double(10,3) NOT NULL DEFAULT '0.000',
  `SelledQuantity` double(10,3) NOT NULL DEFAULT '0.000',
  `Adaos` double(10,2) NOT NULL DEFAULT '0.00',
  `Discount` double(10,2) NOT NULL DEFAULT '0.00',
  `PretAchizitie` double(10,2) NOT NULL DEFAULT '0.00',
  `ValoareLei` double(10,2) NOT NULL DEFAULT '0.00',
  `ValoareLeiFaraDiscount` double(10,2) NOT NULL DEFAULT '0.00',
  `ValoareTVA` double(10,2) NOT NULL DEFAULT '0.00',
  `PretVanzare` double(10,2) NOT NULL DEFAULT '0.00',
  `TVAUnitar` double(10,2) NOT NULL DEFAULT '0.00',
  `ValoareLeiVanzare` double(10,2) NOT NULL DEFAULT '0.00',
  `ValoareTVAVanzare` double(10,2) NOT NULL DEFAULT '0.00',
  `Expirare` datetime NOT NULL,
  `NrLot` varchar(100) NOT NULL DEFAULT '',
  `AdaosType` tinyint(1) NOT NULL DEFAULT '0',
  `DiscountType` tinyint(1) NOT NULL DEFAULT '0',
  `Labels` tinyint(1) NOT NULL DEFAULT '0',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `Updated` tinyint(1) NOT NULL DEFAULT '0',
  `Editing` tinyint(1) NOT NULL DEFAULT '0',
  `Active` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `RecieptTransactions`
--

CREATE TABLE `RecieptTransactions` (
  `Id` int(11) NOT NULL,
  `BonId` int(11) NOT NULL DEFAULT '0',
  `UserId` int(11) NOT NULL DEFAULT '0',
  `ProductId` int(11) NOT NULL DEFAULT '0',
  `TableId` int(11) NOT NULL DEFAULT '0',
  `Quantity` double(10,3) NOT NULL DEFAULT '0.000',
  `Imprimat` int(11) NOT NULL DEFAULT '0',
  `InLucru` tinyint(1) DEFAULT '1',
  `Discount` double(10,2) NOT NULL DEFAULT '0.00',
  `DiscountBon` double(10,2) NOT NULL DEFAULT '0.00',
  `Comentarii` text,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `Recipes`
--

CREATE TABLE `Recipes` (
  `Id` int(11) NOT NULL,
  `Name` varchar(100) NOT NULL,
  `Referinta` varchar(36) DEFAULT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `Deleted` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Triggers `Recipes`
--
DELIMITER $$
CREATE TRIGGER `RecipeUpdate` AFTER UPDATE ON `Recipes` FOR EACH ROW BEGIN
    CALL UpsertRecipeTrr(NEW.Id);

    UPDATE TProduse p
    INNER JOIN tr_ingredients i ON p.ID = i.ProductId
    SET p.PretAchizitie = i.Cost;

    DROP TEMPORARY TABLE IF EXISTS tr_ingredients;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `SmartInvoicePayments`
--

CREATE TABLE `SmartInvoicePayments` (
  `Id` int(11) NOT NULL,
  `SerieNr` mediumtext NOT NULL,
  `Referinta` varchar(36) DEFAULT NULL,
  `Valoare` double(10,2) NOT NULL DEFAULT '0.00',
  `Data` datetime NOT NULL,
  `TipPlata` int(11) NOT NULL,
  `Detalii` mediumtext NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `SmartPayments`
--

CREATE TABLE `SmartPayments` (
  `Id` int(11) NOT NULL,
  `SerieNr` mediumtext NOT NULL,
  `Referinta` varchar(36) DEFAULT NULL,
  `Valoare` double(10,2) NOT NULL DEFAULT '0.00',
  `Data` datetime NOT NULL,
  `TipPlata` int(11) NOT NULL,
  `Detalii` mediumtext NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `SQLHistory`
--

CREATE TABLE `SQLHistory` (
  `Id` int(11) NOT NULL,
  `FileName` text NOT NULL,
  `Version` int(11) NOT NULL,
  `DateTime` datetime NOT NULL,
  `Author` text NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `SQLHistory`
--

INSERT INTO `SQLHistory` (`Id`, `FileName`, `Version`, `DateTime`, `Author`, `Timestamp`) VALUES
(1, '00.CreateVersioningTable.sql', 1, '2021-03-16 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(2, '01.ExistTableByName.sql', 1, '2020-09-14 13:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(3, '02.StoredFunctions.sql', 5, '2021-05-11 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(4, '03.GetProductLast3AvgInPrice.sql', 2, '2021-04-16 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(5, '04.RaportProfitBrut.sql', 11, '2021-04-16 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(6, '05.ProfitPerProdus.sql', 8, '2021-04-16 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(7, '06.ShifStockUpdate.sql', 8, '2021-04-16 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(8, '07.UpsertNIRSwitcher.sql', 6, '2021-04-16 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(9, '08.UpdateProductStock.sql', 10, '2021-04-16 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(10, '09.UpsertNIRs.sql', 8, '2021-04-16 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(11, '10.DeleteDoc.sql', 4, '2021-04-16 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(12, '11.PeriodStockReport.sql', 4, '2021-04-16 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(13, '12.ScheduledProcedures.sql', 2, '2021-06-09 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(14, '13.Jobs.sql', 2, '2021-06-09 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(15, '13.Triggers.sql', 3, '2021-05-25 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(16, '14.DocProductsReport.sql', 5, '2021-04-13 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(17, '15.GetInOutProductsReport.sql', 4, '2021-05-06 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(18, '16.GetInventarRowList.sql', 1, '2021-03-24 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(19, '17.GetInventarList.sql', 4, '2021-05-06 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(20, '18.FiscalProductionCost.sql', 2, '2021-03-30 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(21, '19.PartialFiscalCost.sql', 3, '2021-03-30 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(22, '20.RecieptsReport.sql', 3, '2021-04-01 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(23, '21.ProductsRecieptReport.sql', 2, '2021-04-02 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(24, '22.ConsumptionReport.sql', 3, '2021-04-15 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(25, '23.RecipesCostReport.sql', 1, '2021-04-15 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(26, '24.PhraseSplitter.sql', 2, '2021-05-07 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(27, '25.SearchProcedures.sql', 2, '2021-05-10 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(28, '26.DeleteProcedures.sql', 2, '2021-05-21 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(29, '27.TriggerProcedures.sql', 1, '2021-05-18 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(30, '28.RecieptStockUpdate.sql', 2, '2021-06-25 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(31, '29.ExpiredProductsReport.sql', 2, '2021-06-04 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(32, '30.CommonStoredProcedures.sql', 2, '2021-06-25 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(33, '31.ProductCompositionReport.sql', 1, '2021-06-11 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(34, '32.SellProductsReport.sql', 1, '2021-06-11 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(35, '33.MonthlyIOReport.sql', 2, '2022-12-05 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(36, '34.UserCategoryTypeSellReport.sql', 1, '2021-07-07 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(37, '35.ProfitSellReport.sql', 1, '2021-07-21 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(38, '36.UserSellReport.sql', 1, '2021-11-02 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(39, '37.ClientMerge.sql', 1, '2021-11-30 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44'),
(40, '38.MonthlyIOAcquisitionReport.sql', 1, '2022-05-23 23:00:00', 'Ing. Dan Popa.', '2023-02-10 10:58:44');

-- --------------------------------------------------------

--
-- Table structure for table `SubcategoryHistory`
--

CREATE TABLE `SubcategoryHistory` (
  `Id` int(10) UNSIGNED NOT NULL,
  `WebId` int(11) NOT NULL DEFAULT '-1',
  `CategoryId` int(10) UNSIGNED NOT NULL,
  `SubcategoryId` int(10) UNSIGNED NOT NULL,
  `UpdatedById` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `Type` varchar(255) NOT NULL DEFAULT '''''',
  `Name` text NOT NULL,
  `Description` varchar(256) NOT NULL DEFAULT '',
  `Action` tinyint(4) NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `SubcategoryTypes`
--

CREATE TABLE `SubcategoryTypes` (
  `Id` int(11) NOT NULL,
  `Type` varchar(256) NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `SubcategoryTypes`
--

INSERT INTO `SubcategoryTypes` (`Id`, `Type`, `Timestamp`) VALUES
(1, 'simplu', '2021-05-11 07:23:42'),
(2, 'complex', '2021-05-11 07:23:42'),
(3, 'extra', '2021-05-11 07:23:42');

-- --------------------------------------------------------

--
-- Table structure for table `TableTypes`
--

CREATE TABLE `TableTypes` (
  `Id` int(11) NOT NULL,
  `Type` varchar(50) NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `TableTypes`
--

INSERT INTO `TableTypes` (`Id`, `Type`, `Timestamp`) VALUES
(0, 'Circle', '2021-07-01 09:03:05'),
(1, 'Square', '2021-07-01 09:02:50'),
(2, 'Rectangle', '2021-07-01 09:02:50');

-- --------------------------------------------------------

--
-- Table structure for table `Tags`
--

CREATE TABLE `Tags` (
  `Id` int(11) NOT NULL,
  `Name` varchar(50) NOT NULL,
  `Description` varchar(256) NOT NULL,
  `DocType` tinyint(4) NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TCategorii`
--

CREATE TABLE `TCategorii` (
  `TipCategorie` varchar(50) NOT NULL DEFAULT 'bar',
  `Blocat` tinyint(1) NOT NULL DEFAULT '0',
  `IDCategorie` int(11) UNSIGNED NOT NULL,
  `NumeCategorie` varchar(255) NOT NULL DEFAULT 'NoName',
  `Descriere` varchar(256) NOT NULL DEFAULT '',
  `UpdatedById` int(11) NOT NULL DEFAULT '1',
  `Delivery` tinyint(4) NOT NULL DEFAULT '1',
  `Priority` int(11) NOT NULL DEFAULT '0',
  `Deleted` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `TCategorii`
--

INSERT INTO `TCategorii` (`TipCategorie`, `Blocat`, `IDCategorie`, `NumeCategorie`, `Descriere`, `UpdatedById`, `Delivery`, `Priority`, `Deleted`) VALUES
('bar', 0, 1, 'BAR', '', 1, 1, 0, 0),
('bucatarie', 0, 2, 'Bucatarie', '', 1, 1, 0, 0);

--
-- Triggers `TCategorii`
--
DELIMITER $$
CREATE TRIGGER `LogCategoryDelete` BEFORE DELETE ON `TCategorii` FOR EACH ROW BEGIN
	INSERT INTO CategoryHistory (CategoryId, UpdatedById, Name, Description, Type, Action) VALUES 
                (OLD.IDCategorie, OLD.UpdatedById, OLD.NumeCategorie, OLD.Descriere, OLD.TipCategorie,  2);
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `LogCategoryUpdate` BEFORE UPDATE ON `TCategorii` FOR EACH ROW BEGIN
	INSERT INTO CategoryHistory (CategoryId, UpdatedById, Name, Description, Type, Action) VALUES 
                (OLD.IDCategorie, OLD.UpdatedById, OLD.NumeCategorie, OLD.Descriere, OLD.TipCategorie,  1);
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `TClienti`
--

CREATE TABLE `TClienti` (
  `ID` int(11) NOT NULL,
  `Denumire` varchar(254) NOT NULL,
  `CodClient` varchar(254) NOT NULL,
  `Credit` double(10,3) NOT NULL DEFAULT '0.000',
  `Procent` double(10,3) NOT NULL DEFAULT '0.000',
  `DataNasterii` date NOT NULL,
  `Nume` varchar(254) NOT NULL,
  `Prenume` varchar(254) NOT NULL,
  `Tel` varchar(100) NOT NULL,
  `Mail` varchar(254) NOT NULL,
  `Minute` int(11) NOT NULL,
  `DataAb` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `DataExpirareAb` date NOT NULL,
  `Durata` int(5) NOT NULL,
  `STRADA` varchar(250) NOT NULL,
  `NR` varchar(100) NOT NULL,
  `BLOC` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TClientiFactura`
--

CREATE TABLE `TClientiFactura` (
  `ID` int(11) NOT NULL,
  `CIFCNP` text,
  `Denumire` text,
  `RegCOM` text,
  `Adresa` text,
  `Localitate` text,
  `Judet` text,
  `Tara` text,
  `Iban` text,
  `Banca` text,
  `Email` text,
  `PersContact` text,
  `Telefon` text,
  `PostCode` varchar(155) NOT NULL,
  `Procent` float NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TDateFirma`
--

CREATE TABLE `TDateFirma` (
  `ID` int(11) NOT NULL DEFAULT '0',
  `CIFCNP` text,
  `Denumire` text,
  `RegCOM` text,
  `Adresa` text,
  `Localitate` text,
  `Judet` text,
  `Tara` text,
  `Iban` text,
  `Banca` text,
  `Email` text,
  `PersContact` text,
  `Telefon` text,
  `IntocmitDe` text,
  `CNP` text,
  `PunctDeLucru` varchar(254) NOT NULL,
  `Mesaj` varchar(254) NOT NULL,
  `Status` int(16) NOT NULL,
  `BO` int(2) NOT NULL,
  `FF` int(2) NOT NULL,
  `ET` int(2) NOT NULL,
  `DataAb` date NOT NULL,
  `DataScad` date NOT NULL,
  `DataSusp` date NOT NULL,
  `RefPL` varchar(36) NOT NULL DEFAULT '0',
  `Gestiune` varchar(100) NOT NULL DEFAULT 'Default',
  `MetroKey` varchar(256) NOT NULL,
  `HomeStore` int(11) NOT NULL,
  `CustomerNumber` int(11) NOT NULL,
  `LocationId` int(11) NOT NULL,
  `NumarCatalog` int(11) NOT NULL DEFAULT '0',
  `SerieDeviz` varchar(50) NOT NULL DEFAULT 'DV'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `TDateFirma`
--

INSERT INTO `TDateFirma` (`ID`, `CIFCNP`, `Denumire`, `RegCOM`, `Adresa`, `Localitate`, `Judet`, `Tara`, `Iban`, `Banca`, `Email`, `PersContact`, `Telefon`, `IntocmitDe`, `CNP`, `PunctDeLucru`, `Mesaj`, `Status`, `BO`, `FF`, `ET`, `DataAb`, `DataScad`, `DataSusp`, `RefPL`, `Gestiune`, `MetroKey`, `HomeStore`, `CustomerNumber`, `LocationId`, `NumarCatalog`, `SerieDeviz`) VALUES
(1, '0000', 'Demo SoftOK', 'J1/23/567', 'Adresa', 'Sector 3', 'BUCURESTI', 'Romania', 'RO123456', 'Banca', 'mail@domain.tld', '.', '0', 'nume prenume', '.', 'Punct de lucru', ' O K ', 0, 1, 0, 1, '2019-02-12', '2030-02-15', '2030-03-02', '0', 'Default', '-', 0, 0, 0, 0, 'DV');

--
-- Triggers `TDateFirma`
--
DELIMITER $$
CREATE TRIGGER `TDateFirmaUpdate` AFTER UPDATE ON `TDateFirma` FOR EACH ROW BEGIN
    IF NEW.CIFCNP != OLD.CIFCNP OR 
        NEW.Denumire != OLD.Denumire
    THEN
        UPDATE TSerieF SET TSerieF.Timestamp = current_timestamp();
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `Template`
--

CREATE TABLE `Template` (
  `Id` int(11) NOT NULL,
  `PrinterId` int(11) NOT NULL DEFAULT '-1',
  `Body` text NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `Active` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TEMP_TBL`
--

CREATE TABLE `TEMP_TBL` (
  `Type` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TErori`
--

CREATE TABLE `TErori` (
  `ID` int(11) NOT NULL,
  `EROARE` text NOT NULL,
  `Functie` varchar(250) DEFAULT 'Undefined',
  `Class` varchar(250) NOT NULL,
  `Aplicatie` varchar(250) DEFAULT 'Undefined',
  `DATA` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TFacturi`
--

CREATE TABLE `TFacturi` (
  `ID` int(11) NOT NULL,
  `TagId` int(11) DEFAULT NULL,
  `UserId` int(11) NOT NULL DEFAULT '1',
  `LinkedInvoiceId` int(11) DEFAULT NULL,
  `IDFurnizor` int(11) NOT NULL,
  `GestClientId` int(11) NOT NULL DEFAULT '0',
  `SerieFactura` varchar(250) NOT NULL,
  `NumarFactura` int(25) NOT NULL,
  `DataFactura` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `DataScadenta` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `DenumireClient` varchar(250) NOT NULL,
  `NrTranzactie` int(11) NOT NULL,
  `DATA` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `Total` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA1` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA2` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA3` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA4` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA5` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA6` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA7` double(10,2) NOT NULL DEFAULT '0.00',
  `TotalTVA` double(10,2) NOT NULL DEFAULT '0.00',
  `Type` tinyint(1) NOT NULL DEFAULT '0',
  `Storno` tinyint(1) NOT NULL DEFAULT '0',
  `Active` tinyint(1) NOT NULL DEFAULT '1',
  `Observatii` varchar(255) NOT NULL DEFAULT '-',
  `WithStock` tinyint(1) NOT NULL DEFAULT '1',
  `Achitata` tinyint(1) NOT NULL DEFAULT '1',
  `IsAvans` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TFacturiClienti`
--

CREATE TABLE `TFacturiClienti` (
  `ID` int(11) NOT NULL,
  `NumarFactura` longtext,
  `SerieFactura` longtext,
  `IDClient` int(11) DEFAULT NULL,
  `DataFactura` date DEFAULT NULL,
  `IDBon` int(11) DEFAULT NULL,
  `NrTranzactie` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TFacturiProduse`
--

CREATE TABLE `TFacturiProduse` (
  `ID` int(11) NOT NULL,
  `DenumireProdus` text NOT NULL,
  `TVA` int(11) DEFAULT '0',
  `Unitate` text,
  `Cantitate` double(10,3) DEFAULT '0.000',
  `PterUnitar` double(10,2) NOT NULL DEFAULT '0.00',
  `DataF` timestamp NULL DEFAULT NULL,
  `SerieF` text,
  `NumarF` int(11) DEFAULT '0',
  `CifClient` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '0',
  `TotalProduse` double(10,2) NOT NULL DEFAULT '0.00',
  `TotalTvaProdus` double(10,2) NOT NULL DEFAULT '0.00',
  `TPretUnitarFaraTVA` double(10,2) NOT NULL DEFAULT '0.00',
  `TTotalProduseFaraTva` double(10,2) NOT NULL DEFAULT '0.00',
  `IdP` int(11) DEFAULT '0',
  `IdTranzactie` int(11) NOT NULL,
  `TVA1` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA2` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA3` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA4` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA5` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA6` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA7` double(10,2) NOT NULL DEFAULT '0.00',
  `Type` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TInventar`
--

CREATE TABLE `TInventar` (
  `ProdusId` int(11) NOT NULL,
  `Denumire` longtext NOT NULL,
  `PretAchizitie` double(10,2) NOT NULL DEFAULT '0.00',
  `Pret` double(10,2) NOT NULL DEFAULT '0.00',
  `StocInventar` double(10,3) NOT NULL DEFAULT '0.000',
  `StocProdus` double(10,3) NOT NULL DEFAULT '0.000',
  `Diferenta` double(10,3) NOT NULL DEFAULT '0.000'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TInventarUsers`
--

CREATE TABLE `TInventarUsers` (
  `Id` int(11) NOT NULL,
  `UserId` int(11) NOT NULL,
  `ProductId` int(11) NOT NULL,
  `Quantity` double(10,3) NOT NULL DEFAULT '0.000',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Deleted` tinyint(1) NOT NULL DEFAULT '0',
  `Active` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TMarimi`
--

CREATE TABLE `TMarimi` (
  `Id` int(11) NOT NULL,
  `ProdusId` int(11) DEFAULT NULL,
  `Nume` varchar(256) NOT NULL,
  `Stoc` double NOT NULL,
  `Cod` varchar(256) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TMarimiBonActivTemp`
--

CREATE TABLE `TMarimiBonActivTemp` (
  `ID` int(11) NOT NULL,
  `BonId` int(11) NOT NULL,
  `ProdusId` int(11) NOT NULL,
  `MarimeId` int(11) NOT NULL,
  `Nume` varchar(256) NOT NULL,
  `Cantitate` double NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TMese`
--

CREATE TABLE `TMese` (
  `ID` int(11) NOT NULL,
  `NumeMasa` longtext NOT NULL,
  `CoordY` int(11) NOT NULL DEFAULT '0',
  `CoordX` int(11) NOT NULL DEFAULT '0',
  `IDSala` int(11) NOT NULL DEFAULT '1',
  `Imprimata` int(32) NOT NULL DEFAULT '0',
  `Deschisa` int(32) NOT NULL DEFAULT '0',
  `TableType` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `TMese`
--

INSERT INTO `TMese` (`ID`, `NumeMasa`, `CoordY`, `CoordX`, `IDSala`, `Imprimata`, `Deschisa`, `TableType`) VALUES
(1, '1', 14, 673, 1, 0, 0, 0),
(2, '2', 108, 672, 1, 0, 0, 0),
(3, '3', 254, 673, 1, 0, 0, 0),
(4, '4', 351, 673, 1, 0, 0, 0),
(5, '5', 473, 673, 1, 0, 0, 0),
(6, '6', 29, 139, 1, 0, 0, 0),
(7, '7', 32, 260, 1, 0, 0, 0),
(8, '8', 36, 385, 1, 0, 0, 0),
(9, '9', 294, 431, 1, 0, 0, 0),
(10, '10', 293, 315, 1, 0, 0, 0),
(11, '11', 292, 221, 1, 0, 0, 0),
(12, '12', 293, 126, 1, 0, 0, 0),
(13, '13', 473, 131, 1, 0, 0, 0),
(14, '14', 473, 228, 1, 0, 0, 0),
(15, '15', 473, 322, 1, 0, 0, 0),
(16, '16', 473, 427, 1, 0, 0, 0),
(17, '17', 12, 424, 2, 0, 0, 0),
(18, '18', 10, 320, 2, 0, 0, 0),
(19, '19', 10, 223, 2, 0, 0, 0),
(20, '20', 11, 131, 2, 0, 0, 0),
(21, '21', 162, 144, 2, 0, 0, 0),
(22, '22', 159, 263, 2, 0, 0, 0),
(23, '23', 299, 269, 2, 0, 0, 0),
(24, '24', 298, 148, 2, 0, 0, 0),
(25, '25', 473, 140, 2, 0, 0, 0),
(26, '26', 473, 278, 2, 0, 0, 0),
(27, '27', 473, 433, 2, 0, 0, 0),
(28, '28', 469, 673, 2, 0, 0, 0),
(29, '29', 367, 673, 2, 0, 0, 0),
(30, '30', 266, 671, 2, 0, 0, 0),
(31, '31', 165, 542, 2, 0, 0, 0),
(32, '32', 8, 178, 3, 0, 0, 0),
(33, '33', 95, 179, 3, 0, 0, 0),
(34, '34', 195, 126, 3, 0, 0, 0),
(35, '35', 289, 127, 3, 0, 0, 0),
(36, '36', 384, 126, 3, 0, 0, 0),
(37, '37', 473, 126, 3, 0, 0, 0),
(38, '38', 195, 224, 3, 0, 0, 0),
(39, '39', 383, 224, 3, 0, 0, 0),
(40, '40', 473, 223, 3, 0, 0, 0),
(41, '41', 196, 324, 3, 0, 0, 0),
(42, '42', 386, 327, 3, 0, 0, 0),
(43, '43', 473, 324, 3, 0, 0, 0),
(44, '44', 195, 136, 4, 0, 0, 0),
(45, '45', 339, 139, 4, 0, 0, 0),
(46, '46', 463, 142, 4, 0, 0, 0),
(47, '47', 196, 233, 4, 0, 0, 0),
(48, '48', 341, 232, 4, 0, 0, 0),
(49, '49', 466, 227, 4, 0, 0, 0),
(50, '50', 197, 328, 4, 0, 0, 0),
(51, '51', 345, 329, 4, 0, 0, 0),
(52, '52', 463, 331, 4, 0, 0, 0),
(53, '53', 286, 225, 3, 0, 0, 0),
(54, '54', 473, 517, 3, 0, 0, 0),
(55, '55', 67, 673, 5, 0, 0, 0),
(56, '56', 191, 673, 5, 0, 0, 0),
(57, '57', 310, 673, 5, 0, 0, 0),
(58, '58', 422, 673, 5, 0, 0, 0),
(59, '59', 463, 389, 5, 0, 0, 0),
(60, '60', 359, 380, 5, 0, 0, 0),
(61, '61', 230, 375, 5, 0, 0, 0),
(62, '62', 104, 376, 5, 0, 0, 0),
(63, '63', 17, 160, 5, 0, 0, 0),
(64, '64', 132, 162, 5, 0, 0, 0),
(65, '65', 340, 156, 5, 0, 0, 0),
(66, '66', 465, 162, 5, 0, 0, 0),
(67, '67', 428, 957, 2, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `TModificarePret`
--

CREATE TABLE `TModificarePret` (
  `ID` int(11) NOT NULL,
  `DATA` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `USER` varchar(254) NOT NULL,
  `EVENIMENT` varchar(255) NOT NULL,
  `DETALII` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TModificarePretProduse`
--

CREATE TABLE `TModificarePretProduse` (
  `ID` int(11) NOT NULL,
  `IDProcesVerbal` int(11) NOT NULL,
  `IDProdus` int(11) NOT NULL,
  `Denumire` varchar(150) NOT NULL,
  `PRET` double(10,2) NOT NULL DEFAULT '0.00',
  `PRETNou` double(10,2) NOT NULL DEFAULT '0.00',
  `PROCENT` double(10,2) NOT NULL DEFAULT '0.00',
  `STOC` double(10,3) NOT NULL DEFAULT '0.000',
  `TVA` int(11) NOT NULL,
  `VALOARE` double(10,2) NOT NULL DEFAULT '0.00',
  `VALOARENOU` double(10,2) NOT NULL DEFAULT '0.00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `Topping`
--

CREATE TABLE `Topping` (
  `Id` int(11) NOT NULL,
  `NrTopping` int(11) NOT NULL,
  `IdProdus` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TProduse`
--

CREATE TABLE `TProduse` (
  `ID` int(11) NOT NULL,
  `Prioritate` int(11) NOT NULL,
  `IDSubCategorie` int(11) NOT NULL,
  `Denumire` varchar(256) NOT NULL,
  `Pret` double(10,2) NOT NULL,
  `Imagine` longtext NOT NULL,
  `UM` varchar(254) NOT NULL DEFAULT 'bucata',
  `Compozitie` longtext,
  `Stoc` double(10,3) NOT NULL DEFAULT '0.000',
  `TVA` int(11) NOT NULL DEFAULT '0',
  `PretAchizitie` double(10,2) NOT NULL DEFAULT '0.00',
  `CodBare` varchar(50) NOT NULL DEFAULT '0',
  `LimitaStoc` double(10,3) NOT NULL DEFAULT '0.000',
  `CodPlu` varchar(75) NOT NULL DEFAULT '0',
  `Pret2` double(10,2) NOT NULL DEFAULT '0.00',
  `StocMinim` double(10,3) NOT NULL DEFAULT '0.000',
  `Complex` tinyint(1) NOT NULL DEFAULT '0',
  `Sizeable` tinyint(1) NOT NULL DEFAULT '0',
  `OnlineSync` tinyint(4) NOT NULL DEFAULT '-1',
  `HasAssociated` tinyint(1) NOT NULL DEFAULT '0',
  `HasExpirationDate` tinyint(1) NOT NULL DEFAULT '0',
  `MateriePrima` tinyint(1) NOT NULL DEFAULT '0',
  `WebProductId` int(11) NOT NULL DEFAULT '-1',
  `TVAL` int(11) NOT NULL DEFAULT '1',
  `TVAF` int(1) NOT NULL DEFAULT '1',
  `AdaosNIR` double(10,2) NOT NULL DEFAULT '0.00',
  `Descriere` varchar(255) NOT NULL DEFAULT '-',
  `Discount` double(10,2) NOT NULL DEFAULT '0.00',
  `IdTopping` int(11) NOT NULL DEFAULT '-1',
  `IdOptiuniMeniu` int(11) NOT NULL DEFAULT '0',
  `CantitateOptiuni` int(11) NOT NULL DEFAULT '1',
  `LotIntern` varchar(255) NOT NULL DEFAULT '-1',
  `LotProducator` varchar(255) NOT NULL DEFAULT '-1',
  `DataProductie` date DEFAULT NULL,
  `DataExpirare` date DEFAULT NULL,
  `TempPastrare` varchar(255) NOT NULL DEFAULT '0.00',
  `TaraOrigine` varchar(255) NOT NULL DEFAULT '-',
  `Added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `UserId` int(11) NOT NULL DEFAULT '0',
  `Deleted` tinyint(4) NOT NULL DEFAULT '0',
  `Greutate` double(10,3) NOT NULL DEFAULT '0.000',
  `Active` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `TProduse`
--

INSERT INTO `TProduse` (`ID`, `Prioritate`, `IDSubCategorie`, `Denumire`, `Pret`, `Imagine`, `UM`, `Compozitie`, `Stoc`, `TVA`, `PretAchizitie`, `CodBare`, `LimitaStoc`, `CodPlu`, `Pret2`, `StocMinim`, `Complex`, `Sizeable`, `OnlineSync`, `HasAssociated`, `HasExpirationDate`, `MateriePrima`, `WebProductId`, `TVAL`, `TVAF`, `AdaosNIR`, `Descriere`, `Discount`, `IdTopping`, `IdOptiuniMeniu`, `CantitateOptiuni`, `LotIntern`, `LotProducator`, `DataProductie`, `DataExpirare`, `TempPastrare`, `TaraOrigine`, `Added`, `UserId`, `Deleted`, `Greutate`, `Active`) VALUES
(1, 4, 13, 'BRUSCHETTE AL POMODORO 110 gr', 15.90, '', 'bucata', '', -2208.000, 2, 0.00, '6550826550820', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(2, 4, 13, 'BRUSCHETTE AL  SALMONE 110 gr', 20.90, '', 'bucata', '', -891.000, 2, 0.00, '4756794756796', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(3, 4, 13, 'CROSTINI TOSCANI 110 gr', 24.90, '', 'bucata', '', -644.000, 2, 0.00, '5574895574892', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(4, 4, 13, 'CAPRESE 180 gr', 19.90, '', 'bucata', '', -127.000, 2, 0.00, '8780878780878', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(5, 4, 13, 'CARPACCIO DI VITELLO 140 gr', 32.90, '', 'bucata', '', -919.000, 2, 0.00, '4598974598976', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(6, 4, 13, 'PROSCIUTO PARMA 50 gr', 18.90, '', 'bucata', '', -2033.000, 2, 0.00, '7804957804956', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(7, 4, 13, 'SALAME 50 gr', 16.90, '', 'bucata', '', -927.000, 2, 0.00, '6010926010926', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(8, 4, 13, 'PARMIGIANO 50 gr', 13.90, '', 'bucata', '', -1269.000, 2, 0.00, '6829026829020', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(9, 4, 13, 'POMODORINI SECCIHI 50 gr', 11.90, '', 'bucata', '', -579.000, 2, 0.00, '5035005035004', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(10, 4, 13, 'ROSII CHERI 100 gr', 9.90, '', 'bucata', '', -1793.000, 2, 0.00, '5853105853102', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(11, 4, 13, 'OLIVE 100 gr', 13.90, '', 'bucata', '', -3027.000, 2, 0.00, '9059079059076', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(12, 4, 13, 'RUCOLA 30 gr', 7.50, '', 'bucata', '', -92.000, 2, 0.00, '7265057265052', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(13, 4, 13, 'BURRATA 250 gr', 29.90, '', 'bucata', '', -2289.000, 2, 0.00, '8083158083158', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(15, 4, 13, 'MOZZARELLA DI BUFALA 125 gr', 23.90, '', 'bucata', '', -467.000, 2, 0.00, '7107237107236', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(16, 4, 14, 'INSALATA VEGETARIANA 200 gr', 22.90, '', 'bucata', '', -318.000, 2, 0.00, '5313205313208', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(17, 4, 14, 'INSALATA  IL PECATO 250 gr', 24.90, '', 'bucata', '', -910.000, 2, 0.00, '8519178519174', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(18, 4, 14, 'INSALATA  AL SALMONE AFUMIGATO 250 gr', 29.90, '', 'bucata', '', -482.000, 2, 0.00, '4337284337284', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(19, 4, 14, 'INSALATA  VERDE 80 gr', 13.90, '', 'bucata', '', -647.000, 2, 0.00, '7543257543256', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(20, 4, 15, 'SPAGHETTI DI MARE 320 gr', 40.90, '', 'bucata', '', -2128.000, 2, 0.00, '8361358361352', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(21, 4, 15, 'TAGLIATELLE DI MARE 320 gr', 40.90, '', 'bucata', '', -304.000, 2, 0.00, '6567336567330', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(22, 4, 15, 'TAGLIATELLE AL SALMONE 250 gr', 41.90, '', 'bucata', '', -1278.000, 2, 0.00, '4773304773302', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(23, 4, 15, 'PAPPARDELLE PORCINI E TARTUFO  250 gr', 45.90, '', 'bucata', '', -1494.000, 2, 0.00, '5591405591408', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(24, 4, 15, 'PENE QUATTRO FORMAGGI 250 gr', 39.90, '', 'bucata', '', -1654.000, 2, 0.00, '8797388797388', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(25, 4, 15, 'TAGLIATELE MARI E MONTI  300 gr', 45.90, '', 'bucata', '', -1289.000, 2, 0.00, '4615484615488', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(26, 4, 15, 'FUSILLI INTEGRALI CON VERDURE E TARTUFO 250 gr', 38.90, '', 'bucata', '', -806.000, 2, 0.00, '7821467821464', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(27, 4, 15, 'RIGATONI ALLA MATRICIANA 250 gr', 39.90, '', 'bucata', '', -1097.000, 2, 0.00, '6027436027436', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(28, 4, 15, 'TAGLIATELLE ALLA MATRICIANA 250 gr', 39.90, '', 'bucata', '', -6.000, 2, 0.00, '6845536845534', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(29, 4, 15, 'SPAGHETTI CARBONARA  200 gr', 37.90, '', 'bucata', '', -2429.000, 2, 0.00, '5051515051518', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(30, 4, 15, 'PASTA CASEI 250 gr', 28.50, '', 'bucata', '', -562.000, 2, 0.00, '5869615869618', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(31, 4, 15, 'SPAGHETTI CON GAMBERI  300 gr', 45.90, '', 'bucata', '', -1959.000, 2, 0.00, '9075589075580', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(32, 4, 16, 'FILETTO SANGE 250 gr', 57.90, '', 'bucata', '', -63.000, 2, 0.00, '7281567281566', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(33, 4, 16, 'FILETTO MEDIU 250 gr', 57.90, '', 'bucata', '', -567.000, 2, 0.00, '8099668099664', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(34, 4, 16, 'FILETTO B.FACUT 250 gr', 57.90, '', 'bucata', '', -119.000, 2, 0.00, '6305636305630', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(35, 4, 16, 'ANTRICOT SANGE 300/400 gr', 38.90, '', 'bucata', '', -142.000, 2, 0.00, '7123747123740', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(36, 4, 16, 'ANTRICOT MEDIU 300/400 gr', 38.90, '', 'bucata', '', -1022.000, 2, 0.00, '5329715329714', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(37, 4, 16, 'ANTRICOT Mediu fr.sange 300/400 gr', 38.90, '', 'bucata', '', -553.000, 2, 0.00, '8535688535688', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(38, 4, 16, 'COSTOLETE DI AGNELLO CON PATATE 400 gr', 47.90, '', 'bucata', '', -706.000, 2, 0.00, '4353794353798', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(39, 4, 16, 'VITELO DA LATTE AL FORNO 300 gr', 46.50, '', 'bucata', '', -920.000, 2, 0.00, '7559767559762', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(40, 4, 16, 'COSTOLETE DI VITELLO DA LATTE ALLA GRIGLIA O  350 gr', 45.90, '', 'bucata', '', -565.000, 2, 0.00, '8377868377868', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(41, 4, 16, 'PIEPT DE PUI 200 gr', 27.90, '', 'bucata', '', -174.000, 2, 0.00, '6583846583844', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(42, 4, 17, 'FRITTURA IL PECCATO 300 gr', 52.90, '', 'bucata', '', -3360.000, 2, 0.00, '4789814789818', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(43, 4, 17, 'FRITTURA DI CALAMARI 200 gr', 37.90, '', 'bucata', '', -1637.000, 2, 0.00, '5607915607918', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(44, 4, 17, 'FRUTTI DI MARE ALLA GRIGLIA 220 gr', 53.90, '', 'bucata', '', -1504.000, 2, 0.00, '8813898813896', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(45, 4, 17, 'RISOTTO ALLA MARINARA 250 gr', 47.90, '', 'bucata', '', -759.000, 2, 0.00, '4631994631992', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(46, 4, 17, 'COZZE 500 gr', 35.90, '', 'bucata', '', -3153.000, 2, 0.00, '7837967837966', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(47, 4, 17, 'ORATA 300/400 gr', 50.90, '', 'bucata', '', -237.000, 2, 0.00, '6043946043940', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(48, 4, 18, 'PATATE FRITE 150 gr', 13.90, '', 'bucata', '', -2262.000, 2, 0.00, '6862046862042', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(49, 4, 18, 'PATATE AL FORNO 150 gr', 13.90, '', 'bucata', '', -1590.000, 2, 0.00, '5068025068028', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(50, 4, 18, 'RISOTTO 200 gr', 15.90, '', 'bucata', '', -613.000, 2, 0.00, '5886125886126', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(51, 4, 19, 'PIZZA VEGETARIANA 585 gr', 38.90, '', 'bucata', '', -608.000, 2, 0.00, '9092099092098', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(52, 4, 19, 'PIZZA PROSCIUTO E FUNGHI 465 gr', 37.90, '', 'bucata', '', -1354.000, 2, 0.00, '7298077298076', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(53, 4, 19, 'PIZZA MARGHERITA 340 gr', 25.90, '', 'bucata', '', -2169.000, 2, 0.00, '8116178116176', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(54, 4, 19, 'PIZZA CARBONARA 300 gr', 39.90, '', 'bucata', '', -158.000, 2, 0.00, '6322146322148', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(55, 4, 19, 'PIZZA IL PECCATO 540 gr', 42.90, '', 'bucata', '', -1250.000, 2, 0.00, '7140247140244', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(56, 4, 19, 'PIZZA FRUTTI DI MARE 500 gr', 45.90, '', 'bucata', '', -350.000, 2, 0.00, '5346225346222', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(57, 4, 19, 'PIZZA CAPRICCIOSA  520 gr', 39.90, '', 'bucata', '', -1919.000, 2, 0.00, '8552198552196', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(58, 4, 19, 'PIZZA  PORCINI E TARTOFO NERO 400 gr', 43.90, '', 'bucata', '', -621.000, 2, 0.00, '4370304370304', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(59, 4, 19, 'PIZZA  MARINARA 425 gr', 33.90, '', 'bucata', '', -256.000, 2, 0.00, '7576277576270', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(60, 4, 19, 'PIZZA  ROSSA 410 gr', 40.90, '', 'bucata', '', -330.000, 2, 0.00, '8394378394376', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(61, 4, 19, 'PIZZA QUATTRO FROMAGGI 410 gr', 42.90, '', 'bucata', '', -1507.000, 2, 0.00, '6600356600356', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(62, 4, 19, 'PIZZA CALZONE 500 gr', 37.90, '', 'bucata', '', -594.000, 2, 0.00, '4806324806320', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(63, 4, 19, 'PIZZA TONNO E CIPOLLA 460 gr', 42.90, '', 'bucata', '', -429.000, 2, 0.00, '5624425624426', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(64, 4, 19, 'PIZZA DIAVOLA 410 gr', 40.90, '', 'bucata', '', -1761.000, 2, 0.00, '8830408830402', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(65, 4, 19, 'PIZZA QUATTRO STAGIONI 500 gr', 39.90, '', 'bucata', '', -736.000, 2, 0.00, '4648504648500', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(66, 4, 19, 'FOCACCIEA AGLIO 280 gr', 14.90, '', 'bucata', '', -1180.000, 2, 0.00, '7854477854474', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(67, 4, 19, 'FOCACCIEA SALE MARINO 280 gr', 14.90, '', 'bucata', '', -1395.000, 2, 0.00, '6060456060458', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(68, 4, 19, 'FOCACCIEA ROSMARINO 280 gr', 14.90, '', 'bucata', '', -487.000, 2, 0.00, '6878556878558', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(69, 4, 19, 'FOCACCIEA PARMIGIANO 280 gr', 14.90, '', 'bucata', '', -2427.000, 2, 0.00, '5084535084532', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(70, 4, 20, 'PROFITEROL NEGRU 150 gr', 19.90, '', 'bucata', '', -167.000, 2, 0.00, '5902635902634', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(71, 4, 20, 'PROFITEROL ALB 150 gr', 19.90, '', 'bucata', '', -58.000, 2, 0.00, '9108609108606', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(72, 4, 20, 'PROFITEROL MIXT 150 gr', 19.90, '', 'bucata', '', -488.000, 2, 0.00, '7314587314584', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(73, 4, 20, 'TIRAMISU 110 gr', 20.90, '', 'bucata', '', -2538.000, 2, 0.00, '8132688132680', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(74, 4, 20, 'PANNACOTTA 110 gr', 18.90, '', 'bucata', '', -799.000, 2, 0.00, '6338656338654', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(75, 4, 20, 'CANOLLI 100 gr', 13.90, '', 'bucata', '', -2210.000, 2, 0.00, '7156757156750', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(76, 4, 20, 'PIZZA NUTELLA 500 gr', 36.90, '', 'bucata', '', -131.000, 2, 0.00, '5362735362736', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(77, 4, 21, 'PAINE 30 gr', 6.90, '', 'bucata', '', -638.000, 2, 0.00, '8568708568700', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(78, 4, 21, 'SOS ROSII 35 gr', 4.90, '', 'bucata', '', -1547.000, 2, 0.00, '4386814386810', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(80, 4, 21, 'EXTRA ANSHOA 25 gr', 9.00, '', 'bucata', '', -34.000, 2, 0.00, '7592787592784', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(81, 4, 21, 'GORGONZOLA 50 gr', 9.00, '', 'bucata', '', -161.000, 2, 0.00, '8410888410884', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(82, 4, 21, 'PORCINI 50 gr', 11.00, '', 'bucata', '', -48.000, 2, 0.00, '6616866616862', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(83, 4, 21, 'TON 50 gr', 11.00, '', 'bucata', '', -47.000, 2, 0.00, '4822834822834', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(84, 4, 21, 'EXTRA BUFFALA PIZZA 110 gr', 16.90, '', 'bucata', '', -10.000, 2, 0.00, '5640935640930', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(85, 4, 21, 'SALAMI 50 gr', 15.90, '', 'bucata', '', -75.000, 2, 0.00, '8846918846918', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(86, 4, 21, 'SUNCA 50 gr', 13.00, '', 'bucata', '', -93.000, 2, 0.00, '4665014665018', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(87, 4, 21, 'PROCIUTO CRUDO 50 gr', 15.90, '', 'bucata', '', -27.000, 2, 0.00, '7870987870988', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(88, 4, 21, 'VINETE 50 gr', 7.00, '', 'bucata', '', -8.000, 2, 0.00, '6076966076964', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(89, 4, 21, 'RUCOLA 35 gr', 8.90, '', 'bucata', '', -75.000, 2, 0.00, '6895066895066', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(90, 4, 21, 'CARCIOFI 50 gr', 9.00, '', 'bucata', '', -25.000, 2, 0.00, '5101045101044', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(91, 4, 22, 'PIZZA VEGETARIANA H   585 gr', 22.90, '', 'bucata', '', -98.000, 2, 0.00, '5919145919144', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(92, 4, 22, 'PIZZA PROSCIUTO E FUNGHI H 465 gr', 22.90, '', 'bucata', '', -157.000, 2, 0.00, '4125114125114', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(93, 4, 22, 'PIZZA MARGHERITA 340 gr', 19.00, '', 'bucata', '', -165.000, 2, 0.00, '7331097331092', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(94, 4, 22, 'PIZZA CARBONARA H 300 gr', 22.90, '', 'bucata', '', -129.000, 2, 0.00, '8149198149190', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(95, 4, 22, 'PIZZA IL PECCATO H  540 gr', 23.90, '', 'bucata', '', -206.000, 2, 0.00, '6355166355162', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(97, 4, 22, 'PIZZA CAPRICCIOSA H  520 gr', 22.90, '', 'bucata', '', -373.000, 2, 0.00, '5379245379246', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(98, 4, 22, 'PIZZA  PORCINI E TARTUFO NERO H 400 gr', 22.90, '', 'bucata', '', -88.000, 2, 0.00, '8585218585218', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(99, 4, 22, 'PIZZA  MARINARA H 425 gr', 22.90, '', 'bucata', '', -22.000, 2, 0.00, '4403324403322', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(100, 4, 22, 'PIZZA  ROSSA H 410 gr', 22.90, '', 'bucata', '', -14.000, 2, 0.00, '7609297609298', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(101, 4, 22, 'PIZZA QUATTRO FROMAGGI H 410 gr', 22.90, '', 'bucata', '', -391.000, 2, 0.00, '8427398427394', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(102, 4, 22, 'PIZZA CALZONE  H 500 gr', 22.90, '', 'bucata', '', -58.000, 2, 0.00, '6633376633370', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(103, 4, 22, 'PIZZA TONNO E CIPOLLA H 460 gr', 23.90, '', 'bucata', '', -113.000, 2, 0.00, '4839344839344', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(104, 4, 22, 'PIZZA DIAVOLA H 410 gr', 22.90, '', 'bucata', '', -216.000, 2, 0.00, '5657445657440', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(105, 4, 22, 'PIZZA QUATTRO STAGIONI H 500 gr', 22.90, '', 'bucata', '', -113.000, 2, 0.00, '8863428863426', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(106, 4, 1, 'JOHNNIE WALKER RED LAB 40 ml', 18.00, '', 'bucata', '', -34.000, 1, 0.00, '4681524681522', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(107, 4, 1, 'JOHNNIE WALKER BLACK LAB 40 ml', 25.00, '', 'bucata', '', -57.000, 1, 0.00, '7887497887498', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(108, 4, 1, 'J&B RARE  40 ml', 18.00, '', 'bucata', '', -127.000, 1, 0.00, '6093476093472', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(109, 4, 1, 'CHIVAS REGAL 12 YO 40 ml', 25.00, '', 'bucata', '', -65.000, 1, 0.00, '6911576911574', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(110, 4, 1, 'JIM BEAM 40 ml', 18.00, '', 'bucata', '', -75.000, 1, 0.00, '5117555117550', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(111, 4, 1, 'JACK DANIELS 40 ml', 18.00, '', 'bucata', '', -267.000, 1, 0.00, '5935655935658', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(112, 4, 1, 'LA GAVULIN 16 YO 40 ml', 40.00, '', 'bucata', '', -53.000, 1, 0.00, '4141624141628', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(113, 4, 1, 'GLENDFIDDICH 12 YO 40 ml', 24.00, '', 'bucata', '', -114.000, 1, 0.00, '7347607347606', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(114, 4, 1, 'BUSHMILLS  40 ml', 18.00, '', 'bucata', '', -68.000, 1, 0.00, '8165708165702', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(115, 4, 1, 'BAILEY S 40 ml', 18.00, '', 'bucata', '', -33.000, 1, 0.00, '6371676371676', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(116, 4, 1, 'SHERIDAN S 40 ml', 18.00, '', 'bucata', '', -8.000, 1, 0.00, '7189777189774', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(117, 4, 2, 'ABSOLUT 40 ml', 18.00, '', 'bucata', '', -171.000, 1, 0.00, '5395755395750', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(119, 4, 2, 'TEQUILA JOSE CUERVO 40 ml', 16.00, '', 'bucata', '', -111.000, 1, 0.00, '4419834419838', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(120, 4, 2, 'GIN GORDONS  40 ml', 16.00, '', 'bucata', '', -21.000, 1, 0.00, '7625807625800', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(121, 4, 2, 'COGNAC REMY MARTIN V.S.O.P 40 ml', 30.00, '', 'bucata', '', -172.000, 1, 0.00, '8443908443906', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(122, 4, 2, 'RUM CAPTAIN MORGAN GOLD/BLACK 40 ml', 17.00, '', 'bucata', '', -107.000, 1, 0.00, '6649886649886', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(123, 4, 3, 'AMARO RAMAZZOTI 40 ml', 18.00, '', 'bucata', '', -31.000, 1, 0.00, '4855854855858', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(124, 4, 3, 'VECCHIO AMARO DEL CAPO 40 ml', 18.00, '', 'bucata', '', -385.000, 1, 0.00, '5673955673954', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(125, 4, 3, 'AVERNA 40 ml', 18.00, '', 'bucata', '', -76.000, 1, 0.00, '8879938879932', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(126, 4, 3, 'FERNET BRANCA 40 ml', 18.00, '', 'bucata', '', -336.000, 1, 0.00, '4698034698032', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(127, 4, 3, 'SAMBUCA MOLINARI 40 ml', 18.00, '', 'bucata', '', -62.000, 1, 0.00, '7904007904008', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(128, 4, 3, 'AMARETTO DI SARONO 40 ml', 18.00, '', 'bucata', '', -120.000, 1, 0.00, '6109986109982', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(129, 4, 3, 'JAGERMAISTER 40 ml', 18.00, '', 'bucata', '', -246.000, 1, 0.00, '6928086928084', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(130, 4, 3, 'GRAPPA 40 ml', 18.00, '', 'bucata', '', -159.000, 1, 0.00, '5134065134068', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(131, 4, 3, 'LIMONCELLO 40 ml', 18.00, '', 'bucata', '', -636.000, 1, 0.00, '5952165952166', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(132, 4, 3, 'APEROL 40 ml', 18.00, '', 'bucata', '', -27.000, 1, 0.00, '4158134158138', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(133, 4, 3, 'CAMPARI 40 ml', 18.00, '', 'bucata', '', -20.000, 1, 0.00, '7364117364114', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(134, 4, 3, 'MARTINI DRY ROSSO/BIANCO 40 ml', 18.00, '', 'bucata', '', -100.000, 1, 0.00, '8182218182210', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(135, 4, 3, 'CAMPARI ROSSO/BIANCO 40 ml', 18.00, '', 'bucata', '', -5.000, 1, 0.00, '6388186388186', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(136, 4, 4, 'APEROL SPRITZ  250 ml', 25.00, '', 'bucata', '', -1840.000, 1, 0.00, '7206287206286', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(137, 4, 4, 'CAIPIRINHA  250 ml', 25.00, '', 'bucata', '', -45.000, 1, 0.00, '5412265412262', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(138, 4, 4, 'CAIPRIROSKA 250 ml', 25.00, '', 'bucata', '', -47.000, 1, 0.00, '8618238618236', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(139, 4, 4, 'VODKA MARTINI 80 ml', 25.00, '', 'bucata', '', -34.000, 1, 0.00, '4436344436346', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(140, 4, 4, 'MOJITO 250 ml', 25.00, '', 'bucata', '', -403.000, 1, 0.00, '7642317642318', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(141, 4, 4, 'COSMOPOLITAN 80 ml', 25.00, '', 'bucata', '', -131.000, 1, 0.00, '8460418460414', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(142, 4, 4, 'LONG ISLAND  ICE TEA 250 ml', 25.00, '', 'bucata', '', -124.000, 1, 0.00, '6666396666394', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(143, 4, 4, 'CAMPARI ORANGE 250 ml', 25.00, '', 'bucata', '', -239.000, 1, 0.00, '4872364872366', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(144, 4, 4, 'GREEN APPLE  250 ml', 18.00, '', 'bucata', '', -566.000, 1, 0.00, '5690465690462', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(145, 4, 4, 'WHILD CHERRY 250 ml', 18.00, '', 'bucata', '', -371.000, 1, 0.00, '8896448896440', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(146, 4, 7, 'COCA COLA / FANTA /SPRITE 250 ml', 9.90, '', 'bucata', '', -9119.000, 2, 0.00, '4714544714540', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(147, 4, 7, 'SCHWEPPES 250 ml', 9.90, '', 'bucata', '', -481.000, 2, 0.00, '7920517920512', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(148, 4, 7, 'CAPPY NECTAR 250 ml', 11.90, '', 'bucata', '', -558.000, 2, 0.00, '6126496126490', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(150, 4, 7, 'ACQUA S PELLEGRINO  250 ml', 10.00, '', 'bucata', '', -209.000, 2, 0.00, '5150575150572', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(151, 4, 7, 'ACQUA PANNA 250 ml', 10.00, '', 'bucata', '', -39.000, 2, 0.00, '5968675968672', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(152, 4, 7, 'ACQUA DORNA 330 ml', 8.90, '', 'bucata', '', -1788.000, 2, 0.00, '4174644174642', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(153, 4, 7, 'ACQUA IZVORUL ALB 330 ml', 8.90, '', 'bucata', '', -3282.000, 2, 0.00, '7380627380628', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(154, 4, 7, 'FRESH ARANCIA 250 ml', 15.90, '', 'bucata', '', -1627.000, 2, 0.00, '8198728198726', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(155, 4, 7, 'LIMONATA  500 ml', 14.90, '', 'bucata', '', -3694.000, 2, 0.00, '6404696404694', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(156, 4, 7, 'LIMONATA  MENTA  500 ml', 15.90, '', 'bucata', '', -5400.000, 2, 0.00, '7222797222790', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(157, 4, 7, 'ENERGY DRINK  250 ml', 15.00, '', 'bucata', '', -38.000, 2, 0.00, '5428775428778', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(158, 4, 6, 'DRAUGHT STAROPRAMEN 400 ml', 10.50, '', 'bucata', '', -10441.000, 2, 0.00, '8634748634740', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(159, 4, 6, 'DRAUGHT STELA ARTOIS 400 ml', 12.90, '', 'bucata', '', -7.000, 2, 0.00, '4452854452850', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(160, 4, 6, 'STAROPRAMEN 0,5', 11.50, '', 'bucata', '', -679.000, 1, 0.00, '7658827658824', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(161, 4, 6, 'STAROPRAMEN NEGRU 330 ml', 11.00, '', 'bucata', '', -182.000, 1, 0.00, '8476928476920', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(162, 4, 6, 'STAROPRAMEN NEFILTRATA 330 ml', 11.00, '', 'bucata', '', -231.000, 1, 0.00, '6682906682906', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(163, 4, 6, 'STAROPRAMEN GRANAT 330 ml', 11.00, '', 'bucata', '', -43.000, 1, 0.00, '4888874888872', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(164, 4, 6, 'BECK S 500 ml', 11.50, '', 'bucata', '', -888.000, 1, 0.00, '5706975706972', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(167, 4, 6, 'STELA ARTOIS 500 ml', 13.90, '', 'bucata', '', -2226.000, 1, 0.00, '8912958912958', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(168, 4, 6, 'STELA ARTOIS non alcool 500 ml', 12.50, '', 'bucata', '', -1357.000, 2, 0.00, '4731054731058', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(169, 4, 6, 'LEFFE BLOND 330 ml', 18.90, '', 'bucata', '', -243.000, 1, 0.00, '7937027937022', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(170, 4, 6, 'LEFFE BRUN 330 ml', 18.90, '', 'bucata', '', -122.000, 1, 0.00, '6143006143006', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(171, 4, 6, 'HOEGAARDEN bere alba nefltrata 330 ml', 18.90, '', 'bucata', '', -183.000, 1, 0.00, '6961106961104', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(172, 4, 6, 'BERGENBIER 500 ml', 9.50, '', 'bucata', '', -876.000, 1, 0.00, '5167085167082', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(173, 4, 6, 'BERGENBIER  GRAPEFRUIT/Lemon 500 ml', 10.00, '', 'bucata', '', -168.000, 1, 0.00, '5985185985180', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(174, 4, 6, 'CORONA 330 ml', 16.50, '', 'bucata', '', -444.000, 1, 0.00, '4191154191150', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(175, 4, 5, 'ESPRESSO STRETTO 40 ml', 8.90, '', 'bucata', '', -4647.000, 2, 0.00, '7397137397138', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(176, 4, 5, 'ESPRESSO LUNGO 80 ml', 8.90, '', 'bucata', '', -3134.000, 2, 0.00, '8215238215238', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(177, 4, 5, 'ESPRESSO MACCHIATO  40 ml', 9.50, '', 'bucata', '', -461.000, 2, 0.00, '6421206421200', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(178, 4, 5, 'ESPRESSO DOPIO 80 ml', 15.90, '', 'bucata', '', -465.000, 2, 0.00, '7239307239308', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(179, 4, 5, 'CAPUCCINO 200 ml', 12.00, '', 'bucata', '', -3026.000, 2, 0.00, '5445285445286', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(180, 4, 5, 'CAPUCCINO FREDO 200 ml', 12.00, '', 'bucata', '', -53.000, 2, 0.00, '8651258651258', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(181, 4, 5, 'CAPUCCINO VIENNESE 200 ml', 12.00, '', 'bucata', '', -236.000, 2, 0.00, '4469364469360', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(182, 4, 5, 'LATTE MACCHIATO 250 ml', 15.00, '', 'bucata', '', -984.000, 2, 0.00, '7675337675332', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(183, 4, 5, 'ICE COFFE 160 ml', 13.90, '', 'bucata', '', -139.000, 2, 0.00, '8493438493438', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(184, 4, 5, 'FRAPPE 300 ml', 16.90, '', 'bucata', '', -630.000, 2, 0.00, '6699416699416', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(185, 4, 5, 'IRISH CAFFE 250 ml', 19.00, '', 'bucata', '', -102.000, 2, 0.00, '4905384905384', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(186, 4, 5, 'CIOCCOLATO CALDO 200 ml', 14.90, '', 'bucata', '', -321.000, 2, 0.00, '5723485723480', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(187, 4, 5, 'HOT TEA 100 ml', 14.00, '', 'bucata', '', -1379.000, 2, 0.00, '8929468929468', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(188, 4, 21, 'PANCETA 50 gr', 15.90, '', 'bucata', '', -28.000, 2, 0.00, '4747564747564', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(189, 0, 21, 'Sos rosii picant', 4.90, '', 'bucata', '', -1390.000, 2, 0.00, '7953537953536', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(190, 0, 14, 'Zupa del giorno', 15.90, '', 'bucata', '', -391.000, 2, 0.00, '6159516159512', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(191, 0, 17, 'Zuppa di pesce 450gr', 55.90, '', 'bucata', '', -892.000, 2, 0.00, '6977616977610', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(192, 0, 16, 'Scalopina al limone 200gr', 37.90, '', 'bucata', '', -17.000, 2, 0.00, '5183595183596', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(193, 0, 15, 'Lasagna 400gr', 38.90, '', 'bucata', '', -1638.000, 2, 0.00, '6001696001696', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(194, 0, 21, 'Extra creveti 60gr', 19.90, '', 'bucata', '', -106.000, 2, 0.00, '4207664207660', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(195, 0, 17, 'Gamberetti a la griglia 220gr', 59.90, '', 'bucata', '', -188.000, 2, 0.00, '7413647413646', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(196, 0, 16, 'Tagliata ai funghi porcini 260gr', 59.90, '', 'bucata', '', -598.000, 2, 0.00, '8231748231742', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(197, 0, 16, 'Tacchino Il Peccato 250gr', 40.90, '', 'bucata', '', -1073.000, 2, 0.00, '6437716437716', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(198, 0, 16, 'Filetto al gorgonzola 270gr', 62.90, '', 'bucata', '', -657.000, 2, 0.00, '7255817255812', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(199, 0, 21, 'Ciuperci 50gr', 6.00, '', 'bucata', '', -187.000, 2, 0.00, '5461795461790', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(200, 0, 15, 'Tagliatelle alla Bolognese 280gr', 38.90, '', 'bucata', '', -1372.000, 2, 0.00, '8667768667764', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(201, 0, 8, 'Carafa 0,5 l', 33.00, '', 'bucata', '', -4745.000, 1, 0.00, '4485874485874', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1);
INSERT INTO `TProduse` (`ID`, `Prioritate`, `IDSubCategorie`, `Denumire`, `Pret`, `Imagine`, `UM`, `Compozitie`, `Stoc`, `TVA`, `PretAchizitie`, `CodBare`, `LimitaStoc`, `CodPlu`, `Pret2`, `StocMinim`, `Complex`, `Sizeable`, `OnlineSync`, `HasAssociated`, `HasExpirationDate`, `MateriePrima`, `WebProductId`, `TVAL`, `TVAF`, `AdaosNIR`, `Descriere`, `Discount`, `IdTopping`, `IdOptiuniMeniu`, `CantitateOptiuni`, `LotIntern`, `LotProducator`, `DataProductie`, `DataExpirare`, `TempPastrare`, `TaraOrigine`, `Added`, `UserId`, `Deleted`, `Greutate`, `Active`) VALUES
(202, 0, 8, 'Vin fiert 250ml', 18.00, '', 'bucata', '', -531.000, 1, 0.00, '7691847691846', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(203, 0, 8, 'Proseco Villa Sandi alb 150 ml', 24.00, '', 'bucata', '', -1151.000, 1, 0.00, '8509948509948', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(204, 0, 8, 'Chianti Placido 150 ml', 17.90, '', 'bucata', '', -530.000, 1, 0.00, '6715926715924', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(206, 0, 15, 'Lasagne ai frutti di mare 400gr', 42.90, '', 'bucata', '', -762.000, 2, 0.00, '4921894921898', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(207, 0, 21, 'Tartufo 25gr', 13.90, '', 'bucata', '', -14.000, 1, 0.00, '5739995739996', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(208, 4, 13, 'CAPRESE CON MOZZARELLA DI  BUFALA 180 gr', 27.90, '', 'bucata', '', -545.000, 2, 0.00, '8945978945972', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(209, 0, 21, 'JULIEN VITA 50GR', 15.00, '', 'bucata', '', -61.000, 2, 0.00, '4764074764072', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(210, 0, 21, 'Mozzarela 50gr', 11.00, '', 'bucata', '', -66.000, 2, 0.00, '7970047970044', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(211, 0, 21, 'Extra q.formaggi 80gr', 13.90, '', 'bucata', '', -1.000, 2, 0.00, '6176026176020', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(212, 0, 19, 'Pizza Bufalina 410gr', 32.90, '', 'bucata', '', -130.000, 2, 0.00, '6994126994128', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(213, 0, 21, 'Extra pasta 50gr', 10.00, '', 'bucata', '', -26.000, 2, 0.00, '5200105200106', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(214, 4, 18, 'VERDURE ALLA GRIGLIA 120 gr', 18.50, '', 'bucata', '', -928.000, 2, 0.00, '6018206018204', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(216, 0, 14, 'Insalata di polipo 125gr', 37.90, '', 'bucata', '', 0.000, 2, 0.00, '4224174224178', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(217, 0, 5, 'Espresso Corretto 60ml', 10.90, '', 'bucata', '', -66.000, 2, 0.00, '7430157430154', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(218, 4, 7, 'Dorna/Izvorul Alb 0,75l', 15.90, '', 'bucata', '', -17910.000, 2, 0.00, '8248258248252', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(219, 0, 2, 'Beluga 40ml', 30.00, '', 'bucata', '', -63.000, 1, 0.00, '6454226454224', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(220, 4, 17, 'Tentacoli di calamaro 225gr', 42.90, '', 'bucata', '', -458.000, 2, 0.00, '7272327272320', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(221, 0, 21, 'Extra crostina 40gr', 7.50, '', 'bucata', '', -3.000, 2, 0.00, '5478305478308', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(222, 4, 8, 'Consumabile', 1.00, '', 'bucata', '', -27830.000, 1, 0.00, '8684278684272', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(224, 0, 14, 'Insalata rucola 90gr', 16.50, '', 'bucata', '', -726.000, 2, 0.00, '4502384502386', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(225, 0, 14, 'Salata varza 150gr', 14.00, '', 'bucata', '', -697.000, 2, 0.00, '7708357708350', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(226, 0, 15, 'Penne alla arabiata 200gr', 34.90, '', 'bucata', '', -516.000, 2, 0.00, '8526458526456', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(227, 0, 21, 'Extra somon 50gr', 14.00, '', 'bucata', '', -28.000, 2, 0.00, '6732436732432', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(228, 0, 3, 'Rachiu 40ml', 18.00, '', 'bucata', '', -110.000, 1, 0.00, '4938404938406', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(229, 4, 3, 'Palinca 40 ml', 18.00, '', 'bucata', '', -298.000, 1, 0.00, '5756505756502', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(230, 0, 19, 'Pizza Modenese 410gr', 39.90, '', 'bucata', '', -222.000, 2, 0.00, '8962488962480', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(231, 4, 15, 'Pappardelle porcini e salsiccia 250 gr', 42.90, '', 'bucata', '', -825.000, 2, 0.00, '4780584780586', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(232, 4, 9, 'CHIANTI POLIZIANO   750 ml', 115.00, '', 'bucata', '', -32.000, 1, 0.00, '7986557986550', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(233, 0, 9, 'RONCHEDONE Ca dei Frati 0,75l ', 196.00, '', 'bucata', '', -5.000, 1, 0.00, '6192536192534', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(234, 0, 9, 'Rosso di Montalcino 750ml', 169.00, '', 'bucata', '', -10.000, 1, 0.00, '7010637010634', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(235, 0, 9, 'Brunello di Montalcino 750ml', 359.00, '', 'bucata', '', -5.000, 1, 0.00, '5216605216608', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(236, 0, 9, 'Chianti Placido 750ml', 70.00, '', 'bucata', '', -51.000, 1, 0.00, '6034716034718', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(237, 0, 10, 'Ca dei Frati rose  0,75l', 149.00, '', 'bucata', '', -47.000, 1, 0.00, '4240684240682', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(239, 0, 10, 'Banfi Ca Lunghetta Pinot Grigio 0,75l', 77.00, '', 'bucata', '', -37.000, 1, 0.00, '8264768264766', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(240, 0, 10, 'Proseco Villa Sandi rose 0,75l', 99.00, '', 'bucata', '', -144.000, 1, 0.00, '6470736470738', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(241, 4, 11, 'GRECO DI TUFO  750 ml    ', 148.00, '', 'bucata', '', -142.000, 1, 0.00, '7288837288836', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(244, 4, 11, 'Banfi Fumaio750 ml    ', 89.00, '', 'bucata', '', -131.000, 1, 0.00, '5494815494812', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(246, 4, 11, ' Proseco Villa Sandi alb 750 ml', 99.00, '', 'bucata', '', -181.000, 1, 0.00, '4518884518888', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(247, 0, 8, 'Regno Recas Sauvignon Blanc alb sec 150ml', 17.50, '', 'bucata', '', -564.000, 1, 0.00, '7724867724864', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(248, 0, 8, 'Regno Recas ROSE demisec 150ml', 17.50, '', 'bucata', '', -640.000, 1, 0.00, '8542968542960', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(249, 0, 8, 'Regno Recas Pinot Noir rosu sec 150ml', 17.50, '', 'bucata', '', -384.000, 1, 0.00, '6748946748948', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(250, 0, 12, 'Regno Recas Sauvignon Blanc alb sec 0,75l', 70.00, '', 'bucata', '', -374.000, 1, 0.00, '4954914954910', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(251, 0, 12, 'Regno Recas Pinot Grigio alb sec 0,75l', 70.00, '', 'bucata', '', -421.000, 1, 0.00, '5773015773010', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(252, 0, 12, 'Regno Recas ROSE demisec 0,75l', 70.00, '', 'bucata', '', -567.000, 1, 0.00, '8978998978996', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(253, 0, 12, 'Regno Recas Pinot Noir rosu sec 0,75l', 70.00, '', 'bucata', '', -234.000, 1, 0.00, '4797094797096', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(254, 0, 12, 'Regno Recas Syrah  rosu sec 0,75l', 70.00, '', 'bucata', '', -297.000, 1, 0.00, '8003068003060', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(255, 0, 12, 'Sole Chardonnay alb sec 0,75l', 125.00, '', 'bucata', '', -690.000, 1, 0.00, '6209046209048', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(256, 0, 12, 'Sole Roze sec 0,75l', 125.00, '', 'bucata', '', -325.000, 1, 0.00, '7027147027144', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(257, 0, 12, 'Selene sec 0,75l', 146.00, '', 'bucata', '', -268.000, 1, 0.00, '5233115233116', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(258, 4, 19, 'PIZZA Contadina 540 gr', 46.90, '', 'bucata', '', -903.000, 2, 0.00, '6051226051226', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(259, 4, 13, 'Mortadella 50gr', 16.90, '', 'bucata', '', -523.000, 2, 0.00, '4257194257192', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(260, 4, 13, 'Pancetta 50gr', 15.90, '', 'bucata', '', -163.000, 2, 0.00, '7463177463178', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(261, 4, 14, 'INSALATA DI MARE 275 gr', 39.90, '', 'bucata', '', -474.000, 2, 0.00, '8281278281274', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(262, 4, 4, 'Long DRINKS  250 ml', 25.00, '', 'bucata', '', -670.000, 1, 0.00, '6487246487248', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(266, 0, 21, ' Extra parmesan 30gr', 7.00, '', 'bucata', '', -131.000, 2, 0.00, '7305347305348', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(268, 0, 12, 'RECAS Solo Quinta 0,75 l', 165.00, '', 'bucata', '', -477.000, 1, 0.00, '5511325511324', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(269, 4, 20, 'Tortul casei 150 gr', 23.90, '', 'bucata', '', -1866.000, 2, 0.00, '8717298717290', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(270, 4, 22, 'PIZZA Contadina H  540 gr', 23.90, '', 'bucata', '', -243.000, 2, 0.00, '4535394535396', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(271, 0, 22, 'Pizza Modenese H 410gr', 22.90, '', 'bucata', '', -154.000, 2, 0.00, '7741377741372', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(272, 0, 16, 'T Bonne (sange) 430/480gr', 92.90, '', 'bucata', '', -41.000, 2, 0.00, '8559478559470', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(273, 0, 16, 'T Bonne (mediu) 430/480gr', 92.90, '', 'bucata', '', -280.000, 2, 0.00, '6765456765456', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(274, 0, 16, 'T Bonne (bine facut) 430/480gr', 92.90, '', 'bucata', '', -42.000, 2, 0.00, '4971424971428', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(275, 0, 8, 'Inghetata 90gr', 10.90, '', 'bucata', '', -4020.000, 2, 0.00, '5789525789526', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(276, 0, 5, 'illycrema 100gr', 13.00, '', 'bucata', '', -1.000, 2, 0.00, '8995508995502', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(277, 0, 5, 'illycrema duetto 100gr', 10.00, '', 'bucata', '', 0.000, 2, 0.00, '4813604813602', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(278, 0, 5, 'illycrema trio 100gr', 13.00, '', 'bucata', '', 0.000, 2, 0.00, '8019578019576', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(279, 4, 16, 'Costine di maiale al forno 600 gr', 72.90, '', 'bucata', '', -454.000, 2, 0.00, '6225556225552', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(283, 0, 23, 'Insalata il peccato H 250gr', 17.90, '', 'bucata', '', -1437.000, 2, 0.00, '7043657043658', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(284, 0, 23, 'Spaghetti di mare H 320gr', 26.90, '', 'bucata', '', -2482.000, 2, 0.00, '5249625249622', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(285, 0, 23, 'Spaghetti  Carbonara H 200gr', 22.90, '', 'bucata', '', -1590.000, 2, 0.00, '6067736067732', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(286, 0, 23, 'Tagliatelle alla Bolognese H 280gr', 22.90, '', 'bucata', '', -972.000, 2, 0.00, '6067734273708', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(288, 0, 22, 'Focaccia sare de mare H 280 gr', 6.90, '', 'bucata', '', -77.000, 2, 0.00, '4273704273704', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(289, 0, 22, 'Focaccia aglio  H 280 gr', 6.90, '', 'bucata', '', -73.000, 2, 0.00, '7479687479684', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(290, 0, 22, 'Focaccia rozmarin H 280 gr', 6.90, '', 'bucata', '', -15.000, 2, 0.00, '8297788297780', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(291, 0, 22, 'Focaccia parmigiano H 280 gr', 6.90, '', 'bucata', '', -339.000, 2, 0.00, '6503756503756', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(295, 0, 17, 'SPIGOLA 300/400gr', 50.90, '', 'bucata', '', -425.000, 2, 0.00, '7321857321852', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(296, 0, 19, 'Pizza  mortadella  e burrata 585gr', 57.90, '', 'bucata', '', -36.000, 2, 0.00, '5527835527830', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(297, 0, 19, 'Pizza  crudo e burrata 585gr', 57.90, '', 'bucata', '', -2764.000, 2, 0.00, '8733808733802', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(299, 0, 8, 'Mic dejun', 60.00, '', 'bucata', '', -425.000, 2, 0.00, '4551904551908', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(300, 0, 15, 'RiSOTTO  PORCINI E TARTUFO 250gr', 41.90, '', 'bucata', '', -2394.000, 2, 0.00, '7757887757888', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(301, 0, 13, 'Melanzane vegetariane 200gr', 25.00, '', 'bucata', '', 0.000, 2, 0.00, '8575988575984', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(302, 0, 8, 'Budureasca roze 150 ml', 14.90, '', 'bucata', '', -723.000, 1, 0.00, '6781966781960', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(303, 0, 8, 'Budureasca rosu 150 ml', 14.90, '', 'bucata', '', -501.000, 1, 0.00, '4987934987934', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(304, 0, 8, 'Budureasca alb 150 ml', 14.90, '', 'bucata', '', -649.000, 1, 0.00, '5806035806038', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(305, 0, 4, 'Shoot 40 ml', 18.00, '', 'bucata', '', -148.000, 1, 0.00, '9012019012012', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(306, 4, 19, 'FOCACCIEA usturoi parmezan 280 gr', 14.90, '', 'bucata', '', -1987.000, 2, 0.00, '4830114830110', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(307, 0, 20, 'Croissant grande 35gr', 8.50, '', 'bucata', '', -334.000, 2, 0.00, '8036088036084', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(308, 0, 5, 'Lapte 150 ml', 5.00, '', 'bucata', '', -29.000, 2, 0.00, '6242066242060', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(309, 0, 24, 'Omleta simpla 90gr', 15.00, '', 'bucata', '', -8.000, 2, 0.00, '7060167060166', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(310, 0, 24, 'Omleta sunca si cascaval 120gr', 17.90, '', 'bucata', '', -11.000, 2, 0.00, '5266135266130', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(311, 0, 24, 'Omleta cu legume 120gr', 17.90, '', 'bucata', '', -6.000, 2, 0.00, '6084246084240', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(312, 0, 24, 'Ou 45gr', 7.00, '', 'bucata', '', -19.000, 1, 0.00, '4290214290212', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(313, 0, 24, 'Sunca 25 gr', 6.00, '', 'bucata', '', -1.000, 1, 0.00, '7496197496192', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(314, 0, 24, 'Prosciutto 25 gr', 6.50, '', 'bucata', '', 0.000, 2, 0.00, '8314298314292', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(315, 0, 24, 'Carnati bere 25 gr', 6.00, '', 'bucata', '', 0.000, 2, 0.00, '6520266520264', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(316, 0, 24, 'Bacon 25 gr', 6.50, '', 'bucata', '', 0.000, 2, 0.00, '7338367338362', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(317, 0, 24, 'Gorgonzola 25 gr', 6.50, '', 'bucata', '', 0.000, 2, 0.00, '5544345544348', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(318, 0, 24, 'Ementaler 25 gr', 6.50, '', 'bucata', '', -2.000, 2, 0.00, '8750318750310', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(319, 0, 24, 'Chifla 20gr', 3.00, '', 'bucata', '', 0.000, 2, 0.00, '4568414568418', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(320, 0, 24, 'Cereale 30gr', 7.00, '', 'bucata', '', 0.000, 2, 0.00, '7774397774396', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(321, 0, 24, 'LAPTE 120ml', 5.00, '', 'bucata', '', -6.000, 2, 0.00, '8592498592492', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(322, 0, 24, 'MIERE 6gr', 4.00, '', 'bucata', '', -3.000, 2, 0.00, '6798476798470', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(323, 0, 24, 'Dulceata 6gr', 4.00, '', 'bucata', '', 0.000, 2, 0.00, '5004445004444', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(324, 0, 24, 'Nutella 6gr', 6.50, '', 'bucata', '', 0.000, 2, 0.00, '5822545822542', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(325, 0, 24, 'Fructe 70gr', 6.50, '', 'bucata', '', 0.000, 2, 0.00, '9028529028528', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(326, 0, 24, 'Fructe uscate 25gr', 6.50, '', 'bucata', '', 0.000, 2, 0.00, '4846624846626', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(327, 0, 24, 'Croisant 25gr mare', 8.50, '', 'bucata', '', -13.000, 2, 0.00, '8052598052598', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(328, 0, 24, 'Fresh portocale 100 ml', 13.00, '', 'bucata', '', 0.000, 2, 0.00, '6258576258576', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(333, 0, 20, 'Platou fructe 400gr', 60.00, '', 'bucata', '', -4.000, 2, 0.00, '7076677076672', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(334, 0, 20, 'Tort nutellotto 130gr', 25.90, '', 'bucata', '', -3413.000, 2, 0.00, '5282645282644', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(337, 4, 21, 'pui 100 gr', 9.90, '', 'bucata', '', -62.000, 2, 0.00, '6100756100758', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(338, 0, 13, 'Parmigiano di zucchine 150gr', 25.00, '', 'bucata', '', -1.000, 2, 0.00, '4306724306722', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(339, 0, 13, 'Melanzane al funghetto 200gr', 19.50, '', 'bucata', '', 0.000, 2, 0.00, '7512707512708', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(340, 0, 17, 'Filetto di spigola al limone 280 gr', 57.90, '', 'bucata', '', -1531.000, 2, 0.00, '8330808330804', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(342, 0, 15, 'Linguine agli scampi 280gr', 53.90, '', 'bucata', '', -1000.000, 2, 0.00, '6536776536770', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(343, 0, 14, 'Salata mista 200gr', 17.90, '', 'bucata', '', -1467.000, 2, 0.00, '7354877354876', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(344, 0, 14, 'Insalata di Tonno 250gr', 29.90, '', 'bucata', '', -392.000, 2, 0.00, '5560855560852', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(345, 0, 14, 'Insalata Estiva 200gr', 23.90, '', 'bucata', '', -429.000, 2, 0.00, '8766828766826', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(346, 0, 12, 'Negrini Sauv Blanc 0,75l', 75.00, '', 'bucata', '', -1166.000, 1, 0.00, '4584924584922', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(347, 0, 12, 'Negrini ROSE 0,75l', 75.00, '', 'bucata', '', -967.000, 1, 0.00, '7790907790908', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(348, 0, 12, 'Negrini Merlot 0,75l', 75.00, '', 'bucata', '', -523.000, 1, 0.00, '8609008609004', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(349, 0, 11, 'Banfi Ca Lunghetta Pinot Grigio 0,75l', 72.00, '', 'bucata', '', -87.000, 1, 0.00, '6814986814988', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(350, 4, 11, 'Aragosta Santa Maria 750 ml', 95.00, '', 'bucata', '', -22.000, 1, 0.00, '5020955020958', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(351, 4, 11, 'Moet 750 ml', 450.00, '', 'bucata', '', -6.000, 1, 0.00, '5839055839052', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(352, 4, 11, 'Moet 200ml', 115.00, '', 'bucata', '', -3.000, 1, 0.00, '9045039045036', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(353, 0, 9, 'Lambrusco Frizzante 0,75l', 55.00, '', 'bucata', '', -473.000, 1, 0.00, '4863134863134', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(355, 0, 9, 'Testarossa Montepulciano 0,75l', 176.00, '', 'bucata', '', -110.000, 1, 0.00, '6275086275084', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(356, 0, 9, 'Sangiovese Toscano 0,75l', 97.00, '', 'bucata', '', -127.000, 1, 0.00, '7093187093180', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(357, 0, 9, 'Ripaso Pariondo Valpolicella 0,75l', 147.00, '', 'bucata', '', -136.000, 1, 0.00, '5299155299154', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(359, 0, 8, 'Lambrusco150 ml', 14.00, '', 'bucata', '', -364.000, 1, 0.00, '4323234323230', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(360, 0, 8, 'Negrini alb 150 ml', 18.90, '', 'bucata', '', -1663.000, 1, 0.00, '7529217529218', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(361, 0, 8, 'Negrini rose 150 ml', 18.90, '', 'bucata', '', -1194.000, 1, 0.00, '8347318347314', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(362, 0, 8, 'Negrini rosu 150 ml', 18.90, '', 'bucata', '', -1096.000, 1, 0.00, '6553286553288', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(363, 0, 2, 'Havana Club 40ml', 16.00, '', 'bucata', '', -53.000, 1, 0.00, '7371387371384', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(364, 4, 13, 'BRUSCHETTA CON MOZZARELLA E ACCIUGHE  110 gr', 25.90, '', 'bucata', '', -40.000, 2, 0.00, '5577365577362', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(368, 4, 13, 'BURRATINA 125 gr', 17.00, '', 'bucata', '', -100.000, 2, 0.00, '4601434601434', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(369, 4, 6, 'STELA ARTOIS non alcool 330 ml', 9.50, '', 'bucata', '', -19.000, 1, 0.00, '7807417807412', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(370, 4, 18, 'RISOTTO CON VERDURE 200 gr', 23.90, '', 'bucata', '', -15.000, 2, 0.00, '8625518625518', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(372, 0, 20, 'Croissant grande nutella 40gr', 13.00, '', 'bucata', '', -115.000, 2, 0.00, '6831496831496', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(373, 0, 10, 'Cerasuolo D Abruzzo  750ml', 65.00, '', 'bucata', '', -40.000, 1, 0.00, '5037465037468', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(374, 0, 8, 'Taxa dop', 50.00, '', 'bucata', '', -4.000, 2, 0.00, '5855565855566', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(375, 0, 13, 'Platou branzeturi 230gr', 42.00, '', 'bucata', '', -34.000, 2, 0.00, '9061549061540', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(376, 0, 8, 'Mic dejun Hotel', 65.00, '', 'bucata', '', -12.000, 2, 0.00, '4879644879640', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(377, 4, 13, 'CARPACCIO DI SPIGOLA 140 gr', 38.90, '', 'bucata', '', 0.000, 2, 0.00, '8085618085610', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(379, 0, 24, 'Oua benedict 75gr', 19.00, '', 'bucata', '', -5.000, 2, 0.00, '7109697109690', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(381, 0, 23, 'Tacchino Il Peccato al Forno 250gr', 25.90, '', 'bucata', '', -1672.000, 2, 0.00, '5315665315662', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(382, 4, 16, 'Salsiccia 300gr', 39.90, '', 'bucata', '', -26.000, 2, 0.00, '6133776133772', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(383, 0, 16, 'Porchetta 250gr', 39.90, '', 'bucata', '', 0.000, 2, 0.00, '4339744339746', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(385, 0, 24, 'Rulourii 35gr', 8.00, '', 'bucata', '', 0.000, 2, 0.00, '7545727545722', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(386, 0, 24, 'COFFEE BRAKE', 30.00, '', 'bucata', '', -36.000, 2, 0.00, '8363828363828', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(387, 0, 20, 'Torrone al cioccolato e nocciole 55gr ', 18.90, '', 'bucata', '', -177.000, 2, 0.00, '6569796569794', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(388, 4, 13, 'CARPACCIO IL PECCATO 140 gr', 49.00, '', 'bucata', '', -1.000, 2, 0.00, '7387897387890', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(389, 0, 17, 'Grigliata mista di pesce 400gr', 72.90, '', 'bucata', '', -1885.000, 2, 0.00, '5593875593876', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(391, 0, 21, 'Extra salsiccia 80gr', 14.90, '', 'bucata', '', -49.000, 2, 0.00, '4617944617940', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(396, 0, 23, 'Vitello da latte al Forno 300gr', 26.90, '', 'bucata', '', -1441.000, 2, 0.00, '7823927823926', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(397, 0, 8, 'Sorbeto al limone 90ml', 14.00, '', 'bucata', '', -1122.000, 2, 1.00, '8642028642026', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(398, 0, 13, 'Antipasto pesce 70gr', 38.90, '', 'bucata', '', -11.000, 2, 1.00, '6848006848004', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(399, 0, 21, 'Gamberoni 30gr', 12.90, '', 'bucata', '', -217.000, 2, 1.00, '5053975053972', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(401, 0, 14, 'Salata cstraveti murati 110gr', 12.90, '', 'bucata', '', -259.000, 2, 0.00, '9078059078050', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(402, 0, 8, 'TIPS 1/SERVIZIO', 1.00, '', 'bucata', '', -1492.000, 1, 1.00, '4896154896158', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(403, 0, 8, 'TIPS 5/SERVIZIO', 5.00, '', 'bucata', '', -650.000, 1, 1.00, '8102128102122', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(404, 0, 8, 'TIPS 10/SERVIZIO', 10.00, '', 'bucata', '', -4571.000, 1, 10.00, '6308106308100', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(405, 0, 8, 'Cerasuo D Abruzzo 150 ML', 16.00, '', 'bucata', '', -203.000, 1, 25.00, '7126207126206', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(407, 4, 24, ' MIC DEJUN ', 59.00, '', 'bucata', '', -17.000, 2, 0.00, '5208055208050', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(408, 4, 24, 'CONSUMABILE nu folositi', 1.00, '', 'bucata', '', -322.000, 1, 0.00, '7261907261908', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(409, 0, 23, 'Crostini toscani 110gr', 15.90, '', 'bucata', '', -589.000, 2, 0.00, '6150286150280', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(451, 0, 26, 'STELLA ARTOIS 0,33L', 9.90, '', 'bucata', '', -6.000, 1, 1.00, '4356254356254', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(452, 0, 26, 'STELLA ARTOIS FARA ALCOOL 0,33L', 10.90, '', 'bucata', '', 0.000, 2, 0.00, '7562237562230', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(453, 0, 26, 'STAROPRAMEN 0,33L', 9.90, '', 'bucata', '', 0.000, 1, 0.00, '8380338380336', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(454, 0, 26, 'COCA COLA -FANTA-SPRITE 0,33L', 8.00, '', 'bucata', '', -6.000, 2, 0.00, '6586306586300', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(458, 4, 6, 'STELA ARTOIS 330 ml', 9.90, '', 'bucata', '', -48.000, 1, 0.00, '7404407404400', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(459, 0, 9, 'SAN MARZANO-TALO 0,75l', 125.00, '', 'bucata', '', -256.000, 1, 0.00, '5610385610388', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(460, 0, 13, 'Carpaccio di polpo 135 gr', 41.00, '', 'bucata', '', -417.000, 2, 0.00, '8816358816352', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(461, 0, 11, 'Pecorino DOP Pasetti 750 ml', 99.00, '', 'bucata', '', -130.000, 1, 0.00, '4634454634458', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(462, 0, 10, 'San Marzano Tramari rose di Primitivo  750ml', 97.00, '', 'bucata', '', -142.000, 1, 0.00, '7840437840434', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(463, 0, 9, 'Montepulciano D Abrozzo 0,75l', 84.00, '', 'bucata', '', -153.000, 1, 0.00, '8658538658532', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(464, 4, 6, 'Miller 330 ml', 14.00, '', 'bucata', '', -94.000, 1, 0.00, '6864516864518', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(466, 4, 6, 'Franziskaner NRGB Nefiltrat 500 ml', 19.90, '', 'bucata', '', -390.000, 1, 0.00, '5070485070480', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(467, 4, 6, 'Franziskaner dark Nefiltrat 500 ml', 19.90, '', 'bucata', '', -163.000, 1, 0.00, '5888585888580', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(468, 0, 8, 'Greco di tufo alb 150 ml', 30.00, '', 'bucata', '', -355.000, 1, 0.00, '9094569094564', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(469, 0, 9, 'Amarone della Valpolicella 0,75l', 415.00, '', 'bucata', '', -8.000, 1, 1.00, '4912664912666', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(470, 0, 23, 'COZZE H 400gr', 23.90, '', 'bucata', '', -880.000, 2, 0.00, '8118638118638', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(471, 0, 23, 'Bruschette al pomodoro', 11.90, '', 'bucata', '', -706.000, 2, 0.00, '6324616324614', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(472, 0, 8, 'Masca chirurgicala', 5.00, '', 'bucata', '', -69.000, 1, 1.00, '7142717142710', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(473, 4, 4, 'HUGO  250 ml', 25.00, '', 'bucata', '', -478.000, 1, 0.00, '5348685348686', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(474, 0, 17, 'TON ROSU 250 G', 94.00, '', 'bucata', '', -1138.000, 2, 0.00, '6166796166796', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(475, 0, 23, 'Caprese', 15.90, '', 'bucata', '', -606.000, 2, 0.00, '4372764372768', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(476, 0, 23, 'Lazagna', 23.90, '', 'bucata', '', -779.000, 2, 0.00, '7578737578732', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(477, 4, 23, 'Carpaccio di vitello', 22.90, '', 'bucata', '', -42.000, 2, 0.00, '8396848396842', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(478, 4, 17, 'ORATA 600 gr', 63.00, '', 'bucata', '', -82.000, 2, 0.00, '6602816602818', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(479, 4, 17, 'STRIDII', 12.90, '', 'bucata', '', -8.000, 2, 0.00, '7420917420914', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(480, 4, 17, 'CARACATITA 700 G', 210.00, '', 'bucata', '', -1.000, 2, 0.00, '5626895626894', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(482, 0, 15, 'Risotto porcini e salsccea 280 gr', 42.90, '', 'bucata', '', -1470.000, 2, 0.00, '8832868832866', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(483, 0, 8, 'Taxa livrare[zona 1]', 6.90, '', 'bucata', '', -2.000, 1, 1.00, '4650964650962', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1);
INSERT INTO `TProduse` (`ID`, `Prioritate`, `IDSubCategorie`, `Denumire`, `Pret`, `Imagine`, `UM`, `Compozitie`, `Stoc`, `TVA`, `PretAchizitie`, `CodBare`, `LimitaStoc`, `CodPlu`, `Pret2`, `StocMinim`, `Complex`, `Sizeable`, `OnlineSync`, `HasAssociated`, `HasExpirationDate`, `MateriePrima`, `WebProductId`, `TVAL`, `TVAF`, `AdaosNIR`, `Descriere`, `Discount`, `IdTopping`, `IdOptiuniMeniu`, `CantitateOptiuni`, `LotIntern`, `LotProducator`, `DataProductie`, `DataExpirare`, `TempPastrare`, `TaraOrigine`, `Added`, `UserId`, `Deleted`, `Greutate`, `Active`) VALUES
(484, 0, 8, 'Taxa livrare[zona2]', 11.90, '', 'bucata', '', -1.000, 1, 0.00, '7856947856940', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(485, 4, 16, 'Antricot fara os 400 gr', 54.90, '', 'bucata', '', 0.000, 2, 0.00, '8675048675040', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(486, 4, 17, 'GAMBERONI ALLA GRIGLIA 180 GR', 59.90, '', 'bucata', '', -14.000, 2, 0.00, '6881026881026', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(487, 4, 27, 'test', 0.10, '', 'bucata', '', 0.000, 1, 0.00, '6183576183576', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(488, 4, 16, 'Saltimbocca alla romana 300 gr', 57.00, '', 'bucata', '', -75.000, 2, 0.00, '4426414426414', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(489, 4, 19, 'FOCACCIEA SPECIALE 280 gr', 22.00, '', 'bucata', '', -207.000, 2, 0.00, '6220436220436', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(490, 0, 15, 'Tagliatelle Astice 325 gr', 132.00, '', 'bucata', '', -170.000, 2, 0.00, '5402335402330', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(491, 0, 13, 'Salmone marinato 150gr', 38.00, '', 'grame', '', -39.000, 2, 1.00, '7196367196364', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(492, 4, 13, 'BRUSCHETTA  ACCIUGHE  110 gr', 26.90, '', 'bucata', '', -78.000, 2, 0.00, '8990388990388', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(493, 0, 7, 'Crodino 0,175 l', 15.00, '', 'bucata', '', -42.000, 2, 0.00, '8172288172280', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(494, 0, 8, 'Talo Primitivo 150ml', 28.90, '', 'bucata', '', -347.000, 1, 1.00, '4966314966318', 1.000, '1', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(495, 0, 7, 'Tea Lemon 250ml', 9.90, '', 'bucata', '', -225.000, 2, 0.00, '4286114286110', 0.000, '0', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(496, 0, 7, 'Tea Peach 250ml', 9.90, '', 'bucata', '', -376.000, 2, 0.00, '4443944443940', 0.000, '0', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(497, 0, 10, 'Remole Toscana Frescobaldi 0,75l', 90.00, '', 'bucata', '', -6.000, 1, 1.00, '6237966237964', 0.000, '0', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(498, 4, 11, 'Vermentino Toscano  750 ml    ', 99.00, '', 'bucata', '', -183.000, 1, 1.00, '8031998031990', 0.000, '0', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(499, 4, 11, 'Scaia Garganega  Chardonnay 750 ml    ', 123.00, '', 'bucata', '', -135.000, 1, 1.00, '7213887213880', 0.000, '0', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(500, 0, 13, 'Alici marinate 70gr', 24.00, '', 'bucata', '', -2.000, 2, 1.00, '9007919007916', 0.000, '0', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(501, 4, 13, 'Crostini burrata e gamberi150  gr', 34.90, '', 'bucata', '', -254.000, 2, 0.00, '5801945801944', 0.000, '0', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(502, 0, 24, 'unt 5 gr', 5.00, '', 'bucata', '', -3.000, 2, 0.00, '', 0.000, '0', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(503, 0, 24, 'SANDWISH 60gr', 12.00, '', 'bucata', '', 0.000, 2, 1.00, '', 0.000, '0', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(504, 0, 24, 'Croisant 17gr mic', 6.00, '', 'bucata', '', -16.000, 2, 0.00, '', 0.000, '0', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(505, 4, 17, 'SOMON 250GR', 59.90, '', 'bucata', '', -14.000, 2, 1.00, '', 0.000, '0', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(506, 0, 20, 'Strudel mere cu inghetata 240gr', 23.90, '', 'bucata', '', -10.000, 2, 1.00, '', 0.000, '0', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(507, 0, 16, 'Tagliata ARGENTINA 260gr', 90.00, '', 'bucata', '', -564.000, 2, 0.00, '', 0.000, '0', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1),
(508, 0, 13, 'Antipasto Il Peccato 250gr', 70.00, '', 'portie', '', -2.000, 2, 1.00, '', 0.000, '0', 0.00, 0.000, 0, 0, -1, 0, 0, 0, -1, 1, 1, 0.00, '', 0.00, -1, 0, 1, '-1', '-1', NULL, NULL, '0.00', '-', '2023-02-10 10:55:13', 0, 0, 0.000, 1);

--
-- Triggers `TProduse`
--
DELIMITER $$
CREATE TRIGGER `LogDelete` BEFORE DELETE ON `TProduse` FOR EACH ROW BEGIN
	INSERT INTO ProductHistory (ProdusId, WebProductId, IDSubCategorie, TVA, TVAL, TVAF, Denumire, 
                                Descriere, CodBare, CodPlu, Pret, AdaosNIR, PretAchizitie, Stoc, UM, 
                                MateriePrima, OnlineSync, Complex, Sizeable, Action) VALUES 
                (OLD.ID, OLD.WebProductId, OLD.IDSubCategorie, OLD.TVA, OLD.TVAL, OLD.TVAF, OLD.Denumire, 
                 OLD.Descriere, OLD.CodBare, OLD.CodPlu, OLD.Pret, OLD.AdaosNIR, OLD.PretAchizitie, OLD.Stoc, 
                 OLD.UM, OLD.MateriePrima, OLD.OnlineSync, OLD.Complex, OLD.Sizeable, 2);
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `LogUpdate` BEFORE UPDATE ON `TProduse` FOR EACH ROW BEGIN
    IF NEW.Stoc = OLD.Stoc AND (NEW.Complex = 0 OR NEW.PretAchizitie = OLD.PretAchizitie) THEN
        INSERT INTO ProductHistory (ProdusId, WebProductId, IDSubCategorie, TVA, TVAL, TVAF, Denumire, 
                                    Descriere, CodBare, CodPlu, Pret, AdaosNIR, PretAchizitie, Stoc, UM, 
                                    MateriePrima, OnlineSync, Complex, Sizeable, Action) 
                                    VALUES 
                                    (OLD.ID, OLD.WebProductId, OLD.IDSubCategorie, OLD.TVA, OLD.TVAL, OLD.TVAF, OLD.Denumire, 
                                     OLD.Descriere, OLD.CodBare, OLD.CodPlu, OLD.Pret, OLD.AdaosNIR, OLD.PretAchizitie, OLD.Stoc, 
                                     OLD.UM, OLD.MateriePrima, OLD.OnlineSync, OLD.Complex, OLD.Sizeable, 1);
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `TProduseBarcode`
--

CREATE TABLE `TProduseBarcode` (
  `Id` int(11) NOT NULL,
  `ProdusId` int(11) NOT NULL,
  `Barcode` varchar(50) NOT NULL DEFAULT 'auxbc',
  `Added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `Active` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TProduseBonActiv`
--

CREATE TABLE `TProduseBonActiv` (
  `IdUser` int(11) NOT NULL,
  `IdBonTemp` int(11) NOT NULL,
  `ID` int(11) NOT NULL,
  `IDProdus` int(11) NOT NULL,
  `IDMasaActiva` int(11) NOT NULL,
  `Cantitate` double NOT NULL,
  `Imprimat` tinyint(4) NOT NULL,
  `Comentarii` longtext,
  `Timp` text NOT NULL,
  `InLucru` bit(1) NOT NULL DEFAULT b'1',
  `Discount` double NOT NULL DEFAULT '0',
  `DiscountBon` double NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `TProduseBonActiv`
--

INSERT INTO `TProduseBonActiv` (`IdUser`, `IdBonTemp`, `ID`, `IDProdus`, `IDMasaActiva`, `Cantitate`, `Imprimat`, `Comentarii`, `Timp`, `InLucru`, `Discount`, `DiscountBon`) VALUES
(1, 1, 1, 487, 65, 1, 0, '', '', b'1', 0, 0),
(1, 1, 2, 487, 65, 1, 0, '', '', b'1', 0, 0),
(1, 1, 3, 487, 65, 1, 0, '', '', b'1', 0, 0),
(1, 1, 4, 487, 65, 1, 0, '', '', b'1', 0, 0),
(1, 1, 5, 487, 65, 1, 0, '', '', b'1', 0, 0),
(1, 1, 6, 487, 65, 1, 0, '', '', b'1', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `TProduseBonActivTemp`
--

CREATE TABLE `TProduseBonActivTemp` (
  `IdUser` int(11) NOT NULL,
  `IdBonTemp` int(11) NOT NULL,
  `ID` int(11) NOT NULL,
  `IDProdus` int(11) NOT NULL,
  `IDMasaActiva` int(11) NOT NULL,
  `Cantitate` double NOT NULL,
  `Imprimat` tinyint(4) NOT NULL,
  `Comentarii` longtext,
  `InLucru` bit(1) NOT NULL DEFAULT b'1',
  `Discount` double NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `TProduseBonActivTemp`
--

INSERT INTO `TProduseBonActivTemp` (`IdUser`, `IdBonTemp`, `ID`, `IDProdus`, `IDMasaActiva`, `Cantitate`, `Imprimat`, `Comentarii`, `InLucru`, `Discount`) VALUES
(1, 1, 1, 487, 65, 1, 0, '', b'1', 0),
(1, 1, 2, 487, 65, 1, 0, '', b'1', 0),
(1, 1, 3, 487, 65, 1, 0, '', b'1', 0),
(1, 1, 4, 487, 65, 1, 0, '', b'1', 0),
(1, 1, 5, 487, 65, 1, 0, '', b'1', 0),
(1, 1, 6, 487, 65, 1, 0, '', b'1', 0);

-- --------------------------------------------------------

--
-- Table structure for table `TRegistru`
--

CREATE TABLE `TRegistru` (
  `ID` int(11) NOT NULL,
  `NrDocument` varchar(254) NOT NULL,
  `TipDocument` varchar(254) NOT NULL,
  `Detalii` varchar(250) NOT NULL,
  `Incasari` double(10,2) NOT NULL,
  `Plati` double(10,2) NOT NULL,
  `Data` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Total` double(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TReturClient`
--

CREATE TABLE `TReturClient` (
  `Id` int(11) NOT NULL,
  `IdBon` int(11) NOT NULL,
  `Denumire` varchar(200) NOT NULL,
  `CUI_CNP` varchar(20) NOT NULL,
  `Recom` varchar(20) NOT NULL,
  `Delegat` varchar(100) NOT NULL,
  `Adresa` varchar(254) NOT NULL,
  `Oras` varchar(50) NOT NULL,
  `Judet` varchar(50) NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TSali`
--

CREATE TABLE `TSali` (
  `ID` int(11) NOT NULL,
  `DenumireSala` longtext
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `TSali`
--

INSERT INTO `TSali` (`ID`, `DenumireSala`) VALUES
(1, 'SALA 1'),
(2, 'SALA 2'),
(3, 'TERASA 1'),
(4, 'TERASA 2'),
(5, 'CURTE');

-- --------------------------------------------------------

--
-- Table structure for table `TSerieF`
--

CREATE TABLE `TSerieF` (
  `ID` int(11) NOT NULL,
  `SerieF` varchar(200) NOT NULL DEFAULT '00',
  `NrF` int(25) DEFAULT NULL,
  `SerieC` varchar(200) NOT NULL DEFAULT '00',
  `NrC` int(11) DEFAULT NULL,
  `NrB` int(11) DEFAULT NULL,
  `NrDP` int(11) DEFAULT NULL,
  `SM` mediumtext,
  `SMG` int(11) DEFAULT NULL,
  `Serial` int(11) DEFAULT NULL,
  `P` int(11) DEFAULT NULL,
  `Data` mediumtext,
  `NrTranzactie` int(11) NOT NULL,
  `Aviz` int(25) NOT NULL,
  `Bon` int(25) NOT NULL,
  `Fisa` int(25) NOT NULL,
  `Necesar` int(25) NOT NULL,
  `Transfer` int(25) NOT NULL,
  `Productie` int(25) NOT NULL,
  `SerieA` varchar(200) NOT NULL DEFAULT '',
  `SerieB` varchar(200) NOT NULL,
  `SerieFisa` varchar(200) NOT NULL,
  `SerieN` varchar(200) NOT NULL,
  `SerieT` varchar(200) NOT NULL,
  `SerieP` varchar(200) NOT NULL,
  `NrOrdine` int(5) NOT NULL DEFAULT '0',
  `NumarInventar` int(11) NOT NULL DEFAULT '1',
  `InventarActiv` tinyint(1) NOT NULL DEFAULT '0',
  `UserNIRActiv` tinyint(1) NOT NULL DEFAULT '0',
  `UserNIRTimestamp` timestamp NULL DEFAULT NULL,
  `AutomaticStock` tinyint(1) NOT NULL DEFAULT '0',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ReceiptActiv` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `TSerieF`
--

INSERT INTO `TSerieF` (`ID`, `SerieF`, `NrF`, `SerieC`, `NrC`, `NrB`, `NrDP`, `SM`, `SMG`, `Serial`, `P`, `Data`, `NrTranzactie`, `Aviz`, `Bon`, `Fisa`, `Necesar`, `Transfer`, `Productie`, `SerieA`, `SerieB`, `SerieFisa`, `SerieN`, `SerieT`, `SerieP`, `NrOrdine`, `NumarInventar`, `InventarActiv`, `UserNIRActiv`, `UserNIRTimestamp`, `AutomaticStock`, `Timestamp`, `ReceiptActiv`) VALUES
(1, 'GLB', 41, '0', 1, 0, 0, '0', 0, 0, 0, '0', 9, 0, 1, 1, 0, 0, 14, 'GLB', 'GLB', 'GLB', 'GLB', 'GLB', 'GLB', 49, 3, 1, 0, NULL, 0, '2023-01-05 07:54:24', 0);

--
-- Triggers `TSerieF`
--
DELIMITER $$
CREATE TRIGGER `TSerieFUpdate` AFTER UPDATE ON `TSerieF` FOR EACH ROW BEGIN
    IF NEW.SerieC != OLD.SerieC OR 
        NEW.SerieA != OLD.SerieA OR 
        NEW.SerieB != OLD.SerieB OR 
        NEW.SerieFisa != OLD.SerieFisa OR 
        NEW.SerieN != OLD.SerieN OR 
        NEW.SerieT != OLD.SerieT OR 
        NEW.SerieP != OLD.SerieP
    THEN

    UPDATE TSerieF SET Timestamp = current_timestamp();
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `TStocuriTura`
--

CREATE TABLE `TStocuriTura` (
  `ID` bigint(20) NOT NULL,
  `IDPRODUS` int(11) NOT NULL,
  `IDTURA` int(11) NOT NULL,
  `STOCINITIAL` double(10,3) NOT NULL,
  `STOCFINAL` double(10,3) NOT NULL,
  `Productie` double(10,3) NOT NULL,
  `Protocol` double(10,3) NOT NULL,
  `Consum` double(10,3) NOT NULL,
  `Rebut` double(10,3) NOT NULL,
  `PretA` double(10,2) NOT NULL DEFAULT '0.00',
  `PretV` double(10,2) NOT NULL DEFAULT '0.00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `TStocuriTura`
--

INSERT INTO `TStocuriTura` (`ID`, `IDPRODUS`, `IDTURA`, `STOCINITIAL`, `STOCFINAL`, `Productie`, `Protocol`, `Consum`, `Rebut`, `PretA`, `PretV`) VALUES
(1, 1, 1, -2208.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(2, 2, 1, -891.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(3, 3, 1, -644.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(4, 4, 1, -127.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(5, 5, 1, -919.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(6, 6, 1, -2033.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(7, 7, 1, -927.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(8, 8, 1, -1269.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(9, 9, 1, -579.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(10, 10, 1, -1793.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(11, 11, 1, -3027.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(12, 12, 1, -92.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(13, 13, 1, -2289.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(14, 15, 1, -467.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(15, 16, 1, -318.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(16, 17, 1, -910.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(17, 18, 1, -482.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(18, 19, 1, -647.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(19, 20, 1, -2128.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(20, 21, 1, -304.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(21, 22, 1, -1278.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(22, 23, 1, -1494.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(23, 24, 1, -1654.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(24, 25, 1, -1289.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(25, 26, 1, -806.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(26, 27, 1, -1097.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(27, 28, 1, -6.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(28, 29, 1, -2429.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(29, 30, 1, -562.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(30, 31, 1, -1959.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(31, 32, 1, -63.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(32, 33, 1, -567.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(33, 34, 1, -119.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(34, 35, 1, -142.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(35, 36, 1, -1022.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(36, 37, 1, -553.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(37, 38, 1, -706.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(38, 39, 1, -920.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(39, 40, 1, -565.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(40, 41, 1, -174.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(41, 42, 1, -3360.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(42, 43, 1, -1637.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(43, 44, 1, -1504.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(44, 45, 1, -759.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(45, 46, 1, -3153.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(46, 47, 1, -237.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(47, 48, 1, -2262.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(48, 49, 1, -1590.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(49, 50, 1, -613.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(50, 51, 1, -608.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(51, 52, 1, -1354.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(52, 53, 1, -2169.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(53, 54, 1, -158.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(54, 55, 1, -1250.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(55, 56, 1, -350.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(56, 57, 1, -1919.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(57, 58, 1, -621.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(58, 59, 1, -256.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(59, 60, 1, -330.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(60, 61, 1, -1507.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(61, 62, 1, -594.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(62, 63, 1, -429.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(63, 64, 1, -1761.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(64, 65, 1, -736.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(65, 66, 1, -1180.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(66, 67, 1, -1395.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(67, 68, 1, -487.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(68, 69, 1, -2427.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(69, 70, 1, -167.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(70, 71, 1, -58.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(71, 72, 1, -488.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(72, 73, 1, -2538.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(73, 74, 1, -799.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(74, 75, 1, -2210.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(75, 76, 1, -131.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(76, 77, 1, -638.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(77, 78, 1, -1547.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(78, 80, 1, -34.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(79, 81, 1, -161.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(80, 82, 1, -48.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(81, 83, 1, -47.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(82, 84, 1, -10.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(83, 85, 1, -75.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(84, 86, 1, -93.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(85, 87, 1, -27.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(86, 88, 1, -8.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(87, 89, 1, -75.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(88, 90, 1, -25.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(89, 91, 1, -98.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(90, 92, 1, -157.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(91, 93, 1, -165.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(92, 94, 1, -129.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(93, 95, 1, -206.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(94, 97, 1, -373.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(95, 98, 1, -88.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(96, 99, 1, -22.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(97, 100, 1, -14.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(98, 101, 1, -391.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(99, 102, 1, -58.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(100, 103, 1, -113.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(101, 104, 1, -216.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(102, 105, 1, -113.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(103, 106, 1, -34.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(104, 107, 1, -57.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(105, 108, 1, -127.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(106, 109, 1, -65.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(107, 110, 1, -75.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(108, 111, 1, -267.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(109, 112, 1, -53.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(110, 113, 1, -114.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(111, 114, 1, -68.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(112, 115, 1, -33.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(113, 116, 1, -8.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(114, 117, 1, -171.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(115, 119, 1, -111.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(116, 120, 1, -21.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(117, 121, 1, -172.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(118, 122, 1, -107.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(119, 123, 1, -31.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(120, 124, 1, -385.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(121, 125, 1, -76.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(122, 126, 1, -336.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(123, 127, 1, -62.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(124, 128, 1, -120.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(125, 129, 1, -246.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(126, 130, 1, -159.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(127, 131, 1, -636.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(128, 132, 1, -27.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(129, 133, 1, -20.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(130, 134, 1, -100.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(131, 135, 1, -5.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(132, 136, 1, -1840.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(133, 137, 1, -45.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(134, 138, 1, -47.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(135, 139, 1, -34.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(136, 140, 1, -403.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(137, 141, 1, -131.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(138, 142, 1, -124.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(139, 143, 1, -239.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(140, 144, 1, -566.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(141, 145, 1, -371.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(142, 146, 1, -9119.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(143, 147, 1, -481.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(144, 148, 1, -558.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(145, 150, 1, -209.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(146, 151, 1, -39.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(147, 152, 1, -1788.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(148, 153, 1, -3282.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(149, 154, 1, -1627.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(150, 155, 1, -3694.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(151, 156, 1, -5400.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(152, 157, 1, -38.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(153, 158, 1, -10441.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(154, 159, 1, -7.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(155, 160, 1, -679.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(156, 161, 1, -182.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(157, 162, 1, -231.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(158, 163, 1, -43.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(159, 164, 1, -888.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(160, 167, 1, -2226.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(161, 168, 1, -1357.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(162, 169, 1, -243.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(163, 170, 1, -122.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(164, 171, 1, -183.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(165, 172, 1, -876.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(166, 173, 1, -168.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(167, 174, 1, -444.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(168, 175, 1, -4647.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(169, 176, 1, -3134.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(170, 177, 1, -461.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(171, 178, 1, -465.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(172, 179, 1, -3026.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(173, 180, 1, -53.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(174, 181, 1, -236.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(175, 182, 1, -984.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(176, 183, 1, -139.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(177, 184, 1, -630.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(178, 185, 1, -102.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(179, 186, 1, -321.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(180, 187, 1, -1379.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(181, 188, 1, -28.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(182, 189, 1, -1390.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(183, 190, 1, -391.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(184, 191, 1, -892.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(185, 192, 1, -17.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(186, 193, 1, -1638.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(187, 194, 1, -106.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(188, 195, 1, -188.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(189, 196, 1, -598.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(190, 197, 1, -1073.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(191, 198, 1, -657.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(192, 199, 1, -187.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(193, 200, 1, -1372.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(194, 201, 1, -4745.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(195, 202, 1, -531.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(196, 203, 1, -1151.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(197, 204, 1, -530.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(198, 206, 1, -762.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(199, 207, 1, -14.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(200, 208, 1, -545.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(201, 209, 1, -61.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(202, 210, 1, -66.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(203, 211, 1, -1.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(204, 212, 1, -130.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(205, 213, 1, -26.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(206, 214, 1, -928.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(207, 216, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(208, 217, 1, -66.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(209, 218, 1, -17910.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(210, 219, 1, -63.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(211, 220, 1, -458.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(212, 221, 1, -3.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(213, 222, 1, -27830.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(214, 224, 1, -726.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(215, 225, 1, -697.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(216, 226, 1, -516.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(217, 227, 1, -28.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(218, 228, 1, -110.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(219, 229, 1, -298.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(220, 230, 1, -222.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(221, 231, 1, -825.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(222, 232, 1, -32.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(223, 233, 1, -5.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(224, 234, 1, -10.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(225, 235, 1, -5.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(226, 236, 1, -51.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(227, 237, 1, -47.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(228, 239, 1, -37.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(229, 240, 1, -144.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(230, 241, 1, -142.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(231, 244, 1, -131.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(232, 246, 1, -181.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(233, 247, 1, -564.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(234, 248, 1, -640.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(235, 249, 1, -384.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(236, 250, 1, -374.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(237, 251, 1, -421.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(238, 252, 1, -567.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(239, 253, 1, -234.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(240, 254, 1, -297.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(241, 255, 1, -690.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(242, 256, 1, -325.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(243, 257, 1, -268.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(244, 258, 1, -903.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(245, 259, 1, -523.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(246, 260, 1, -163.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(247, 261, 1, -474.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(248, 262, 1, -670.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(249, 266, 1, -131.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(250, 268, 1, -477.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(251, 269, 1, -1866.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(252, 270, 1, -243.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(253, 271, 1, -154.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(254, 272, 1, -41.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(255, 273, 1, -280.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(256, 274, 1, -42.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(257, 275, 1, -4020.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(258, 276, 1, -1.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(259, 277, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(260, 278, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(261, 279, 1, -454.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(262, 283, 1, -1437.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(263, 284, 1, -2482.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(264, 285, 1, -1590.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(265, 286, 1, -972.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(266, 288, 1, -77.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(267, 289, 1, -73.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(268, 290, 1, -15.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(269, 291, 1, -339.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(270, 295, 1, -425.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(271, 296, 1, -36.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(272, 297, 1, -2764.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(273, 299, 1, -425.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(274, 300, 1, -2394.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(275, 301, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(276, 302, 1, -723.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(277, 303, 1, -501.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(278, 304, 1, -649.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(279, 305, 1, -148.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(280, 306, 1, -1987.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(281, 307, 1, -334.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(282, 308, 1, -29.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(283, 309, 1, -8.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(284, 310, 1, -11.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(285, 311, 1, -6.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(286, 312, 1, -19.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(287, 313, 1, -1.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(288, 314, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(289, 315, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(290, 316, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(291, 317, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(292, 318, 1, -2.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(293, 319, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(294, 320, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(295, 321, 1, -6.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(296, 322, 1, -3.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(297, 323, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(298, 324, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(299, 325, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(300, 326, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(301, 327, 1, -13.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(302, 328, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(303, 333, 1, -4.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(304, 334, 1, -3413.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(305, 337, 1, -62.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(306, 338, 1, -1.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(307, 339, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(308, 340, 1, -1531.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(309, 342, 1, -1000.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(310, 343, 1, -1467.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(311, 344, 1, -392.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(312, 345, 1, -429.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(313, 346, 1, -1166.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(314, 347, 1, -967.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(315, 348, 1, -523.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(316, 349, 1, -87.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(317, 350, 1, -22.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(318, 351, 1, -6.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(319, 352, 1, -3.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(320, 353, 1, -473.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(321, 355, 1, -110.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(322, 356, 1, -127.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(323, 357, 1, -136.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(324, 359, 1, -364.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(325, 360, 1, -1663.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(326, 361, 1, -1194.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(327, 362, 1, -1096.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(328, 363, 1, -53.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(329, 364, 1, -40.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(330, 368, 1, -100.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(331, 369, 1, -19.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(332, 370, 1, -15.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(333, 372, 1, -115.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(334, 373, 1, -40.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(335, 374, 1, -4.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(336, 375, 1, -34.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(337, 376, 1, -12.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(338, 377, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(339, 379, 1, -5.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(340, 381, 1, -1672.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(341, 382, 1, -26.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(342, 383, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(343, 385, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(344, 386, 1, -36.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(345, 387, 1, -177.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(346, 388, 1, -1.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(347, 389, 1, -1885.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(348, 391, 1, -49.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(349, 396, 1, -1441.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(350, 397, 1, -1122.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(351, 398, 1, -11.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(352, 399, 1, -217.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(353, 401, 1, -259.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(354, 402, 1, -1492.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(355, 403, 1, -650.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(356, 404, 1, -4571.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(357, 405, 1, -203.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(358, 407, 1, -17.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(359, 408, 1, -322.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(360, 409, 1, -589.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(361, 451, 1, -6.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(362, 452, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(363, 453, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(364, 454, 1, -6.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(365, 458, 1, -48.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(366, 459, 1, -256.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(367, 460, 1, -417.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(368, 461, 1, -130.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(369, 462, 1, -142.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(370, 463, 1, -153.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(371, 464, 1, -94.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(372, 466, 1, -390.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(373, 467, 1, -163.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(374, 468, 1, -355.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(375, 469, 1, -8.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(376, 470, 1, -880.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(377, 471, 1, -706.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(378, 472, 1, -69.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(379, 473, 1, -478.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(380, 474, 1, -1138.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(381, 475, 1, -606.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(382, 476, 1, -779.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(383, 477, 1, -42.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(384, 478, 1, -82.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(385, 479, 1, -8.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(386, 480, 1, -1.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(387, 482, 1, -1470.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(388, 483, 1, -2.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(389, 484, 1, -1.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(390, 485, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(391, 486, 1, -14.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(392, 487, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(393, 488, 1, -75.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(394, 489, 1, -207.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(395, 490, 1, -170.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(396, 491, 1, -39.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(397, 492, 1, -78.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(398, 493, 1, -42.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(399, 494, 1, -347.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(400, 495, 1, -225.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(401, 496, 1, -376.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(402, 497, 1, -6.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(403, 498, 1, -183.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(404, 499, 1, -135.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(405, 500, 1, -2.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(406, 501, 1, -254.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(407, 502, 1, -3.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(408, 503, 1, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(409, 504, 1, -16.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(410, 505, 1, -14.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(411, 506, 1, -10.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(412, 507, 1, -564.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00),
(413, 508, 1, -2.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.00, 0.00);

-- --------------------------------------------------------

--
-- Table structure for table `TSubCategorii`
--

CREATE TABLE `TSubCategorii` (
  `Blocat` tinyint(1) NOT NULL DEFAULT '0',
  `IDSubCategorie` int(32) NOT NULL,
  `NumeSubCategorie` varchar(255) NOT NULL DEFAULT 'NoName',
  `IdCategorie` int(11) NOT NULL,
  `Tip` varchar(255) NOT NULL DEFAULT 'simplu',
  `WebId` int(11) NOT NULL DEFAULT '-1',
  `Descriere` text NOT NULL,
  `Imagine` text NOT NULL,
  `UpdatedById` int(11) NOT NULL DEFAULT '1',
  `SelfService` tinyint(1) NOT NULL DEFAULT '0',
  `ServiceType` tinyint(4) NOT NULL DEFAULT '1',
  `Priority` tinyint(11) NOT NULL DEFAULT '0',
  `Deleted` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `TSubCategorii`
--

INSERT INTO `TSubCategorii` (`Blocat`, `IDSubCategorie`, `NumeSubCategorie`, `IdCategorie`, `Tip`, `WebId`, `Descriere`, `Imagine`, `UpdatedById`, `SelfService`, `ServiceType`, `Priority`, `Deleted`) VALUES
(0, 1, 'WHISKI', 1, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 2, 'VODKA', 1, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 3, 'DIGESTIVE', 1, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 4, 'COCKTAILS', 1, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 5, 'CAFEA', 1, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 6, 'BERE', 1, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 7, 'SUCURI', 1, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 8, 'Vin pah/carafa', 1, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 9, 'VIN ITALIA rosu', 1, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 10, 'VIN ITALIA rose', 1, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 11, 'VIN ITALIA alb', 1, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 12, 'VIN ROMANIA 2', 1, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 13, 'ANTIPASTI', 2, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 14, 'SALATE', 2, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 15, 'PASTE', 2, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 16, 'SECODI DI CARNE', 2, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 17, 'SECODI DI PESCE', 2, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 18, 'CONTORNI', 2, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 19, 'PIZZA', 2, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 20, 'DESERT', 2, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 21, 'EXTRA ', 2, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 22, 'PIZZA HAPPY HOUR', 2, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 23, ' HAPPY HOUR', 2, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 24, 'Mic dejun', 2, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 26, ' LIVRARI', 1, 'simplu', -1, '', '', 1, 0, 1, 0, 0),
(0, 27, 'test', 2, 'simplu', -1, '', '', 1, 0, 1, 0, 0);

--
-- Triggers `TSubCategorii`
--
DELIMITER $$
CREATE TRIGGER `LogSubcategoryDelete` BEFORE DELETE ON `TSubCategorii` FOR EACH ROW BEGIN
	INSERT INTO SubcategoryHistory (WebId, CategoryId, SubcategoryId, UpdatedById, Name, Description, Type, Action) VALUES 
                (OLD.WebId, OLD.IdCategorie, OLD.IDSubCategorie, OLD.UpdatedById, OLD.NumeSubCategorie, OLD.Descriere, OLD.Tip,  2);
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `LogSubcategoryInsert` BEFORE INSERT ON `TSubCategorii` FOR EACH ROW BEGIN
	INSERT INTO CategoryHistory (CategoryId, UpdatedById, Name, Type, Action, Description) 
    Select NEW.IdCategorie, c.UpdatedById, c.NumeCategorie, c.TipCategorie, 3,
    CONCAT("INSERTED NEW SUBCATEGORY: ", NEW.NumeSubCategorie, "; Type: ", NEW.Tip, "; Description: ", NEW.Descriere, "; By: ", NEW.UpdatedById)
    FROM TCategorii c
    WHERE IDCategorie = NEW.IdCategorie;
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `LogSubcategoryUpdate` BEFORE UPDATE ON `TSubCategorii` FOR EACH ROW BEGIN
	INSERT INTO SubcategoryHistory (WebId, CategoryId, SubcategoryId, UpdatedById, Name, Description, Type, Action) VALUES 
                (OLD.WebId, OLD.IdCategorie, OLD.IDSubCategorie, OLD.UpdatedById, OLD.NumeSubCategorie, OLD.Descriere, OLD.Tip,  1);
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `TTure`
--

CREATE TABLE `TTure` (
  `ID` int(11) NOT NULL,
  `NumeUser` varchar(50) NOT NULL,
  `DataOpen` varchar(64) NOT NULL,
  `DataClose` varchar(64) DEFAULT NULL,
  `File` varchar(200) DEFAULT NULL,
  `SoldFinal` float DEFAULT NULL,
  `DATAO` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `DATAC` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `TTure`
--

INSERT INTO `TTure` (`ID`, `NumeUser`, `DataOpen`, `DataClose`, `File`, `SoldFinal`, `DATAO`, `DATAC`) VALUES
(1, 'Admin', '638116308135129295', '0', NULL, NULL, '2023-02-10 11:00:13', '2023-02-10 11:00:13');

-- --------------------------------------------------------

--
-- Table structure for table `TTVA`
--

CREATE TABLE `TTVA` (
  `ID` int(11) NOT NULL,
  `Denumire` varchar(255) NOT NULL DEFAULT 'TVA',
  `Valoare` int(11) NOT NULL DEFAULT '0',
  `Procent` float NOT NULL DEFAULT '0',
  `Ordine` int(11) NOT NULL DEFAULT '1',
  `AssociatedId` int(11) NOT NULL DEFAULT '-1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `TTVA`
--

INSERT INTO `TTVA` (`ID`, `Denumire`, `Valoare`, `Procent`, `Ordine`, `AssociatedId`) VALUES
(1, 'G1-19%', 1, 19, 1, -1),
(2, 'G2-9%', 2, 9, 2, -1),
(3, 'G3-5%', 3, 5, 3, -1),
(4, 'G4-0%', 4, 0, 4, -1),
(5, 'G5-0%', 5, 0, 5, -1),
(6, 'G6-0%', 6, 0, 6, -1),
(7, 'G7-0%', 7, 0, 7, -1);

-- --------------------------------------------------------

--
-- Table structure for table `TUsers`
--

CREATE TABLE `TUsers` (
  `NumeUtilizator` varchar(255) NOT NULL DEFAULT 'NumeUtilizator',
  `ID` int(11) NOT NULL,
  `PrenumeUser` varchar(255) NOT NULL DEFAULT 'PrenumeUser',
  `NumeUser` varchar(255) NOT NULL DEFAULT 'NumeUser',
  `Password` varchar(255) NOT NULL DEFAULT '0',
  `TipUser` varchar(255) NOT NULL DEFAULT 'ospatar',
  `Telefon` varchar(255) NOT NULL DEFAULT '07123',
  `Secret` varchar(255) NOT NULL DEFAULT '0',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `Parola` varchar(222) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `TUsers`
--

INSERT INTO `TUsers` (`NumeUtilizator`, `ID`, `PrenumeUser`, `NumeUser`, `Password`, `TipUser`, `Telefon`, `Secret`, `Timestamp`, `Parola`) VALUES
('Admin', 1, 'Admin', 'Admin', 'b0bd4293d6e1e39be15d4fb0430b8f2d', 'admin', '', '6C40E322-C2D1-443F-939A-42CEAAEFC7AE6628C447-7430-4ACA-9E09-0F7A765B2588', '2023-02-10 16:28:40', '1234'),
('gestiune', 10, 'gestiune', 'gestiune', '4a7d1ed414474e4033ac29ccb8653d9b', 'gestiune', '', 'f71a9f7d-470e-449e-adc5-505d65366a23d0f45142-c908-4252-b926-20e164351053', '2021-07-22 09:07:42', '0000');

-- --------------------------------------------------------

--
-- Table structure for table `TVoucher`
--

CREATE TABLE `TVoucher` (
  `ID` int(11) NOT NULL,
  `Cod` varchar(25) NOT NULL,
  `DataEmitere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `DataExpirarii` date NOT NULL,
  `DataFolosire` timestamp NULL DEFAULT NULL,
  `Valoare` double NOT NULL,
  `Activ` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TZ`
--

CREATE TABLE `TZ` (
  `NumeUser` varchar(255) NOT NULL,
  `BonActiv` int(11) NOT NULL,
  `Data` longtext NOT NULL,
  `Id` int(11) NOT NULL,
  `CodClient` varchar(254) NOT NULL DEFAULT '-1',
  `TipVanzare` int(11) NOT NULL DEFAULT '0',
  `IdTura` int(11) NOT NULL,
  `IdBonTemporar` int(11) DEFAULT NULL,
  `TotalProtocol` double(10,2) NOT NULL DEFAULT '0.00',
  `TotalFiscal` double(10,2) NOT NULL DEFAULT '0.00',
  `Minute` int(11) NOT NULL,
  `DataBon` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `InLucru` bit(1) DEFAULT b'1',
  `Numerar` double(10,2) NOT NULL DEFAULT '0.00',
  `Card` double(10,2) NOT NULL DEFAULT '0.00',
  `Bonuri` double(10,2) NOT NULL DEFAULT '0.00',
  `Vaucher` double(10,2) NOT NULL DEFAULT '0.00',
  `PlataModerna` double(10,2) NOT NULL DEFAULT '0.00',
  `Factura` double(10,2) NOT NULL DEFAULT '0.00',
  `ClientCod` double(10,2) NOT NULL DEFAULT '0.00',
  `Aviz` double(10,2) NOT NULL DEFAULT '0.00',
  `Tips` double(10,2) NOT NULL DEFAULT '0.00',
  `IdVoucher` int(11) DEFAULT '0',
  `Discount` double(10,2) NOT NULL DEFAULT '0.00',
  `DataDeschidere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `DataInchidere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `LIVRARE` varchar(20) NOT NULL DEFAULT 'ServescAici',
  `Status` varchar(100) NOT NULL DEFAULT 'Nepreluata',
  `NrOrdine` int(5) NOT NULL DEFAULT '0',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `StockUpdated` tinyint(1) NOT NULL DEFAULT '0',
  `UserId` int(11) NOT NULL DEFAULT '1',
  `AdresaLivrare` varchar(255) NOT NULL DEFAULT '-',
  `FiscallyPrinted` tinyint(1) NOT NULL DEFAULT '0',
  `NrBF` int(11) NOT NULL DEFAULT '0',
  `EroareBF` varchar(255) NOT NULL DEFAULT 'none'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `TZ`
--

INSERT INTO `TZ` (`NumeUser`, `BonActiv`, `Data`, `Id`, `CodClient`, `TipVanzare`, `IdTura`, `IdBonTemporar`, `TotalProtocol`, `TotalFiscal`, `Minute`, `DataBon`, `InLucru`, `Numerar`, `Card`, `Bonuri`, `Vaucher`, `PlataModerna`, `Factura`, `ClientCod`, `Aviz`, `Tips`, `IdVoucher`, `Discount`, `DataDeschidere`, `DataInchidere`, `LIVRARE`, `Status`, `NrOrdine`, `Timestamp`, `StockUpdated`, `UserId`, `AdresaLivrare`, `FiscallyPrinted`, `NrBF`, `EroareBF`) VALUES
('Admin', 1, '2023-02-10 13:18:17', 1, '-1', 0, 1, 1, 0.00, 0.00, 0, '2023-02-10 12:18:17', b'1', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0.00, '2023-02-10 12:18:17', '2023-02-10 12:18:17', 'ServescAici', 'Nepreluata', 49, '2023-02-10 12:18:17', 0, 1, '-', 0, 0, 'none');

-- --------------------------------------------------------

--
-- Table structure for table `TZCarduri`
--

CREATE TABLE `TZCarduri` (
  `ID` int(11) NOT NULL,
  `CodUtilizator` varchar(200) NOT NULL,
  `CodClient` varchar(200) NOT NULL,
  `SumaInitiala` double NOT NULL,
  `SumaFinala` double NOT NULL,
  `TipTranzactie` varchar(200) NOT NULL,
  `Data` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TZMarimi`
--

CREATE TABLE `TZMarimi` (
  `Id` int(11) NOT NULL,
  `BonId` int(11) NOT NULL,
  `MarimeId` int(11) NOT NULL,
  `Nume` varchar(256) NOT NULL,
  `Cantitate` double NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TZProdus`
--

CREATE TABLE `TZProdus` (
  `Id` int(11) NOT NULL,
  `IdProdus` int(11) NOT NULL,
  `Cantitate` double(10,3) NOT NULL DEFAULT '0.000',
  `IdBon` int(11) NOT NULL,
  `CodClient` varchar(255) NOT NULL DEFAULT '-1',
  `IdTura` int(11) NOT NULL DEFAULT '0',
  `Pret` double(10,2) NOT NULL DEFAULT '0.00',
  `PretA` double(10,2) NOT NULL DEFAULT '0.00',
  `Discount` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA` int(4) NOT NULL,
  `StornoQ` double(10,3) NOT NULL DEFAULT '0.000',
  `Data` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `IDClient` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TZProduseTUTA`
--

CREATE TABLE `TZProduseTUTA` (
  `Id` int(11) NOT NULL,
  `IdProdus` int(11) NOT NULL,
  `Denumire` longtext NOT NULL,
  `Cantitate` double(10,3) NOT NULL DEFAULT '0.000',
  `IdBon` int(11) NOT NULL,
  `CodClient` longtext NOT NULL,
  `IdTura` int(11) NOT NULL,
  `Pret` double(10,2) NOT NULL DEFAULT '0.00',
  `IdCat` int(11) NOT NULL,
  `IdSCat` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `TZTure`
--

CREATE TABLE `TZTure` (
  `ID` int(11) NOT NULL,
  `IDTura` int(11) NOT NULL DEFAULT '0',
  `Total` double(10,2) NOT NULL DEFAULT '0.00',
  `Numerar` double(10,2) NOT NULL DEFAULT '0.00',
  `Card` double(10,2) NOT NULL DEFAULT '0.00',
  `Bonuri` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA1` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA2` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA3` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA4` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA5` double(10,2) NOT NULL DEFAULT '0.00',
  `TVA6` double(10,2) NOT NULL DEFAULT '0.00',
  `tva7` double(10,2) NOT NULL DEFAULT '0.00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `TZTure`
--

INSERT INTO `TZTure` (`ID`, `IDTura`, `Total`, `Numerar`, `Card`, `Bonuri`, `TVA1`, `TVA2`, `TVA3`, `TVA4`, `TVA5`, `TVA6`, `tva7`) VALUES
(1, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00);

-- --------------------------------------------------------

--
-- Table structure for table `userlogin`
--

CREATE TABLE `userlogin` (
  `id` int(11) NOT NULL,
  `first_name` varchar(255) NOT NULL DEFAULT '0',
  `last_name` varchar(255) NOT NULL DEFAULT '0',
  `email` varchar(255) NOT NULL DEFAULT '0',
  `password` varchar(255) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `UserTypes`
--

CREATE TABLE `UserTypes` (
  `Id` int(11) NOT NULL,
  `Type` varchar(256) NOT NULL,
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `UserTypes`
--

INSERT INTO `UserTypes` (`Id`, `Type`, `Timestamp`) VALUES
(1, 'admin', '2021-05-11 07:31:22'),
(2, 'ospatar', '2021-05-11 07:31:22'),
(3, 'casier', '2021-05-11 07:31:22'),
(4, 'inventar', '2021-12-07 12:11:27'),
(5, 'livrare', '2021-12-07 12:11:48'),
(6, 'gestiune', '2021-12-07 12:11:36');

-- --------------------------------------------------------

--
-- Table structure for table `user_login`
--

CREATE TABLE `user_login` (
  `id` int(5) NOT NULL,
  `IdPart` int(11) NOT NULL,
  `nume` varchar(100) NOT NULL,
  `prenume` varchar(100) NOT NULL,
  `username` varchar(100) NOT NULL,
  `mail` varchar(200) NOT NULL,
  `password` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `VATDetails`
--

CREATE TABLE `VATDetails` (
  `Id` int(11) NOT NULL,
  `Name` varchar(50) NOT NULL,
  `Description` varchar(250) NOT NULL,
  `Language` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `Webcommerce`
--

CREATE TABLE `Webcommerce` (
  `Id` int(11) NOT NULL,
  `Nume` varchar(200) NOT NULL,
  `Site` varchar(250) NOT NULL,
  `ck` varchar(64) NOT NULL,
  `cs` varchar(43) NOT NULL,
  `RefreshRate` mediumint(8) UNSIGNED NOT NULL DEFAULT '5000' COMMENT 'The refresh rate of website orders verification. The smallest value it can take is 501. This value  reprezents the milliseconds between each check.',
  `Active` tinyint(1) NOT NULL DEFAULT '0',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `_Settings`
--

CREATE TABLE `_Settings` (
  `Id` int(11) NOT NULL,
  `Type` int(10) UNSIGNED NOT NULL,
  `Value` varchar(200) NOT NULL,
  `Active` tinyint(1) NOT NULL DEFAULT '1',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `_Settings`
--

INSERT INTO `_Settings` (`Id`, `Type`, `Value`, `Active`, `Timestamp`) VALUES
(1, 1, '#o3ool4', 1, '2021-05-19 21:00:00'),
(7, 7, 'f5554334-0ebf-47c7-85d0-4eddedab4e3e', 1, '2022-10-12 11:23:00'),
(8, 8, '0', 1, '2023-02-10 10:58:00');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `ActionTypes`
--
ALTER TABLE `ActionTypes`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `AdreseLivrrare`
--
ALTER TABLE `AdreseLivrrare`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `Atribute`
--
ALTER TABLE `Atribute`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `Avize`
--
ALTER TABLE `Avize`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `BankDetails`
--
ALTER TABLE `BankDetails`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `BonTransfer`
--
ALTER TABLE `BonTransfer`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `BonuriAvize`
--
ALTER TABLE `BonuriAvize`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `BonuriConsum`
--
ALTER TABLE `BonuriConsum`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `BonuriFacturi`
--
ALTER TABLE `BonuriFacturi`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `Calls`
--
ALTER TABLE `Calls`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `CategoryHistory`
--
ALTER TABLE `CategoryHistory`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `CategoryTypes`
--
ALTER TABLE `CategoryTypes`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `Chitante`
--
ALTER TABLE `Chitante`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `Connections`
--
ALTER TABLE `Connections`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `Devize`
--
ALTER TABLE `Devize`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `Etichete`
--
ALTER TABLE `Etichete`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `FiscalSettings`
--
ALTER TABLE `FiscalSettings`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `FiseNecesar`
--
ALTER TABLE `FiseNecesar`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `FiseProductie`
--
ALTER TABLE `FiseProductie`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `FiseRetur`
--
ALTER TABLE `FiseRetur`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `Furnizori`
--
ALTER TABLE `Furnizori`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `GestiuneClientiFacturi`
--
ALTER TABLE `GestiuneClientiFacturi`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `IngredienteFisaNecesar`
--
ALTER TABLE `IngredienteFisaNecesar`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `Produs` (`ProdusId`),
  ADD KEY `NecesarId` (`NecesarId`);

--
-- Indexes for table `IngredienteFisaProductie`
--
ALTER TABLE `IngredienteFisaProductie`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `Produs` (`ProdusId`),
  ADD KEY `ProductieId` (`ProductieId`),
  ADD KEY `ProdusFisaId` (`ProdusFisaId`);

--
-- Indexes for table `Ingredients`
--
ALTER TABLE `Ingredients`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `Produs` (`IngredientId`),
  ADD KEY `RecipeId` (`RecipeId`);

--
-- Indexes for table `IntinzatorDeGarnitura`
--
ALTER TABLE `IntinzatorDeGarnitura`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `InventarHistory`
--
ALTER TABLE `InventarHistory`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `LOG`
--
ALTER TABLE `LOG`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `LogDangerousActions`
--
ALTER TABLE `LogDangerousActions`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `LogDoc`
--
ALTER TABLE `LogDoc`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `LogVanzare`
--
ALTER TABLE `LogVanzare`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `MarimiProduseAviz`
--
ALTER TABLE `MarimiProduseAviz`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `Produs` (`ProdusId`);

--
-- Indexes for table `MarimiProduseBonConsum`
--
ALTER TABLE `MarimiProduseBonConsum`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `MarimiProduseFisaRetur`
--
ALTER TABLE `MarimiProduseFisaRetur`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `MarimiProduseNIR`
--
ALTER TABLE `MarimiProduseNIR`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `MarimiProduseNIRAux`
--
ALTER TABLE `MarimiProduseNIRAux`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `MetroReports`
--
ALTER TABLE `MetroReports`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `NIRuri`
--
ALTER TABLE `NIRuri`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `NIRUsers`
--
ALTER TABLE `NIRUsers`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `OptiuniMeniu`
--
ALTER TABLE `OptiuniMeniu`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `Packages`
--
ALTER TABLE `Packages`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `PaymentTypes`
--
ALTER TABLE `PaymentTypes`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `PendingProducts`
--
ALTER TABLE `PendingProducts`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `PlatiFacturi`
--
ALTER TABLE `PlatiFacturi`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `PlatiNIRuri`
--
ALTER TABLE `PlatiNIRuri`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `PlatiNIRuriHistory`
--
ALTER TABLE `PlatiNIRuriHistory`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `Printers`
--
ALTER TABLE `Printers`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `ProductHistory`
--
ALTER TABLE `ProductHistory`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `ProductRecipes`
--
ALTER TABLE `ProductRecipes`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `ProductId` (`ProductId`),
  ADD KEY `RecipeId` (`RecipeId`);

--
-- Indexes for table `Products`
--
ALTER TABLE `Products`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `Products1`
--
ALTER TABLE `Products1`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `ProduseAviz`
--
ALTER TABLE `ProduseAviz`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `Produs` (`ProdusId`),
  ADD KEY `AvizId` (`AvizId`);

--
-- Indexes for table `ProduseBonConsum`
--
ALTER TABLE `ProduseBonConsum`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `Produs` (`ProdusId`),
  ADD KEY `BonId` (`BonId`);

--
-- Indexes for table `ProduseBonTransfer`
--
ALTER TABLE `ProduseBonTransfer`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `Produs` (`ProdusId`),
  ADD KEY `TransferId` (`TransferId`);

--
-- Indexes for table `ProduseDeviz`
--
ALTER TABLE `ProduseDeviz`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `ProduseFacturaAnulata`
--
ALTER TABLE `ProduseFacturaAnulata`
  ADD PRIMARY KEY (`ID`),
  ADD KEY `Produs` (`IdP`),
  ADD KEY `FacturaId` (`FacturaId`);

--
-- Indexes for table `ProduseFisaNecesar`
--
ALTER TABLE `ProduseFisaNecesar`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `Produs` (`ProdusId`),
  ADD KEY `NecesarId` (`NecesarId`);

--
-- Indexes for table `ProduseFisaProductie`
--
ALTER TABLE `ProduseFisaProductie`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `Produs` (`ProdusId`),
  ADD KEY `ProductieId` (`ProductieId`);

--
-- Indexes for table `ProduseFisaRetur`
--
ALTER TABLE `ProduseFisaRetur`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `Produs` (`ProdusId`),
  ADD KEY `FisaId` (`FisaId`);

--
-- Indexes for table `ProduseNIR`
--
ALTER TABLE `ProduseNIR`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `Produs` (`ProdusId`),
  ADD KEY `NIRId` (`NIRId`);

--
-- Indexes for table `ProduseNIRAux`
--
ALTER TABLE `ProduseNIRAux`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `Produs` (`ProdusId`),
  ADD KEY `NIRId` (`NIRId`);

--
-- Indexes for table `RecieptTransactions`
--
ALTER TABLE `RecieptTransactions`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `Recipes`
--
ALTER TABLE `Recipes`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `SmartInvoicePayments`
--
ALTER TABLE `SmartInvoicePayments`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `SmartPayments`
--
ALTER TABLE `SmartPayments`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `SQLHistory`
--
ALTER TABLE `SQLHistory`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `SubcategoryHistory`
--
ALTER TABLE `SubcategoryHistory`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `SubcategoryTypes`
--
ALTER TABLE `SubcategoryTypes`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `TableTypes`
--
ALTER TABLE `TableTypes`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `Tags`
--
ALTER TABLE `Tags`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `DocType` (`DocType`);

--
-- Indexes for table `TCategorii`
--
ALTER TABLE `TCategorii`
  ADD PRIMARY KEY (`IDCategorie`),
  ADD KEY `TipCategorie` (`TipCategorie`);

--
-- Indexes for table `TClienti`
--
ALTER TABLE `TClienti`
  ADD PRIMARY KEY (`ID`),
  ADD KEY `CodClient` (`CodClient`);

--
-- Indexes for table `TClientiFactura`
--
ALTER TABLE `TClientiFactura`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `TDateFirma`
--
ALTER TABLE `TDateFirma`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `Template`
--
ALTER TABLE `Template`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `TErori`
--
ALTER TABLE `TErori`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `TFacturi`
--
ALTER TABLE `TFacturi`
  ADD PRIMARY KEY (`ID`),
  ADD KEY `NumarFactura` (`NumarFactura`),
  ADD KEY `UserId` (`UserId`);

--
-- Indexes for table `TFacturiClienti`
--
ALTER TABLE `TFacturiClienti`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `TFacturiProduse`
--
ALTER TABLE `TFacturiProduse`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `TInventar`
--
ALTER TABLE `TInventar`
  ADD PRIMARY KEY (`ProdusId`);

--
-- Indexes for table `TInventarUsers`
--
ALTER TABLE `TInventarUsers`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `TMarimi`
--
ALTER TABLE `TMarimi`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `ForeignKey` (`ProdusId`);

--
-- Indexes for table `TMarimiBonActivTemp`
--
ALTER TABLE `TMarimiBonActivTemp`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `TMese`
--
ALTER TABLE `TMese`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `TModificarePret`
--
ALTER TABLE `TModificarePret`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `TModificarePretProduse`
--
ALTER TABLE `TModificarePretProduse`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `Topping`
--
ALTER TABLE `Topping`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `TProduse`
--
ALTER TABLE `TProduse`
  ADD PRIMARY KEY (`ID`),
  ADD KEY `IDSUBCATEGORIE` (`IDSubCategorie`);

--
-- Indexes for table `TProduseBarcode`
--
ALTER TABLE `TProduseBarcode`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `TProduseBonActiv`
--
ALTER TABLE `TProduseBonActiv`
  ADD PRIMARY KEY (`ID`),
  ADD KEY `IDPRODUS` (`IDProdus`);

--
-- Indexes for table `TProduseBonActivTemp`
--
ALTER TABLE `TProduseBonActivTemp`
  ADD PRIMARY KEY (`ID`),
  ADD KEY `IDPRODUS` (`IDProdus`);

--
-- Indexes for table `TRegistru`
--
ALTER TABLE `TRegistru`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `TReturClient`
--
ALTER TABLE `TReturClient`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `TSali`
--
ALTER TABLE `TSali`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `TSerieF`
--
ALTER TABLE `TSerieF`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `TStocuriTura`
--
ALTER TABLE `TStocuriTura`
  ADD PRIMARY KEY (`ID`),
  ADD KEY `IDPRODUS` (`IDPRODUS`),
  ADD KEY `IDTURA` (`IDTURA`);

--
-- Indexes for table `TSubCategorii`
--
ALTER TABLE `TSubCategorii`
  ADD PRIMARY KEY (`IDSubCategorie`),
  ADD KEY `Categorie` (`IdCategorie`);

--
-- Indexes for table `TTure`
--
ALTER TABLE `TTure`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `TTVA`
--
ALTER TABLE `TTVA`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `TUsers`
--
ALTER TABLE `TUsers`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `TVoucher`
--
ALTER TABLE `TVoucher`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `TZ`
--
ALTER TABLE `TZ`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `UserId` (`UserId`),
  ADD KEY `IdTura` (`IdTura`),
  ADD KEY `DataBon` (`DataBon`);

--
-- Indexes for table `TZCarduri`
--
ALTER TABLE `TZCarduri`
  ADD PRIMARY KEY (`ID`);

--
-- Indexes for table `TZMarimi`
--
ALTER TABLE `TZMarimi`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `TZProdus`
--
ALTER TABLE `TZProdus`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `IDPRODUS` (`IdProdus`) USING BTREE,
  ADD KEY `IdBon` (`IdBon`),
  ADD KEY `IdClient` (`IDClient`);

--
-- Indexes for table `TZProduseTUTA`
--
ALTER TABLE `TZProduseTUTA`
  ADD PRIMARY KEY (`Id`),
  ADD KEY `IDPRODUS` (`IdProdus`);

--
-- Indexes for table `TZTure`
--
ALTER TABLE `TZTure`
  ADD PRIMARY KEY (`ID`),
  ADD UNIQUE KEY `IDTura` (`IDTura`);

--
-- Indexes for table `userlogin`
--
ALTER TABLE `userlogin`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `UserTypes`
--
ALTER TABLE `UserTypes`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `user_login`
--
ALTER TABLE `user_login`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `VATDetails`
--
ALTER TABLE `VATDetails`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `Webcommerce`
--
ALTER TABLE `Webcommerce`
  ADD PRIMARY KEY (`Id`);

--
-- Indexes for table `_Settings`
--
ALTER TABLE `_Settings`
  ADD PRIMARY KEY (`Id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `ActionTypes`
--
ALTER TABLE `ActionTypes`
  MODIFY `Id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `AdreseLivrrare`
--
ALTER TABLE `AdreseLivrrare`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `Atribute`
--
ALTER TABLE `Atribute`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `Avize`
--
ALTER TABLE `Avize`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `BankDetails`
--
ALTER TABLE `BankDetails`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'It should start from 2';

--
-- AUTO_INCREMENT for table `BonTransfer`
--
ALTER TABLE `BonTransfer`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `BonuriAvize`
--
ALTER TABLE `BonuriAvize`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `BonuriConsum`
--
ALTER TABLE `BonuriConsum`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `BonuriFacturi`
--
ALTER TABLE `BonuriFacturi`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `Calls`
--
ALTER TABLE `Calls`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `CategoryHistory`
--
ALTER TABLE `CategoryHistory`
  MODIFY `Id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=27;

--
-- AUTO_INCREMENT for table `CategoryTypes`
--
ALTER TABLE `CategoryTypes`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `Chitante`
--
ALTER TABLE `Chitante`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `Connections`
--
ALTER TABLE `Connections`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `Devize`
--
ALTER TABLE `Devize`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `Etichete`
--
ALTER TABLE `Etichete`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `FiscalSettings`
--
ALTER TABLE `FiscalSettings`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `FiseNecesar`
--
ALTER TABLE `FiseNecesar`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `FiseProductie`
--
ALTER TABLE `FiseProductie`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `FiseRetur`
--
ALTER TABLE `FiseRetur`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `Furnizori`
--
ALTER TABLE `Furnizori`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `GestiuneClientiFacturi`
--
ALTER TABLE `GestiuneClientiFacturi`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `IngredienteFisaNecesar`
--
ALTER TABLE `IngredienteFisaNecesar`
  MODIFY `Id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `IngredienteFisaProductie`
--
ALTER TABLE `IngredienteFisaProductie`
  MODIFY `Id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `Ingredients`
--
ALTER TABLE `Ingredients`
  MODIFY `Id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `IntinzatorDeGarnitura`
--
ALTER TABLE `IntinzatorDeGarnitura`
  MODIFY `Id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `InventarHistory`
--
ALTER TABLE `InventarHistory`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `LOG`
--
ALTER TABLE `LOG`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `LogDangerousActions`
--
ALTER TABLE `LogDangerousActions`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `LogDoc`
--
ALTER TABLE `LogDoc`
  MODIFY `Id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `LogVanzare`
--
ALTER TABLE `LogVanzare`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `MarimiProduseAviz`
--
ALTER TABLE `MarimiProduseAviz`
  MODIFY `Id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `MarimiProduseBonConsum`
--
ALTER TABLE `MarimiProduseBonConsum`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `MarimiProduseFisaRetur`
--
ALTER TABLE `MarimiProduseFisaRetur`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `MarimiProduseNIR`
--
ALTER TABLE `MarimiProduseNIR`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `MarimiProduseNIRAux`
--
ALTER TABLE `MarimiProduseNIRAux`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `MetroReports`
--
ALTER TABLE `MetroReports`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `NIRuri`
--
ALTER TABLE `NIRuri`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `NIRUsers`
--
ALTER TABLE `NIRUsers`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `OptiuniMeniu`
--
ALTER TABLE `OptiuniMeniu`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `Packages`
--
ALTER TABLE `Packages`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `PaymentTypes`
--
ALTER TABLE `PaymentTypes`
  MODIFY `Id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `PendingProducts`
--
ALTER TABLE `PendingProducts`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `PlatiFacturi`
--
ALTER TABLE `PlatiFacturi`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `PlatiNIRuri`
--
ALTER TABLE `PlatiNIRuri`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `PlatiNIRuriHistory`
--
ALTER TABLE `PlatiNIRuriHistory`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `Printers`
--
ALTER TABLE `Printers`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ProductHistory`
--
ALTER TABLE `ProductHistory`
  MODIFY `Id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ProductRecipes`
--
ALTER TABLE `ProductRecipes`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `Products`
--
ALTER TABLE `Products`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `Products1`
--
ALTER TABLE `Products1`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ProduseAviz`
--
ALTER TABLE `ProduseAviz`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ProduseBonConsum`
--
ALTER TABLE `ProduseBonConsum`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ProduseBonTransfer`
--
ALTER TABLE `ProduseBonTransfer`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ProduseDeviz`
--
ALTER TABLE `ProduseDeviz`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ProduseFacturaAnulata`
--
ALTER TABLE `ProduseFacturaAnulata`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ProduseFisaNecesar`
--
ALTER TABLE `ProduseFisaNecesar`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ProduseFisaProductie`
--
ALTER TABLE `ProduseFisaProductie`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ProduseFisaRetur`
--
ALTER TABLE `ProduseFisaRetur`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ProduseNIR`
--
ALTER TABLE `ProduseNIR`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ProduseNIRAux`
--
ALTER TABLE `ProduseNIRAux`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `RecieptTransactions`
--
ALTER TABLE `RecieptTransactions`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `Recipes`
--
ALTER TABLE `Recipes`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `SmartInvoicePayments`
--
ALTER TABLE `SmartInvoicePayments`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `SmartPayments`
--
ALTER TABLE `SmartPayments`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `SQLHistory`
--
ALTER TABLE `SQLHistory`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=41;

--
-- AUTO_INCREMENT for table `SubcategoryHistory`
--
ALTER TABLE `SubcategoryHistory`
  MODIFY `Id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `SubcategoryTypes`
--
ALTER TABLE `SubcategoryTypes`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `TableTypes`
--
ALTER TABLE `TableTypes`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `Tags`
--
ALTER TABLE `Tags`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TCategorii`
--
ALTER TABLE `TCategorii`
  MODIFY `IDCategorie` int(11) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `TClienti`
--
ALTER TABLE `TClienti`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TClientiFactura`
--
ALTER TABLE `TClientiFactura`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `Template`
--
ALTER TABLE `Template`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TErori`
--
ALTER TABLE `TErori`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TFacturi`
--
ALTER TABLE `TFacturi`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TFacturiClienti`
--
ALTER TABLE `TFacturiClienti`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TFacturiProduse`
--
ALTER TABLE `TFacturiProduse`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TInventarUsers`
--
ALTER TABLE `TInventarUsers`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TMarimi`
--
ALTER TABLE `TMarimi`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TMarimiBonActivTemp`
--
ALTER TABLE `TMarimiBonActivTemp`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TMese`
--
ALTER TABLE `TMese`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=68;

--
-- AUTO_INCREMENT for table `TModificarePret`
--
ALTER TABLE `TModificarePret`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TModificarePretProduse`
--
ALTER TABLE `TModificarePretProduse`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `Topping`
--
ALTER TABLE `Topping`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TProduse`
--
ALTER TABLE `TProduse`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=509;

--
-- AUTO_INCREMENT for table `TProduseBarcode`
--
ALTER TABLE `TProduseBarcode`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TProduseBonActiv`
--
ALTER TABLE `TProduseBonActiv`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `TProduseBonActivTemp`
--
ALTER TABLE `TProduseBonActivTemp`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `TRegistru`
--
ALTER TABLE `TRegistru`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TReturClient`
--
ALTER TABLE `TReturClient`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TSali`
--
ALTER TABLE `TSali`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `TStocuriTura`
--
ALTER TABLE `TStocuriTura`
  MODIFY `ID` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=512;

--
-- AUTO_INCREMENT for table `TSubCategorii`
--
ALTER TABLE `TSubCategorii`
  MODIFY `IDSubCategorie` int(32) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=28;

--
-- AUTO_INCREMENT for table `TTure`
--
ALTER TABLE `TTure`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `TTVA`
--
ALTER TABLE `TTVA`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `TUsers`
--
ALTER TABLE `TUsers`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT for table `TVoucher`
--
ALTER TABLE `TVoucher`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TZ`
--
ALTER TABLE `TZ`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `TZCarduri`
--
ALTER TABLE `TZCarduri`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TZMarimi`
--
ALTER TABLE `TZMarimi`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TZProdus`
--
ALTER TABLE `TZProdus`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TZProduseTUTA`
--
ALTER TABLE `TZProduseTUTA`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `TZTure`
--
ALTER TABLE `TZTure`
  MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `userlogin`
--
ALTER TABLE `userlogin`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `UserTypes`
--
ALTER TABLE `UserTypes`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `user_login`
--
ALTER TABLE `user_login`
  MODIFY `id` int(5) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `VATDetails`
--
ALTER TABLE `VATDetails`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `Webcommerce`
--
ALTER TABLE `Webcommerce`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `_Settings`
--
ALTER TABLE `_Settings`
  MODIFY `Id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

DELIMITER $$
--
-- Events
--
CREATE DEFINER=`local`@`localhost` EVENT `Daily_Worker` ON SCHEDULE EVERY 1 DAY STARTS '2021-04-05 00:00:00' ON COMPLETION PRESERVE ENABLE COMMENT 'Executes Daily tasks.' DO BEGIN
	CALL RecalculateRegister();
	CALL AutomaticStocks();
	CALL OptimizeTables();
END$$

DELIMITER ;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
