<?php
        
class UserModel extends CI_Model {
    public function __construct() {
        $this->load->database();
    }

    public function get()
    {
    }

    public function get_users($type = NULL)
    {        
        $this->db->select('*');
        if (!empty($type)) {
            $this->db->where('TipUser', $type);
        }
        $this->db->order_by('Id', 'ASC');
        $data = $this->db->get("TUsers")->result();
        return $data;
    }

    public function update_user($data = NULL, $user_id = NULL)
    {
        $this->db->where('Id', $user_id);
        return $this->db->update('TUsers', $data); //Change effect
    }

    public function get_notifications($user_id, $seen = 0)
    {
        $this->db->select('Notifications.*, TUsers.*, TUsers.Timestamp as user_timestamp,  Notifications.Timestamp as Timestamp');
        if (!empty($user_id)) {
            $this->db->where('To', $user_id);
        }
        $this->db->group_start();
        $this->db->where('Seen', $seen);
        $this->db->or_where('To', -1);
        $this->db->group_end();
        $this->db->or_where('Seen', $seen);
		$this->db->join("TUsers", 'TUsers.ID = Notifications.From', 'right');
        $this->db->order_by('Notifications.Timestamp', 'ASC');
        $data = $this->db->get("Notifications")->result();
        // $lastQuery = $this->db->last_query();
        // echo $lastQuery;
        return $data;
    }

    public function create_notification($data)
    {
    // $data = array(
    //     'From' => $from,
    //     'To' => $to,
    //     'Message' => $message,
    //     'Seen' => 0,
    // );
    $result = $this->db->insert('Notifications', $data);
    if ($result) {
        return true;
    } else {
        return false;
    }
    }

    public function mark_notification_as_seen($id)
    {
    $data = array(
        'Seen' => 1
    );
    $this->db->where('Id', $id);
    $result = $this->db->update('Notifications', $data);
    return $result; // Return true if update succeeded, false otherwise
    }

}
