<?php

class TablesModel extends CI_Model
{
	public function __construct()
	{
		$this->load->database();
	}

	public function get($id = 0, $roomId = 0)
	{
		if (!empty($id) && $id > 0) {
			$this->db->select('TMese.ID, TMese.NumeMasa, TMese.IDSala,
                               TMese.Imprimata, TMese.Deschisa, TMese.TableType,
                               RecieptTransactions.BonId, TZ.UserId, TZ.NumeUser, TZ.DataDeschidere');
			$this->db->from("TMese");
			$this->db->join("TProduseBonActiv", 'TMese.ID = TProduseBonActiv.IDMasaActiva', 'left');
			$this->db->join("TZ", 'TZ.Id = TProduseBonActiv.IdBonTemp', 'left');
			$this->db->where(['TMese.ID' => $id]);
			$this->db->order_by('(NumeMasa) DESC, CAST(NumeMasa AS UNSIGNED), NumeMasa');
			$data = $this->db->get()->row_array();
		} else if (!empty($roomId) && $roomId > 0) {
			$this->db->select('TMese.ID, TMese.NumeMasa, TMese.IDSala,
                                   TMese.Imprimata, TMese.Deschisa, TMese.TableType,
                                   TZ.UserId, TZ.NumeUser, TZ.DataDeschidere');
			$this->db->from("TMese");
			$this->db->join("TProduseBonActiv", 'TMese.ID = TProduseBonActiv.IDMasaActiva', 'left');
			$this->db->join("TZ", 'TZ.Id = TProduseBonActiv.IdBonTemp', 'left');
			$this->db->where(['TMese.IDSala' => $roomId]);
			$this->db->group_by("TMese.ID");
			$this->db->order_by('(NumeMasa) DESC, CAST(NumeMasa AS UNSIGNED), NumeMasa');
			$data = $this->db->get()->result();
		} else {
			$this->db->select('TMese.ID, TMese.NumeMasa, TMese.IDSala, 
                                   TMese.Imprimata, TMese.Deschisa, TMese.TableType, 
                                   TZ.UserId, TZ.NumeUser, TZ.DataDeschidere');
			$this->db->from("TMese");
			$this->db->join("TProduseBonActiv", 'TMese.ID = TProduseBonActiv.IDMasaActiva', 'left');
			$this->db->join("TZ", 'TZ.Id = TProduseBonActiv.IdBonTemp', 'left');
			$this->db->group_by("TMese.ID");
			$this->db->order_by('(NumeMasa) DESC, CAST(NumeMasa AS UNSIGNED), NumeMasa');
			$data = $this->db->get()->result();
		}
		return $data;
	}
	public function table_lock($input)
	{
		$this->db->set('Deschisa', 1);
		$this->db->where('ID', $input);
		return $this->db->update('TMese');
	}

	public function table_unlock($input)
	{
		$this->db->set('Deschisa', 0);
		$this->db->where('ID', $input);
		return $this->db->update('TMese');
	}

	public function table_validator($input)
	{
		$this->db->select('Count(*) as Nr');
		$this->db->where('ID', $input);
		$this->db->from("TMese");
		return $this->db->get()->row_object()->Nr;
	}

	public function open_validator($input)
	{
		$this->db->select('Deschisa');
		$this->db->where(['ID' => $input]);
		$this->db->from("TMese");
		return $this->db->get()->row_object()->Deschisa;
	}
}
