<?php

class OrdersModel extends CI_Model
{
	public function __construct()
	{
		$this->load->database();
		$this->load->model('TablesModel');
	}

	public function get($id = 0, &$tableId = 0)
	{
		if (!empty($id)) {
			$this->db->select('TZ.Id as OrderId, TZ.UserId, TZ.NumeUser, TZ.DataDeschidere, 
			tp.IDMasaActiva as TableId, TZ.NrOrdine, tp.DiscountBon, TZ.IdBonTemporar');
			$this->db->from("TProduseBonActiv as tp");
			$this->db->join("TZ", 'TZ.Id = tp.IdBonTemp');
			$this->db->where(['TZ.Id' => $id]);
			$this->db->group_by("TZ.Id");
			$data = $this->db->get()->row_array();
		} else {
			if (!empty($tableId) && $tableId > 0) {
				if ($this->TablesModel->table_lock($tableId) > 0) {

					$this->db->select('TZ.Id as OrderId, TZ.UserId, TZ.NumeUser, TZ.DataDeschidere, 
					tp.IDMasaActiva as TableId, tp.DiscountBon, TZ.IdBonTemporar');
					$this->db->from("TProduseBonActiv as tp");
					$this->db->join("TZ", 'TZ.Id = tp.IdBonTemp', 'right');
					$this->db->where(['tp.IDMasaActiva' => $tableId]);
					$this->db->group_by("TZ.Id");
					$data = $this->db->get()->result();
				} else {
					$data = [];
					$tableId = -1;
				}
			} else {
				$this->db->select('TZ.Id as OrderId, TZ.UserId, TZ.NumeUser, TZ.DataDeschidere, 
				tp.IDMasaActiva as TableId, tp.DiscountBon, TZ.IdBonTemporar');
				$this->db->from("TProduseBonActiv as tp");
				$this->db->join("TZ", 'TZ.Id = tp.IdBonTemp');
				$this->db->group_by("TZ.Id");
				$data = $this->db->get()->result();
			}
		}
		return $data;
	}

	// This function retrieves all orders from the database
	public function get_all_mesajes($messageType = NULL)
	{
		$this->db->select('*');
		$this->db->from("mesaje as tp");
		$messageType ? $this->db->where(['MessageType' => $messageType]) : null;
		$data = $this->db->get()->result();
		return $data;
	}

	// This function retrieves all orders from the database
	public function get_orders()
	{
		$this->db->select('TZ.Id as OrderId,TZ.BonActiv as BonActiv, TZ.UserId, TZ.TotalFiscal, TZ.Card, TZ.Numerar, TZ.NumeUser, TZ.DataDeschidere, 
		tp.IDMasaActiva as TableId, tp.DiscountBon, TZ.IdBonTemporar');
		$this->db->from("TProduseBonActiv as tp");
		$this->db->join("TZ", 'TZ.BonActiv = tp.IdBonTemp', 'right');
		$this->db->group_by("TZ.BonActiv");
		// $this->db->where(['TZ.Close' => 1]);
		$data = $this->db->get()->result();
		return $data;
	}

	public function get_last_id()
	{
		$this->db->select('Id');
		$this->db->from("TZ");
		$this->db->order_by('Id', 'DESC');
		$this->db->limit(1);
		$data = $this->db->get()->row_array();
		if (empty($data))
			$data = array("Id" => "0");
		return $data;
	}

	public function get_order_number()
	{
		$this->db->select('(NrOrdine+1) NrOrdine');
		$this->db->from("TSerieF");
		$this->db->limit(1);
		$data = $this->db->get()->row_array();
		if (empty($data))
			$data = array("NrOrdine" => "1");

		$this->db->set('NrOrdine', $data['NrOrdine']);
		$this->db->update('TSerieF');

		return $data;
	}

	public function post($input, $tableId)
	{
		$this->TablesModel->table_unlock($tableId);
		$this->db->insert('TZ', $input);
		if ($this->db->error()["code"] > 0) {
			$result = 'Error! [' . $this->db->_error_message() . ']';
		} else if (!$this->db->affected_rows()) {
			$result = 'Rows affected ' . $this->db->affected_rows();
		} else {
			$result = 'Success';
		}
		return $result;
	}

	public function put($input, $id)
	{
		$this->db->update('TProduseBonActiv', $input, array('ID' => $id));
		if ($this->db->_error_message()) {
			$result = 'Error! [' . $this->db->_error_message() . ']';
		} else if (!$this->db->affected_rows()) {
			$result = 'Error! ID [' . $id . '] not found';
		} else {
			$result = 'Success';
		}
		return $result;
	}
	public function validate_user($data, $tableId)
	{
		$response = (object)array(
			'result' => true,
			'userId' => 0,
			'username' => 0
		);

		$this->db->select('TMese.ID, TZ.NumeUser, TZ.UserId');
		$this->db->from("TMese");
		$this->db->join("TProduseBonActiv", 'TMese.ID = TProduseBonActiv.IDMasaActiva', 'left');
		$this->db->join("TZ", 'TZ.Id = TProduseBonActiv.IdBonTemp', 'left');
		$this->db->where(['TMese.ID' => $tableId]);
		$result = $this->db->get()->row_object();

		if (empty($result) || empty($result->ID)) {
			$response->result = false;
			return $response;
		} else if (empty($result->UserId)) {
			return $response;
		}

		$response->result = $result->UserId == $data->id || $data->role == 'admin';
		$response->userId = $result->UserId;
		$response->username = $result->NumeUser;
		return $response;
	}

	public function update_print($orderId, $printValus)
	{
		
		$this->db->set('Print', $printValus, false);
		$this->db->where('Id', $orderId);
		$this->db->update('TZ');
		if ($this->db->error()["code"] > 0) {
			$result = 'Error! [' . $this->db->error()["message"] . ']';
		} else {
			$result = 'Success';
		}
		return $result;
	}

	public function update_close_order($typeColumn, $total, $orderId)
	{
		
		$this->db->set($typeColumn, $total);
		$this->db->set('TotalFiscal', $total);
		$this->db->set('Close', 1);
		$this->db->where('Id', $orderId);
		$this->db->update('TZ');
		if ($this->db->error()["code"] > 0) {
			$result = 'Error! [' . $this->db->error()["message"] . ']';
		} else {
			$result = 'Success';
		}
		return $result;
	}
}
