<?php

class OrderItemsModel extends CI_Model
{
	public function __construct()
	{
		$this->load->database();
	}

	public function get($id = 0, $bonId = 0)
	{
		if (!empty($id)) {
			$this->db->select('tp.ID as OrderItemId, TProduse.ID as ProductId, 
			TProduse.IDSubCategorie, TProduse.Denumire, TProduse.Pret, TProduse.UM, 
            tp.Cantitate as Quantity, tp.Discount, tp.DiscountBon, tp.Comentarii');
			$this->db->from("TProduseBonActiv as tp");
			$this->db->join("TProduse", 'TProduse.ID = tp.IDProdus', 'left');
			$this->db->where(['tp.ID' => $id]);
			$data = $this->db->get()->row_array();
		} else {
			if (!empty($bonId) && $bonId > 0) {
				$this->db->select('tp.ID as OrderItemId, TProduse.ID as ProductId, 
				TProduse.IDSubCategorie, TProduse.Denumire, TProduse.Pret, TProduse.UM, 
                tp.Cantitate as Quantity, tp.Discount, tp.DiscountBon, tp.Comentarii');
				$this->db->from("TProduseBonActiv as tp");
				$this->db->join("TProduse", 'TProduse.ID = tp.IDProdus', 'left');
				$this->db->where(['tp.IdBonTemp' => $bonId]);
				$data = $this->db->get()->result();
			} else {
				$this->db->select('tp.ID as OrderItemId, TProduse.ID as ProductId, 
				TProduse.IDSubCategorie, TProduse.Denumire, TProduse.Pret, TProduse.UM, 
                tp.Cantitate as Quantity, tp.Discount, tp.DiscountBon, tp.Comentarii');
				$this->db->from("TProduseBonActiv as tp");
				$this->db->join("TProduse", 'TProduse.ID = tp.IDProdus', 'left');
				$data = $this->db->get()->result();
			}
		}
		return $data;
	}

	public function getInternal($bonId = 0)
	{
		$this->db->select('tp.ID, tp.IDProdus, tp.IdUser, tp.IdBonTemp, tp.IDMasaActiva, 
				tp.Imprimat, tp.InLucru, tp.Cantitate, tp.Discount, tp.DiscountBon, tp.Comentarii');
		$this->db->from("TProduseBonActiv as tp");
		$this->db->where(['tp.IdBonTemp' => $bonId]);
		$data = $this->db->get()->result();
		return $data;
	}

	public function getProductsInOrder($orderId = 0)
	{
		$this->db->select('tp.ID, tp.IDProdus, tp.IdUser, tp.IdBonTemp, tp.IDMasaActiva,
		TProduse.IDSubCategorie, TProduse.Denumire, TProduse.Pret, TProduse.UM, 
                tp.Cantitate as Quantity,
				tp.Imprimat, tp.InLucru, tp.Cantitate, tp.Discount, tp.DiscountBon, tp.Comentarii');
		$this->db->from("TProduseBonActiv as tp");
		$this->db->join("TProduse", 'TProduse.ID = tp.IDProdus');
		$this->db->where(['tp.IdBonTemp' => $orderId]);
		// $this->db->group_by("tp.IDProdus");
		$data = $this->db->get()->result();
		return $data;
	}

	public function product_validator($input)
	{
		$this->db->select('Count(*) as Nr');
		$this->db->where_in('ID', $input);
		$this->db->from("TProduse");
		return $this->db->get()->row_object()->Nr;
	}

	public function post_batch($input)
	{
		$this->db->insert_batch('TProduseBonActiv', $input);
		if ($this->db->error()["code"] > 0) {
			$result = 'Error! [' . $this->db->error()["message"] . ']';
		} else if (!$this->db->affected_rows()) {
			$result = 'Rows affected ' . $this->db->affected_rows();
		} else {
			$result = 'Success';
		}
		return $result;
	}

	public function post_batch_temp($input)
	{
		$this->db->insert_batch('TProduseBonActivTemp', $input);
		if ($this->db->error()["code"] > 0) {
			$result = 'Error! [' . $this->db->error()["message"] . ']';
		} else if (!$this->db->affected_rows()) {
			$result = 'Rows affected ' . $this->db->affected_rows();
		} else {
			$result = 'Success';
		}
		return $result;
	}

	public function put_batch($input)
	{
		$this->db->update_batch('TProduseBonActiv', $input, "ID");
		if ($this->db->error()["code"] > 0) {
			$result = 'Error! [' . $this->db->error()["message"] . ']';
		} else if (!$this->db->affected_rows()) {
			$result = 'Rows affected  ' . $this->db->affected_rows();
		} else {
			$result = 'Success';
		}
		return $result;
	}
	public function delete_batch($ids)
	{
		$this->db->where_in('Id', $ids);
		$this->db->delete('RecieptTransactions');
		if ($this->db->error()["code"] > 0) {
			$result = 'Error! [' . $this->db->error()["message"] . ']';
		} else if (!$this->db->affected_rows()) {
			$result = 'Rows affected ' . $this->db->affected_rows();
		} else {
			$result = 'Success';
		}
		return $result;
	}

	public function delete_order_item_from_bon($id)
	{
		$this->db->where('ID', $id);
		$this->db->delete('TProduseBonActiv');
		if ($this->db->error()["code"] > 0) {
			$result = 'Error! [' . $this->db->error()["message"] . ']';
		} else if (!$this->db->affected_rows()) {
			$result = 'Rows affected ' . $this->db->affected_rows();
		} else {
			$result = 'Success';
		}
		return $result;
	}
	
	public function temp_bon_items_delete_where_bon_id_is($orderId)
	{
		$this->db->where('IdBonTemp', $orderId);
		$this->db->delete('TProduseBonActivTemp');
		if ($this->db->error()["code"] > 0) {
			$result = 'Error! [' . $this->db->error()["message"] . ']';
		} else if (!$this->db->affected_rows()) {
			$result = 'Rows affected ' . $this->db->affected_rows();
		} else {
			$result = 'Success';
		}
		return $result;
	}
	
	public function active_bon_items_delete_where_table_is($orderId)
	{
		$this->db->where('IdBonTemp', $orderId);
		$this->db->delete('TProduseBonActiv');
		if ($this->db->error()["code"] > 0) {
			$result = 'Error! [' . $this->db->error()["message"] . ']';
		} else if (!$this->db->affected_rows()) {
			$result = 'Rows affected ' . $this->db->affected_rows();
		} else {
			$result = 'Success';
		}
		return $result;
	}
	
}
