<?php

class NIRsUserModel extends CI_Model
{
	public function __construct()
	{
		$this->load->database();
	}
	public function getByBarcode($barCode = '')
	{
		$data = [];
		if (!empty($barCode)) {
			$this->db->select('nu.Id, p.ID as ProductId, p.Denumire as Name, p.Pret as Price, 
			p.UM as MesurementUnit, p.Stoc as ProductStock, nu.Quantity, nu.Value, 
			IFNULL(tva.Denumire, "N/A") as VATName, p.PretAchizitie as SupplierPrice, 
			p.CodBare as BarCode, IFNULL(tvaf.Denumire, "N/A") as SupplierVATName');
			$this->db->from("TProduse as p");
			$this->db->join("TTVA as tva", 'p.TVA = tva.ID', 'left');
			$this->db->join("TTVA as tvaf", 'p.TVAF = tvaf.ID', 'left');
			$this->db->join("NIRUsers as nu", 'nu.ProductId = p.ID', 'left');
			$this->db->where('p.CodBare', $barCode);
			$data =  $this->db->get()->row_object();
			if (empty($data)) {
				$this->db->select('nu.Id, pp.ID as PendingId, pp.Denumire as Name, 
				nu.Quantity, nu.Value, pp.CodBare as BarCode');
				$this->db->from("PendingProducts as pp");
				$this->db->join("NIRUsers as nu", 'nu.PendingId = pp.Id', 'left');
				$this->db->where('pp.CodBare', $barCode);
				$data =  $this->db->get()->row_object();
			}
			// $this->db->join("PendingProducts as pp", "p.CodBare =" . ${$barCode}, 'left'); pp.Id as PendingId,pp.CodBare
		}
		if (empty($data)) {
			$data = (object)array(
				'BarCode' => $barCode
			);
		}
		return $data;
	}
	public function get($id = 0, $number = 0, $page = 0)
	{
		$data = [];
		if (!empty($id) && $id > 0) {
			$this->db->select('IFNULL(TProduse.Denumire, PendingProducts.Denumire) as Name, NIRUsers.Quantity, NIRUsers.Value');
			$this->db->from("NIRUsers");
			$this->db->join("TProduse", 'TProduse.ID = NIRUsers.ProductId', 'left');
			$this->db->join("PendingProducts", 'PendingProducts.Id = NIRUsers.PendingId', 'left');
			$this->db->where(['NIRUsers.UserId' => $id]);
			if ($number > 0) {
				$this->db->limit($number);
				$this->db->offset($number * $page);
			} else {
				$this->db->limit(8);
				$this->db->offset(8 * $page);
			}
			$this->db->order_by('NIRUsers.Id', 'DESC');
			$data =  $this->db->get()->result();
		}
		return $data;
	}
	public function post($input)
	{
		$this->db->insert('NIRUsers', $input);
		if ($this->db->error()["code"] > 0) {
			$result = 'Error! [' . $this->db->_error_message() . ']';
		} else if (!$this->db->affected_rows()) {
			$result = 'Rows affected ' . $this->db->affected_rows();
		} else {
			$result = 'Success';
		}
		return $result;
	}
	public function put($input, $id)
	{
		$this->db->set('Quantity', $input->Quantity, false);
		$this->db->set('Value', $input->Value, false);
		$this->db->set('UserId', $input->UserId, false);
		$this->db->where('Id', $id);
		$this->db->update('NIRUsers');

		if ($this->db->error()["code"] > 0) {
			$result = 'Error! [' . $this->db->error()["message"] . ']';
		} else if (!$this->db->affected_rows()) {
			$result = 'Rows affected ' . $this->db->affected_rows();
		} else {
			$result = 'Success';
		}
		return $result;
	}
}
