<?php
        
class InventoryUserModel extends CI_Model {
    public function __construct() {
        $this->load->database();
    }
    public function get($id = 0, $number=0, $page=0)
    {
        $data=[];
        if(!empty($id) && $id > 0){
            $this->db->select('TInventarUsers.ProductId, TProduse.Denumire as Name, TInventarUsers.Quantity');
            $this->db->from("TInventarUsers");
            $this->db->join("TProduse", 'TProduse.ID = TInventarUsers.ProductId');
            $this->db->where(['TInventarUsers.UserId' => $id]);
            if($number > 0){
                $this->db->limit($number);
                $this->db->offset($number*$page);
            }
            else{
                $this->db->limit(8);
                $this->db->offset(8*$page);
            }
            $this->db->order_by('TInventarUsers.Id', 'DESC');
            $data =  $this->db->get()->result();
        }
        return $data;
    }
    public function post($input)
    {
        $this->db->insert('TInventarUsers',$input);
        if ($this->db->error()["code"] > 0) {
            $result = 'Error! ['.$this->db->_error_message().']';
        } else if (!$this->db->affected_rows()) {
            $result = 'Rows affected '.$this->db->affected_rows();
        } else {
            $result = 'Success';
        }   
        return $result;
    } 
}
