<?php

class CategoriesModel extends CI_Model
{
	public function __construct()
	{
		$this->load->database();
	}

	public function get($id = 0)
	{
		if (!empty($id)) {
			$data = $this->db->get_where("TCategorii", ['IDCategorie' => $id])->row_array();
		} else {
			$this->db->from("TCategorii");
			$this->db->order_by('NumeCategorie', 'ASC');
			$data = $this->db->get()->result();
		}
		return $data;
	}

	public function post($input)
	{
		return $this->db->insert('TCategorii', $input);
	}

	public function put($input, $id)
	{
		$this->db->update('TCategorii', $input, array('IDCategorie' => $id));
		if ($this->db->_error_message()) {
			$result = 'Error! [' . $this->db->_error_message() . ']';
		} else if (!$this->db->affected_rows()) {
			$result = 'Error! ID [' . $id . '] not found';
		} else {
			$result = 'Success';
		}
		return $result;
	}
	public function index_delete($id)
	{
		$this->db->delete('TCategorii', array('IDCategorie' => $id));
		if ($this->db->_error_message()) {
			$result = 'Error! [' . $this->db->_error_message() . ']';
		} else if (!$this->db->affected_rows()) {
			$result = 'Error! ID [' . $id . '] not found';
		} else {
			$result = 'Success';
		}
		return $result;
	}
}
