<?php

//require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'controllers/Api.php';
class Receipt extends Api
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('TureModel');
        $this->load->model('OrdersModel');
        $this->load->model('TablesModel');
        $this->load->model('ProductsModel');
        $this->load->model('OrderItemsModel');
    }
    public function index_post()
    {
        $data = parent::verify_request();
        $app_id = parent::verify_app_id();
        if ($app_id != 1) {
            $status = parent::HTTP_UNAUTHORIZED;
            $response = ['status' => $status, 'error' => 'Unauthorized Access! '];
            $this->response($response, $status);
            $this->output->_display();
            exit();
        }
        file_get_contents('php://input');
        $input = (array)$this->post();
        if (empty($input)) {
            $this->response($input, REST_Controller::HTTP_BAD_REQUEST);
            exit();
        }
        $now = date('Y-m-d H:i:s');
        $products = array();
        $bon = (object)$this->OrdersModel->get_last_id();
        $order = (object)$this->OrdersModel->get_order_number();
        $turaId = (object)$this->TureModel->get_last_id();
        $bonHeader = (object)array(
            'UserId' => $data->id,
            'NumeUser' => $data->username,
            'BonActiv' => '1',
            'Data' => $now,
            'CodClient' => '-1',
            'NrOrdine' => $order->NrOrdine,
            'TipVanzare' => '0',
            'IdTura' => $turaId->Id,
            'IdBonTemporar' => ($bon->Id + 1),
            'TotalProtocol' => '0',
            'TotalFiscal' => '0'
        );
        foreach ($input as &$p) {
            $p = (object)$p;
            if (!in_array($p->ProductId, array_column($products, 'IDProdus'), $strict = true)) {
                array_push($products, (object)array(
                    'IdUser' => $data->id,
                    'IdBonTemp' => ($bon->Id + 1),
                    'IDProdus' => (int)$p->ProductId,
                    'IDMasaActiva' => 0,
                    'Cantitate' => (float)$p->Quantity,
                    'Imprimat' => 0,
                    'InLucru' => 1,
                    'Comentarii' => ''
                ));
            } else {
                foreach ($products as &$prod) {
                    if ($prod->IDProdus == $p->ProductId) {
                        $prod->Cantitate = $prod->Cantitate + $p->Quantity;
                    }
                }
            }
        }
        if (count($products) != $this->OrderItemsModel->product_validator(array_column($products, 'IDProdus'))) {
            $this->response($input, REST_Controller::HTTP_BAD_REQUEST);
            exit();
        }

        $result = array();
        array_push($result, ["Add Order: " => $this->OrdersModel->post($bonHeader, 0)]);
        array_push($result, ["Add Items: " => $this->OrderItemsModel->post_batch($products)]);
        $this->response($result, REST_Controller::HTTP_OK);
    }
}
