<?php

require APPPATH . 'controllers/Api.php';
class Products extends Api
{

	/**
	 * Get All Data from this method.
	 *
	 * @return Response
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('ProductsModel');
	}

	/**
	 * Get All Data from this method.
	 *
	 * @return Response
	 */
	public function index_get($id = 0)
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		$subcategoryId = $this->input->get('SubcategoryId');
		$data = $this->ProductsModel->get($id, $subcategoryId);
		$this->response($data, REST_Controller::HTTP_OK);
	}

	public function filterProducts_get()
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		$filter = $this->input->get('filter');
		$data = $this->ProductsModel->filterProducts($filter);
		$this->response($data, REST_Controller::HTTP_OK);
	}

	public function productInterogation_get()
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		$id = $this->input->get('id');
		$barCode = $this->input->get('BarCode');
		if (!empty($barCode) && $barCode != '') {
			$data = $this->ProductsModel->getByBarcode($barCode);
			$this->response($data, REST_Controller::HTTP_OK);
		} elseif ($id > 0) {
			// $this->ProductsModel->get($id, $subcategoryId);
			$data = $this->ProductsModel->getByProductId($id);
			$this->response($data, REST_Controller::HTTP_OK);
		} else {
			$status = REST_Controller::HTTP_BAD_REQUEST;
			$response = ['status' => $status, 'error' => 'Barcode invalid!'];
			$this->response($response, $status);
		}
	}
}
