<?php

require APPPATH . 'controllers/Api.php';
class NIRs extends Api
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('NIRsUserModel');
		$this->load->model('ProductsModel');
		$this->load->model('PendingProductsModel');
	}

	public function index_get()
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		if ($app_id == 1) {
			$page = $this->input->get('Page');
			$number = $this->input->get('NumberOfItems');
			$result = $this->NIRsUserModel->get($data->id, $number, $page);
			$this->response($result, REST_Controller::HTTP_OK);
		} else {
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}

	public function single_get()
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		if ($app_id == 1) {
			$barCode = $this->input->get('BarCode');
			if (!empty($barCode) && $barCode != '') {
				$data = $this->NIRsUserModel->getByBarcode($barCode);
				$this->response($data, REST_Controller::HTTP_OK);
			} else {
				$status = REST_Controller::HTTP_BAD_REQUEST;
				$response = ['status' => $status, 'error' => 'Barcode invalid!'];
				$this->response($response, $status);
			}
		} else {
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}
	public function index_put()
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		if ($app_id == 1) {
			$input = (object)$this->put();
			$nirStatus = parent::nirStatus();
			if (!empty($input) && !empty($input->Name) && !empty($input->BarCode) && $nirStatus == 1) {
				$pendingProd = (object)array(
					'UserId' => $data->id,
					'Denumire' => $input->Name,
					'CodBare' => $input->BarCode
				);
				$pendingId = $this->PendingProductsModel->post($pendingProd);
				if (!empty($pendingId)) {
					$nirUser = (object)array(
						'UserId' => $data->id,
						'PendingId' => $pendingId,
						'Quantity' => $input->Quantity,
						'Value' => $input->Value,
					);
					$result = $this->NIRsUserModel->post($nirUser);
					$this->response($result, REST_Controller::HTTP_OK);
				} else {
					$this->response($input, REST_Controller::HTTP_BAD_REQUEST);
				}
			} else {
				$this->response($input, REST_Controller::HTTP_BAD_REQUEST);
			}
		} else {
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}
	public function index_post()
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		if ($app_id == 1) {
			$input = (object)$this->post();
			$nirStatus = parent::nirStatus();
			if (!empty($input) && $nirStatus == 1) {
				if (!empty($input->ProductId)) {
					$product = (object)$this->ProductsModel->get($input->ProductId, -1);
					if (!empty($product) && !empty($product->ID)) {
						$nirUser = (object)array(
							'UserId' => $data->id,
							'ProductId' => $input->ProductId,
							'Quantity' => $input->Quantity,
							'Value' => $input->Value,
						);
						if (empty($input->Id))
							$result = $this->NIRsUserModel->post($nirUser);
						else
							$result = $this->NIRsUserModel->put($nirUser, $input->Id);
						$this->response($result, REST_Controller::HTTP_OK);
					} else {
						$this->response($input, REST_Controller::HTTP_BAD_REQUEST);
					}
				} else if (!empty($input->PendingId)) {
					$product = $this->PendingProductsModel->get($input->PendingId);
					if (!empty($product) && !empty($product->Id)) {
						$nirUser = (object)array(
							'UserId' => $data->id,
							'PendingId' => $input->PendingId,
							'Quantity' => $input->Quantity,
							'Value' => $input->Value,
						);
						if (empty($input->Id))
							$result = $this->NIRsUserModel->post($nirUser);
						else
							$result = $this->NIRsUserModel->put($nirUser, $input->Id);
						$this->response($result, REST_Controller::HTTP_OK);
					} else {
						$this->response($input, REST_Controller::HTTP_BAD_REQUEST);
					}
				} else {
					$this->response($input, REST_Controller::HTTP_BAD_REQUEST);
				}
			} else {
				$this->response($input, REST_Controller::HTTP_BAD_REQUEST);
			}
		} else {
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}
}
