<?php

require APPPATH . 'controllers/Api.php';
class InventoryUser extends Api
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('InventoryUserModel');
	}

	public function index_get()
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		if ($app_id == 1) {
			$page = $this->input->get('Page');
			$number = $this->input->get('NumberOfItems');
			$result = $this->InventoryUserModel->get($data->id, $number, $page);
			$this->response($result, REST_Controller::HTTP_OK);
		} else {
			$status = parent::HTTP_UNAUTHORIZED;
			$response = ['status' => $status, 'error' => 'Unauthorized Access! '];
			$this->response($response, $status);
			$this->output->_display();
			exit();
		}
	}
}
