<?php

require APPPATH . 'controllers/Api.php';
class Calls extends Api
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('CallsModel');
	}

	public function index_post()
	{
		$data = parent::verify_request();
		$app_id = parent::verify_app_id();
		$input = (object)$this->post();
		if ($app_id == 5) {
			$valid_number = $this->valid_phone_number_or_empty($input->Caller);
			if (!empty($input) && !empty($valid_number)) {
				if ($valid_number[0] === '+') {
					$valid_number = substr($valid_number, 2);
				}
				$call = (object)array(
					'UserId' => $data->id,
					'PhoneNumber' => $data->phone,
					'Caller' => $valid_number

				);
				$result = $this->CallsModel->post($call);
				$this->response($result, REST_Controller::HTTP_OK);
			} else {
				$this->response($input, REST_Controller::HTTP_BAD_REQUEST);
			}
		} else {
			$this->response($input, REST_Controller::HTTP_BAD_REQUEST);
		}
	}
	function valid_phone_number_or_empty($value)
	{
		$value = str_replace(' ', '', $value);
		$valid_number = filter_var($value, FILTER_SANITIZE_NUMBER_INT);
		if ($valid_number != $value) {
			return '';
		}
		$phone_to_check = str_replace("-", "", $valid_number);
		if (strlen($phone_to_check) < 10 || strlen($phone_to_check) > 14) {
			return '';
		} else {
			return $phone_to_check;
		}
	}
}
